/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.launch.ContainerLauncher;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderService;
import org.apache.slider.server.appmaster.actions.ActionStartContainer;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.ContainerAssignment;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.apache.slider.server.services.workflow.WorkflowExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleLaunchService
extends WorkflowExecutorService<ExecutorService> {
    protected static final Logger log = LoggerFactory.getLogger(RoleLaunchService.class);
    public static final String ROLE_LAUNCH_SERVICE = "RoleLaunchService";
    private final QueueAccess actionQueue;
    private final ProviderService provider;
    private final SliderFileSystem fs;
    private final Path generatedConfDirPath;
    private final Path launcherTmpDirPath;
    private Map<String, String> envVars;

    public RoleLaunchService(QueueAccess queueAccess, ProviderService provider, SliderFileSystem fs, Path generatedConfDirPath, Map<String, String> envVars, Path launcherTmpDirPath) {
        super(ROLE_LAUNCH_SERVICE);
        this.actionQueue = queueAccess;
        this.fs = fs;
        this.generatedConfDirPath = generatedConfDirPath;
        this.launcherTmpDirPath = launcherTmpDirPath;
        this.provider = provider;
        this.envVars = envVars;
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.setExecutor(Executors.newCachedThreadPool(new ServiceThreadFactory(ROLE_LAUNCH_SERVICE, true)));
    }

    public void launchRole(ContainerAssignment assignment, AggregateConf clusterSpec, Credentials credentials) {
        RoleStatus role = assignment.role;
        String roleName = role.getName();
        String roleGroup = role.getGroup();
        Preconditions.checkArgument((boolean)this.provider.isSupportedRole(roleName));
        RoleLauncher launcher = new RoleLauncher(assignment, clusterSpec, clusterSpec.getResourceOperations().getOrAddComponent(roleGroup), clusterSpec.getAppConfOperations().getOrAddComponent(roleGroup), credentials);
        this.execute(launcher);
    }

    private class RoleLauncher
    implements Runnable {
        private final ContainerAssignment assignment;
        public final Container container;
        private final MapOperations resourceComponent;
        private final MapOperations appComponent;
        private final AggregateConf instanceDefinition;
        public final ProviderRole role;
        private final Credentials credentials;
        private Exception raisedException;

        public RoleLauncher(ContainerAssignment assignment, AggregateConf instanceDefinition, MapOperations resourceComponent, MapOperations appComponent, Credentials credentials) {
            this.assignment = assignment;
            this.credentials = credentials;
            this.container = assignment.container;
            RoleStatus roleStatus = assignment.role;
            assert (resourceComponent != null);
            assert (appComponent != null);
            ProviderRole providerRole = roleStatus.getProviderRole();
            assert (providerRole != null);
            this.role = providerRole;
            this.resourceComponent = resourceComponent;
            this.appComponent = appComponent;
            this.instanceDefinition = instanceDefinition;
        }

        public Exception getRaisedException() {
            return this.raisedException;
        }

        public String toString() {
            return "RoleLauncher{container=" + this.container.getId() + ", containerRole='" + this.role.name + '\'' + ", containerGroup='" + this.role.group + '\'' + '}';
        }

        @Override
        public void run() {
            try {
                ContainerLauncher containerLauncher = new ContainerLauncher(RoleLaunchService.this.getConfig(), RoleLaunchService.this.fs, this.container, this.credentials);
                containerLauncher.setupUGI();
                containerLauncher.putEnv(RoleLaunchService.this.envVars);
                log.debug("Launching container {} into role {}", (Object)this.container.getId(), (Object)this.role.name);
                Path containerTmpDirPath = new Path(RoleLaunchService.this.launcherTmpDirPath, this.container.getId().toString());
                RoleLaunchService.this.provider.buildContainerLaunchContext(containerLauncher, this.instanceDefinition, this.container, this.role, RoleLaunchService.this.fs, RoleLaunchService.this.generatedConfDirPath, this.resourceComponent, this.appComponent, containerTmpDirPath);
                RoleInstance instance = new RoleInstance(this.container);
                String[] envDescription = containerLauncher.dumpEnvToString();
                String commandsAsString = containerLauncher.getCommandsAsString();
                log.info("Starting container with command: {}", (Object)commandsAsString);
                instance.command = commandsAsString;
                instance.role = this.role.name;
                instance.group = this.role.group;
                instance.roleId = this.role.id;
                instance.appVersion = this.instanceDefinition.getAppConfOperations().getGlobalOptions().get("site.global.app_version");
                instance.environment = envDescription;
                int delay = this.appComponent.getOptionInt("container.launch.delay.sec", 0);
                int maxDelay = RoleLaunchService.this.getConfig().getInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 600000);
                if (delay > maxDelay / 1000) {
                    log.warn("Container launch delay of {} exceeds the maximum allowed of {} seconds.  Delay will not be utilized.", (Object)delay, (Object)(maxDelay / 1000));
                    delay = 0;
                }
                log.info("Container launch delay for {} set to {} seconds", (Object)this.role.name, (Object)delay);
                RoleLaunchService.this.actionQueue.schedule(new ActionStartContainer("starting " + this.role.name, this.container, containerLauncher.completeContainerLaunch(), instance, delay, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                log.error("Exception thrown while trying to start {}: {}", new Object[]{this.role.name, e, e});
                this.raisedException = e;
            }
        }
    }
}

