/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.management.resources;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.server.appmaster.web.rest.management.resources.ConfTreeResource;
import org.apache.slider.server.appmaster.web.rest.management.resources.ResourceFactory;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class AggregateConfResource {
    private String href;
    private final ConfTreeResource resources;
    private final ConfTreeResource internal;
    private final ConfTreeResource appConf;
    @JsonIgnore
    private Map<String, ConfTreeResource> confMap;

    public AggregateConfResource(AggregateConf conf, UriBuilder uriBuilder) {
        if (uriBuilder != null) {
            this.href = uriBuilder.build(new Object[0]).toASCIIString();
            this.resources = ResourceFactory.createConfTreeResource(conf.getResources(), uriBuilder.clone().path("configurations").path("resources"));
            this.internal = ResourceFactory.createConfTreeResource(conf.getInternal(), uriBuilder.clone().path("configurations").path("internal"));
            this.appConf = ResourceFactory.createConfTreeResource(conf.getAppConf(), uriBuilder.clone().path("configurations").path("appConf"));
            this.initConfMap();
        } else {
            this.resources = null;
            this.internal = null;
            this.appConf = null;
        }
    }

    private void initConfMap() {
        this.confMap = new HashMap<String, ConfTreeResource>();
        this.confMap.put("internal", this.internal);
        this.confMap.put("resources", this.resources);
        this.confMap.put("appConf", this.appConf);
    }

    public AggregateConfResource() {
        this(null, null);
    }

    public ConfTreeResource getConfTree(String name) {
        return this.confMap.get(name);
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ConfTreeResource getResources() {
        return this.resources;
    }

    public ConfTreeResource getInternal() {
        return this.internal;
    }

    public ConfTreeResource getAppConf() {
        return this.appConf;
    }
}

