/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.slider.server.services.workflow.ServiceParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSequenceService
extends AbstractService
implements ServiceParent,
ServiceStateChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowSequenceService.class);
    private final List<Service> serviceList = new ArrayList<Service>();
    private volatile Service activeService;
    private volatile Service previousService;
    private boolean stopIfNoChildServicesAtStartup = true;

    public WorkflowSequenceService(String name) {
        super(name);
    }

    public WorkflowSequenceService() {
        this("WorkflowSequenceService");
    }

    public WorkflowSequenceService(String name, Service ... children) {
        super(name);
        Service[] serviceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            this.addService(service);
            ++n2;
        }
    }

    public WorkflowSequenceService(String name, List<Service> children) {
        super(name);
        for (Service service : children) {
            this.addService(service);
        }
    }

    public Service getActiveService() {
        return this.activeService;
    }

    public Service getPreviousService() {
        return this.previousService;
    }

    protected void setStopIfNoChildServicesAtStartup(boolean stopIfNoChildServicesAtStartup) {
        this.stopIfNoChildServicesAtStartup = stopIfNoChildServicesAtStartup;
    }

    protected void serviceStart() throws Exception {
        if (!this.startNextService() && this.stopIfNoChildServicesAtStartup) {
            this.stop();
        }
    }

    protected void serviceStop() throws Exception {
        Service current;
        this.previousService = current = this.activeService;
        this.activeService = null;
        if (current != null) {
            current.stop();
        }
    }

    public synchronized boolean startNextService() {
        if (this.isInState(Service.STATE.STOPPED)) {
            LOG.debug("Not starting next service -{} is stopped", (Object)this);
            return false;
        }
        if (!this.isInState(Service.STATE.STARTED)) {
            throw new ServiceStateException("Cannot start a child service when not started");
        }
        if (this.serviceList.isEmpty()) {
            return false;
        }
        if (this.activeService != null && this.activeService.getFailureCause() != null) {
            LOG.debug("Not starting next service due to a failure of {}", (Object)this.activeService);
            return false;
        }
        this.activeService = null;
        Service head = this.serviceList.remove(0);
        try {
            head.init(this.getConfig());
            head.registerServiceListener((ServiceStateChangeListener)this);
            head.start();
        }
        catch (RuntimeException e) {
            this.noteFailure(e);
            throw e;
        }
        this.activeService = head;
        return true;
    }

    public void stateChanged(Service service) {
        if (service == this.activeService && service.isInState(Service.STATE.STOPPED)) {
            this.onServiceCompleted(service);
        }
    }

    protected synchronized void onServiceCompleted(Service service) {
        LOG.info("Running service stopped: {}", (Object)service);
        this.previousService = this.activeService;
        if (this.isInState(Service.STATE.STARTED)) {
            boolean started;
            Throwable failureCause = service.getFailureCause();
            if (failureCause != null) {
                Exception e = failureCause instanceof Exception ? (Exception)failureCause : new Exception(failureCause);
                this.noteFailure(e);
                this.stop();
            }
            try {
                started = this.startNextService();
            }
            catch (Exception e) {
                this.noteFailure(e);
                started = false;
            }
            if (!started) {
                this.stop();
            }
        } else {
            this.activeService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addService(Service service) {
        Preconditions.checkArgument((service != null ? 1 : 0) != 0, (Object)"null service argument");
        LOG.debug("Adding service {} ", (Object)service.getName());
        List<Service> list = this.serviceList;
        synchronized (list) {
            this.serviceList.add(service);
        }
    }

    @Override
    public synchronized List<Service> getServices() {
        return Collections.unmodifiableList(this.serviceList);
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "; current service " + this.activeService + "; queued service count=" + this.serviceList.size();
    }
}

