/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubTreeOperationsContext
extends BaseEntityContext<String, SubTreeOperation> {
    private final OngoingSubTreeOpsDataAccess<SubTreeOperation> dataAccess;
    private final Map<String, Collection<SubTreeOperation>> pathToSubTreeOperation = new HashMap<String, Collection<SubTreeOperation>>();

    public SubTreeOperationsContext(OngoingSubTreeOpsDataAccess<SubTreeOperation> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(SubTreeOperation hopSubTeeOperation) throws TransactionContextException {
        super.update((Object)hopSubTeeOperation);
        this.addInternal(hopSubTeeOperation);
        if (this.isLogTraceEnabled()) {
            this.log("updated-sub-tree-op", new Object[]{"path", hopSubTeeOperation.getPath(), "nnid", hopSubTeeOperation.getNameNodeId(), "op", hopSubTeeOperation.getOpType()});
        }
    }

    public void remove(SubTreeOperation hopSubTeeOperation) throws TransactionContextException {
        super.forceRemove((Object)hopSubTeeOperation);
        if (this.isLogTraceEnabled()) {
            this.log("removed-sub-tree-op", new Object[]{"path", hopSubTeeOperation.getPath(), "nnid", hopSubTeeOperation.getNameNodeId(), "op", hopSubTeeOperation.getOpType()});
        }
    }

    public SubTreeOperation find(FinderType<SubTreeOperation> finder, Object ... params) throws TransactionContextException, StorageException {
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<SubTreeOperation> findList(FinderType<SubTreeOperation> finder, Object ... params) throws TransactionContextException, StorageException {
        SubTreeOperation.Finder lFinder = (SubTreeOperation.Finder)finder;
        switch (lFinder) {
            case ByPathPrefix: {
                return this.findByPathPrefix(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.pathToSubTreeOperation.clear();
    }

    String getKey(SubTreeOperation hopSubTeeOperation) {
        return hopSubTeeOperation.getPath();
    }

    private Collection<SubTreeOperation> findByPathPrefix(SubTreeOperation.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String prefix = (String)params[0];
        Collection result = null;
        if (this.pathToSubTreeOperation.containsKey(prefix)) {
            result = this.pathToSubTreeOperation.get(prefix);
            this.hit((FinderType)lFinder, result, new Object[]{"Path Prefix", prefix, "numOfOps", result.size()});
        } else {
            this.aboutToAccessStorage((FinderType)lFinder, params);
            result = this.dataAccess.findByPathsByPrefix(prefix);
            this.gotFromDBInternal(prefix, result);
            this.miss((FinderType)lFinder, result, new Object[]{"Path Prefix", prefix, "numOfOps", result.size()});
        }
        return result;
    }

    void gotFromDB(Collection<SubTreeOperation> subTreeOps) {
        super.gotFromDB(subTreeOps);
    }

    private void gotFromDBInternal(String pathPrefix, Collection<SubTreeOperation> subTreeOps) {
        this.gotFromDB(subTreeOps);
        this.addInternal(pathPrefix, subTreeOps);
    }

    private void addInternal(String prefix, Collection<SubTreeOperation> subTreeOps) {
        Collection<SubTreeOperation> list = this.pathToSubTreeOperation.get(prefix);
        if (list == null) {
            list = new ArrayList<SubTreeOperation>();
            this.pathToSubTreeOperation.put(prefix, list);
        }
        if (subTreeOps != null) {
            list.addAll(subTreeOps);
            this.pathToSubTreeOperation.put(prefix, list);
        }
    }

    private void addInternal(SubTreeOperation op) {
        ArrayList<SubTreeOperation> list = new ArrayList<SubTreeOperation>();
        list.add(op);
        this.addInternal(op.getPath(), list);
    }
}

