/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.ByteBufferUtil;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.IdentityHashStore;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class DFSInputStream
extends FSInputStream
implements ByteBufferReadable,
CanSetDropBehind,
CanSetReadahead,
HasEnhancedByteBufferAccess,
CanUnbuffer {
    @VisibleForTesting
    public static boolean tcpReadsDisabledForTesting = false;
    private long hedgedReadOpsLoopNumForTesting = 0L;
    private final DFSClient dfsClient;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final String src;
    private final boolean verifyChecksum;
    private DatanodeInfo currentNode = null;
    private LocatedBlock currentLocatedBlock = null;
    private long pos = 0L;
    private long blockEnd = -1L;
    private BlockReader blockReader = null;
    private LocatedBlocks locatedBlocks = null;
    private long lastBlockBeingWrittenLength = 0L;
    private CachingStrategy cachingStrategy;
    private final ReadStatistics readStatistics = new ReadStatistics();
    private boolean emulateHdfsClient = false;
    private final Object infoLock = new Object();
    private IdentityHashStore<ByteBuffer, Object> extendedReadBuffers;
    private int failures = 0;
    private final ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
    private byte[] oneByteBuf;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).asReadOnlyBuffer();

    private synchronized IdentityHashStore<ByteBuffer, Object> getExtendedReadBuffers() {
        if (this.extendedReadBuffers == null) {
            this.extendedReadBuffers = new IdentityHashStore(0);
        }
        return this.extendedReadBuffers;
    }

    void addToDeadNodes(DatanodeInfo dnInfo) {
        this.deadNodes.put(dnInfo, dnInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DFSInputStream(DFSClient dfsClient, String src, boolean verifyChecksum, boolean emulateHdfsClient) throws IOException, UnresolvedLinkException {
        this.dfsClient = dfsClient;
        this.verifyChecksum = verifyChecksum;
        this.src = src;
        this.emulateHdfsClient = emulateHdfsClient;
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = dfsClient.getDefaultReadCachingStrategy();
        }
        this.openInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openInfo() throws IOException, UnresolvedLinkException {
        Object object = this.infoLock;
        synchronized (object) {
            int retriesForLastBlockLength;
            this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength();
            for (retriesForLastBlockLength = this.dfsClient.getConf().retryTimesForGetLastBlockLength; retriesForLastBlockLength > 0 && this.lastBlockBeingWrittenLength == -1L; --retriesForLastBlockLength) {
                DFSClient.LOG.warn((Object)("Last block locations not available. Datanodes might not have reported blocks completely. Will retry for " + retriesForLastBlockLength + " times"));
                this.waitFor(this.dfsClient.getConf().retryIntervalForGetLastBlockLength);
                this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength();
            }
            if (retriesForLastBlockLength == 0) {
                throw new IOException("Could not obtain the last block locations.");
            }
        }
    }

    private void waitFor(int waitTime) throws IOException {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while getting the last block length.");
        }
    }

    private long fetchLocatedBlocksAndGetLastBlockLength() throws IOException {
        LocatedBlock last;
        LocatedBlocks newInfo = this.dfsClient.getLocatedBlocks(this.src, 0L);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("newInfo = " + newInfo));
        }
        if (newInfo == null) {
            throw new IOException("Cannot open filename " + this.src);
        }
        if (this.locatedBlocks != null) {
            Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
            Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
            while (oldIter.hasNext() && newIter.hasNext()) {
                if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                throw new IOException("Blocklist for " + this.src + " has changed!");
            }
        }
        this.locatedBlocks = newInfo;
        long lastBlockBeingWrittenLength = 0L;
        if (!this.locatedBlocks.isLastBlockComplete() && (last = this.locatedBlocks.getLastLocatedBlock()) != null) {
            if (last.getLocations().length == 0) {
                if (last.getBlockSize() == 0L) {
                    return 0L;
                }
                return -1L;
            }
            long len = this.readBlockLength(last);
            last.getBlock().setNumBytes(len);
            lastBlockBeingWrittenLength = len;
        }
        return lastBlockBeingWrittenLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readBlockLength(LocatedBlock locatedblock) throws IOException {
        assert (locatedblock != null) : "LocatedBlock cannot be null";
        int replicaNotFoundCount = locatedblock.getLocations().length;
        DatanodeInfo[] datanodeInfoArray = locatedblock.getLocations();
        int n = datanodeInfoArray.length;
        int n2 = 0;
        while (true) {
            block13: {
                ClientDatanodeProtocol cdp;
                block14: {
                    long l;
                    block12: {
                        if (n2 >= n) {
                            if (replicaNotFoundCount != 0) throw new IOException("Cannot obtain block length for " + locatedblock);
                            return 0L;
                        }
                        DatanodeInfo datanode = datanodeInfoArray[n2];
                        cdp = null;
                        try {
                            cdp = DFSUtil.createClientDatanodeProtocolProxy(datanode, this.dfsClient.getConfiguration(), this.dfsClient.getConf().socketTimeout, this.dfsClient.getConf().connectToDnViaHostname, locatedblock);
                            long n3 = cdp.getReplicaVisibleLength(locatedblock.getBlock());
                            if (n3 >= 0L) {
                                l = n3;
                                if (cdp == null) return l;
                                break block12;
                            }
                            if (cdp == null) break block13;
                            break block14;
                        }
                        catch (IOException ioe) {
                            if (ioe instanceof RemoteException && ((RemoteException)((Object)ioe)).unwrapRemoteException() instanceof ReplicaNotFoundException) {
                                --replicaNotFoundCount;
                            }
                            if (DFSClient.LOG.isDebugEnabled()) {
                                DFSClient.LOG.debug((Object)("Failed to getReplicaVisibleLength from datanode " + datanode + " for block " + locatedblock.getBlock()), (Throwable)ioe);
                            }
                            break block13;
                        }
                    }
                    RPC.stopProxy((Object)cdp);
                    return l;
                }
                RPC.stopProxy((Object)cdp);
                break block13;
                finally {
                    if (cdp != null) {
                        RPC.stopProxy(cdp);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength() + this.lastBlockBeingWrittenLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shortCircuitForbidden() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks.isUnderConstruction();
        }
    }

    public synchronized DatanodeInfo getCurrentDatanode() {
        return this.currentNode;
    }

    public synchronized ExtendedBlock getCurrentBlock() {
        if (this.currentLocatedBlock == null) {
            return null;
        }
        return this.currentLocatedBlock.getBlock();
    }

    public List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getBlockRange(0L, this.getFileLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlock getBlockAt(long offset, boolean updatePosition) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            LocatedBlock blk;
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            if (offset < 0L || offset >= this.getFileLength()) {
                throw new IOException("offset < 0 || offset >= getFileLength(), offset=" + offset + ", updatePosition=" + updatePosition + ", locatedBlocks=" + this.locatedBlocks);
            }
            if (offset >= this.locatedBlocks.getFileLength()) {
                blk = this.locatedBlocks.getLastLocatedBlock();
            } else {
                int targetBlockIdx = this.locatedBlocks.findBlock(offset);
                if (targetBlockIdx < 0) {
                    targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                    LocatedBlocks newBlocks = this.dfsClient.getLocatedBlocks(this.src, offset);
                    assert (newBlocks != null) : "Could not find target position " + offset;
                    this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
                }
                blk = this.locatedBlocks.get(targetBlockIdx);
            }
            if (updatePosition) {
                DFSInputStream dFSInputStream = this;
                synchronized (dFSInputStream) {
                    this.pos = offset;
                    this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
                    this.currentLocatedBlock = blk;
                }
            }
            return blk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBlockAt(long offset) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            LocatedBlocks newBlocks;
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
            }
            if ((newBlocks = this.dfsClient.getLocatedBlocks(this.src, offset)) == null) {
                throw new IOException("Could not find target position " + offset);
            }
            this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
        if (offset >= this.getFileLength()) {
            throw new IOException("Offset: " + offset + " exceeds file length: " + this.getFileLength());
        }
        Object object = this.infoLock;
        synchronized (object) {
            long lengthOfCompleteBlk = this.locatedBlocks.getFileLength();
            boolean readOffsetWithinCompleteBlk = offset < lengthOfCompleteBlk;
            boolean readLengthPastCompleteBlk = offset + length > lengthOfCompleteBlk;
            List<LocatedBlock> blocks = readOffsetWithinCompleteBlk ? this.getFinalizedBlockRange(offset, Math.min(length, lengthOfCompleteBlk - offset)) : new ArrayList<LocatedBlock>(1);
            if (readLengthPastCompleteBlk) {
                blocks.add(this.locatedBlocks.getLastLocatedBlock());
            }
            return blocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getFinalizedBlockRange(long offset, long length) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
            int blockIdx = this.locatedBlocks.findBlock(offset);
            if (blockIdx < 0) {
                blockIdx = LocatedBlocks.getInsertIndex(blockIdx);
            }
            long remaining = length;
            long curOff = offset;
            while (remaining > 0L) {
                LocatedBlock blk = null;
                if (blockIdx < this.locatedBlocks.locatedBlockCount()) {
                    blk = this.locatedBlocks.get(blockIdx);
                }
                if (blk == null || curOff < blk.getStartOffset()) {
                    LocatedBlocks newBlocks = this.dfsClient.getLocatedBlocks(this.src, curOff, remaining);
                    this.locatedBlocks.insertRange(blockIdx, newBlocks.getLocatedBlocks());
                    continue;
                }
                assert (curOff >= blk.getStartOffset()) : "Block not found";
                blockRange.add(blk);
                long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
                remaining -= bytesRead;
                curOff += bytesRead;
                ++blockIdx;
            }
            return blockRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        this.closeCurrentBlockReader();
        DatanodeInfo chosenNode = null;
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        boolean connectFailedOnce = false;
        while (true) {
            LocatedBlock targetBlock = this.getBlockAt(target, true);
            assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DNAddrPair retval = this.chooseDataNode(targetBlock, null);
            chosenNode = retval.info;
            InetSocketAddress targetAddr = retval.addr;
            try {
                boolean shortCircuitForbidden;
                CachingStrategy curCachingStrategy;
                ExtendedBlock blk = targetBlock.getBlock();
                Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
                Object object = this.infoLock;
                synchronized (object) {
                    curCachingStrategy = this.cachingStrategy;
                    shortCircuitForbidden = this.shortCircuitForbidden();
                }
                this.blockReader = new BlockReaderFactory(this.dfsClient.getConf()).setInetSocketAddress(targetAddr).setRemotePeerFactory(this.dfsClient).setDatanodeInfo(chosenNode).setFileName(this.src).setLocatedBlock(targetBlock).setBlockToken(accessToken).setStartOffset(offsetIntoBlock).setVerifyChecksum(this.verifyChecksum).setClientName(this.dfsClient.clientName).setLength(blk.getNumBytes() - offsetIntoBlock).setCachingStrategy(curCachingStrategy).setAllowShortCircuitLocalReads(!shortCircuitForbidden).setClientCacheContext(this.dfsClient.getClientContext()).setUserGroupInformation(this.dfsClient.ugi).setConfiguration(this.dfsClient.getConfiguration()).setTracer(this.dfsClient.getTracer()).setEmulateHdfsClient(this.emulateHdfsClient).build();
                if (connectFailedOnce) {
                    DFSClient.LOG.info((Object)("Successfully connected to " + targetAddr + " for " + blk));
                }
                return chosenNode;
            }
            catch (IOException ex) {
                if (ex instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info((Object)("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + targetAddr + " : " + ex));
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                    continue;
                }
                if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(ex, targetAddr)) {
                    --refetchToken;
                    this.fetchBlockAt(target);
                    continue;
                }
                connectFailedOnce = true;
                DFSClient.LOG.warn((Object)("Failed to connect to " + targetAddr + " for block, add to deadNodes and continue. " + ex), (Throwable)ex);
                this.addToDeadNodes(chosenNode);
                continue;
            }
            break;
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            DFSClient.LOG.warn((Object)"DFSInputStream has been closed already");
            return;
        }
        this.dfsClient.checkOpen();
        if (this.extendedReadBuffers != null && !this.extendedReadBuffers.isEmpty()) {
            final StringBuilder builder = new StringBuilder();
            this.extendedReadBuffers.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<ByteBuffer, Object>(){
                private String prefix = "";

                public void accept(ByteBuffer k, Object v) {
                    builder.append(this.prefix).append(k);
                    this.prefix = ", ";
                }
            });
            DFSClient.LOG.warn((Object)("closing file " + this.src + ", but there are still unreleased ByteBuffers allocated by read().  Please release " + builder.toString() + "."));
        }
        this.closeCurrentBlockReader();
        super.close();
    }

    public synchronized int read() throws IOException {
        int ret;
        if (this.oneByteBuf == null) {
            this.oneByteBuf = new byte[1];
        }
        return (ret = this.read(this.oneByteBuf, 0, 1)) <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReadStatistics(ReadStatistics readStatistics, int nRead, BlockReader blockReader) {
        if (nRead <= 0) {
            return;
        }
        Object object = this.infoLock;
        synchronized (object) {
            if (blockReader.isShortCircuit()) {
                readStatistics.addShortCircuitBytes(nRead);
            } else if (blockReader.isLocal()) {
                readStatistics.addLocalBytes(nRead);
            } else {
                readStatistics.addRemoteBytes(nRead);
            }
        }
    }

    private synchronized int readBuffer(ReaderStrategy reader, int off, int len, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        boolean retryCurrentNode = true;
        while (true) {
            Throwable ioe;
            try {
                return reader.doRead(this.blockReader, off, len);
            }
            catch (ChecksumException ce) {
                DFSClient.LOG.warn((Object)("Found Checksum error for " + this.getCurrentBlock() + " from " + this.currentNode + " at " + ce.getPos()));
                ioe = ce;
                retryCurrentNode = false;
                this.addIntoCorruptedBlockMap(this.getCurrentBlock(), this.currentNode, corruptedBlockMap);
            }
            catch (IOException e) {
                if (!retryCurrentNode) {
                    DFSClient.LOG.warn((Object)("Exception while reading from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode), (Throwable)e);
                }
                ioe = e;
            }
            boolean sourceFound = false;
            if (retryCurrentNode) {
                sourceFound = this.seekToBlockSource(this.pos);
            } else {
                this.addToDeadNodes(this.currentNode);
                sourceFound = this.seekToNewSource(this.pos);
            }
            if (!sourceFound) {
                throw ioe;
            }
            retryCurrentNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int readWithStrategy(ReaderStrategy strategy, int off, int len) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        this.failures = 0;
        if (this.pos < this.getFileLength()) {
            int retries = 2;
            while (retries > 0) {
                try {
                    if (this.pos > this.blockEnd || this.currentNode == null) {
                        this.currentNode = this.blockSeekTo(this.pos);
                    }
                    int realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L);
                    Object object = this.infoLock;
                    synchronized (object) {
                        if (this.locatedBlocks.isLastBlockComplete()) {
                            realLen = (int)Math.min((long)realLen, this.locatedBlocks.getFileLength() - this.pos);
                        }
                    }
                    int result = this.readBuffer(strategy, off, realLen, corruptedBlockMap);
                    if (result >= 0) {
                        this.pos += (long)result;
                    } else {
                        throw new IOException("Unexpected EOS from the reader");
                    }
                    if (this.dfsClient.stats != null) {
                        this.dfsClient.stats.incrementBytesRead((long)result);
                    }
                    int n = result;
                    return n;
                }
                catch (ChecksumException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    if (retries == 1) {
                        DFSClient.LOG.warn((Object)"DFS Read", (Throwable)e);
                    }
                    this.blockEnd = -1L;
                    if (this.currentNode != null) {
                        this.addToDeadNodes(this.currentNode);
                    }
                    if (--retries != 0) continue;
                    throw e;
                }
                finally {
                    this.reportCheckSumFailure(corruptedBlockMap, this.currentLocatedBlock.getLocations().length);
                }
            }
        }
        return -1;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        ByteArrayStrategy byteArrayReader = new ByteArrayStrategy(buf);
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteArrayRead", this.src);){
            int n = this.readWithStrategy(byteArrayReader, off, len);
            return n;
        }
    }

    public synchronized int read(ByteBuffer buf) throws IOException {
        ByteBufferStrategy byteBufferReader = new ByteBufferStrategy(buf);
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteBufferRead", this.src);){
            int n = this.readWithStrategy(byteBufferReader, 0, buf.remaining());
            return n;
        }
    }

    private void addIntoCorruptedBlockMap(ExtendedBlock blk, DatanodeInfo node, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) {
        Set<Object> dnSet = null;
        dnSet = corruptedBlockMap.containsKey(blk) ? corruptedBlockMap.get(blk) : new HashSet();
        if (!dnSet.contains(node)) {
            dnSet.add(node);
            corruptedBlockMap.put(blk, dnSet);
        }
    }

    private DNAddrPair chooseDataNode(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        while (true) {
            DatanodeInfo[] nodes = block.getLocations();
            try {
                return this.getBestNodeDNAddrPair(nodes, ignoredNodes);
            }
            catch (IOException ie) {
                String errMsg = DFSInputStream.getBestNodeDNAddrPairErrorString(nodes, this.deadNodes, ignoredNodes);
                String blockInfo = block.getBlock() + " file=" + this.src;
                if (this.failures >= this.dfsClient.getMaxBlockAcquireFailures()) {
                    String description = "Could not obtain block: " + blockInfo;
                    DFSClient.LOG.warn((Object)(description + errMsg + ". Throwing a BlockMissingException"));
                    throw new BlockMissingException(this.src, description, block.getStartOffset());
                }
                if (nodes == null || nodes.length == 0) {
                    DFSClient.LOG.info((Object)("No node available for " + blockInfo));
                }
                DFSClient.LOG.info((Object)("Could not obtain " + block.getBlock() + " from any node: " + ie + errMsg + ". Will get new block locations from namenode and retry..."));
                try {
                    int timeWindow = this.dfsClient.getConf().timeWindow;
                    double waitTime = (double)(timeWindow * this.failures) + (double)(timeWindow * (this.failures + 1)) * DFSUtil.getRandom().nextDouble();
                    DFSClient.LOG.warn((Object)("DFS chooseDataNode: got # " + (this.failures + 1) + " IOException, will wait for " + waitTime + " msec."));
                    Thread.sleep((long)waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.deadNodes.clear();
                this.openInfo();
                block = this.getBlockAt(block.getStartOffset(), false);
                ++this.failures;
                continue;
            }
            break;
        }
    }

    private DNAddrPair getBestNodeDNAddrPair(DatanodeInfo[] nodes, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        DatanodeInfo chosenNode = DFSInputStream.bestNode(nodes, this.deadNodes, ignoredNodes);
        String dnAddr = chosenNode.getXferAddr(this.dfsClient.getConf().connectToDnViaHostname);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("Connecting to datanode " + dnAddr));
        }
        InetSocketAddress targetAddr = NetUtils.createSocketAddr((String)dnAddr);
        return new DNAddrPair(chosenNode, targetAddr);
    }

    private static String getBestNodeDNAddrPairErrorString(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes, Collection<DatanodeInfo> ignoredNodes) {
        StringBuilder errMsgr = new StringBuilder(" No live nodes contain current block ");
        errMsgr.append("Block locations:");
        for (DatanodeInfo datanode : nodes) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        errMsgr.append(" Dead nodes: ");
        for (DatanodeInfo datanode : deadNodes.keySet()) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        if (ignoredNodes != null) {
            errMsgr.append(" Ignored nodes: ");
            for (DatanodeInfo datanode : ignoredNodes) {
                errMsgr.append(" ");
                errMsgr.append(datanode.toString());
            }
        }
        return errMsgr.toString();
    }

    private void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        block = this.getBlockAt(block.getStartOffset(), false);
        while (true) {
            DNAddrPair addressPair = this.chooseDataNode(block, null);
            try {
                this.actualGetFromOneDataNode(addressPair, block, start, end, buf, offset, corruptedBlockMap);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private Callable<ByteBuffer> getFromOneDataNode(final DNAddrPair datanode, final LocatedBlock block, final long start, final long end, final ByteBuffer bb, final Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap, final int hedgedReadId) {
        final SpanId parentSpanId = Tracer.getCurrentSpanId();
        return new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() throws Exception {
                byte[] buf = bb.array();
                int offset = bb.position();
                try (TraceScope ignored = DFSInputStream.this.dfsClient.getTracer().newScope("hedgedRead" + hedgedReadId, parentSpanId);){
                    DFSInputStream.this.actualGetFromOneDataNode(datanode, block, start, end, buf, offset, corruptedBlockMap);
                    ByteBuffer byteBuffer = bb;
                    return byteBuffer;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualGetFromOneDataNode(DNAddrPair datanode, LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        DFSClientFaultInjector.get().startFetchFromDatanode();
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        while (true) {
            boolean allowShortCircuitLocalReads;
            CachingStrategy curCachingStrategy;
            block = this.getBlockAt(block.getStartOffset(), false);
            Object object = this.infoLock;
            synchronized (object) {
                curCachingStrategy = this.cachingStrategy;
                allowShortCircuitLocalReads = !this.shortCircuitForbidden();
            }
            DatanodeInfo chosenNode = datanode.info;
            InetSocketAddress targetAddr = datanode.addr;
            BlockReader reader = null;
            try {
                DFSClientFaultInjector.get().fetchFromDatanodeException();
                Token<BlockTokenIdentifier> blockToken = block.getBlockToken();
                int len = (int)(end - start + 1L);
                reader = new BlockReaderFactory(this.dfsClient.getConf()).setInetSocketAddress(targetAddr).setRemotePeerFactory(this.dfsClient).setDatanodeInfo(chosenNode).setFileName(this.src).setLocatedBlock(block).setBlockToken(blockToken).setStartOffset(start).setVerifyChecksum(this.verifyChecksum).setClientName(this.dfsClient.clientName).setLength(len).setCachingStrategy(curCachingStrategy).setAllowShortCircuitLocalReads(allowShortCircuitLocalReads).setClientCacheContext(this.dfsClient.getClientContext()).setUserGroupInformation(this.dfsClient.ugi).setConfiguration(this.dfsClient.getConfiguration()).setTracer(this.dfsClient.getTracer()).setEmulateHdfsClient(this.emulateHdfsClient).build();
                int nread = reader.readAll(buf, offset, len);
                this.updateReadStatistics(this.readStatistics, nread, reader);
                if (nread != len) {
                    throw new IOException("truncated return from reader.read(): excpected " + len + ", got " + nread);
                }
                DFSClientFaultInjector.get().readFromDatanodeDelay();
                return;
            }
            catch (ChecksumException e) {
                String msg = "fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + chosenNode;
                DFSClient.LOG.warn((Object)msg);
                this.addIntoCorruptedBlockMap(block.getBlock(), chosenNode, corruptedBlockMap);
                this.addToDeadNodes(chosenNode);
                throw new IOException(msg);
            }
            catch (IOException e) {
                if (e instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info((Object)("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + targetAddr + " : " + e));
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                    continue;
                }
                if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(e, targetAddr)) {
                    --refetchToken;
                    try {
                        this.fetchBlockAt(block.getStartOffset());
                    }
                    catch (IOException msg) {
                        // empty catch block
                    }
                    continue;
                }
                String msg = "Failed to connect to " + targetAddr + " for file " + this.src + " for block " + block.getBlock() + ":" + e;
                DFSClient.LOG.warn((Object)("Connection failure: " + msg), (Throwable)e);
                this.addToDeadNodes(chosenNode);
                throw new IOException(msg);
            }
            finally {
                if (reader == null) continue;
                reader.close();
                continue;
            }
            break;
        }
    }

    private void hedgedFetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        ArrayList<Future<ByteBuffer>> futures = new ArrayList<Future<ByteBuffer>>();
        ExecutorCompletionService<ByteBuffer> hedgedService = new ExecutorCompletionService<ByteBuffer>(this.dfsClient.getHedgedReadsThreadPool());
        ArrayList<DatanodeInfo> ignored = new ArrayList<DatanodeInfo>();
        ByteBuffer bb = null;
        int len = (int)(end - start + 1L);
        int hedgedReadId = 0;
        block = this.getBlockAt(block.getStartOffset(), false);
        while (true) {
            DNAddrPair chosenNode;
            block15: {
                Callable<ByteBuffer> getFromDataNodeCallable;
                ++this.hedgedReadOpsLoopNumForTesting;
                chosenNode = null;
                if (futures.isEmpty()) {
                    chosenNode = this.chooseDataNode(block, ignored);
                    bb = ByteBuffer.wrap(buf, offset, len);
                    getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlockMap, hedgedReadId++);
                    Future<ByteBuffer> firstRequest = hedgedService.submit(getFromDataNodeCallable);
                    futures.add(firstRequest);
                    try {
                        Future future = hedgedService.poll(this.dfsClient.getHedgedReadTimeout(), TimeUnit.MILLISECONDS);
                        if (future != null) {
                            future.get();
                            return;
                        }
                        if (DFSClient.LOG.isDebugEnabled()) {
                            DFSClient.LOG.debug((Object)("Waited " + this.dfsClient.getHedgedReadTimeout() + "ms to read from " + chosenNode.info + "; spawning hedged read"));
                        }
                        ignored.add(chosenNode.info);
                        this.dfsClient.getHedgedReadMetrics().incHedgedReadOps();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    continue;
                }
                try {
                    try {
                        chosenNode = this.getBestNodeDNAddrPair(block.getLocations(), ignored);
                    }
                    catch (IOException ioe) {
                        chosenNode = this.chooseDataNode(block, ignored);
                    }
                    bb = ByteBuffer.allocate(len);
                    getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlockMap, hedgedReadId++);
                    Future<ByteBuffer> oneMoreRequest = hedgedService.submit(getFromDataNodeCallable);
                    futures.add(oneMoreRequest);
                }
                catch (IOException ioe) {
                    if (!DFSClient.LOG.isDebugEnabled()) break block15;
                    DFSClient.LOG.debug((Object)("Failed getting node for hedged read: " + ioe.getMessage()));
                }
            }
            try {
                ByteBuffer result = this.getFirstToComplete(hedgedService, futures);
                this.cancelAll(futures);
                if (result.array() != buf) {
                    this.dfsClient.getHedgedReadMetrics().incHedgedReadWins();
                    System.arraycopy(result.array(), result.position(), buf, offset, len);
                } else {
                    this.dfsClient.getHedgedReadMetrics().incHedgedReadOps();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                if (chosenNode == null || chosenNode.info == null) continue;
                ignored.add(chosenNode.info);
                continue;
            }
            break;
        }
    }

    @VisibleForTesting
    public long getHedgedReadOpsLoopNumForTesting() {
        return this.hedgedReadOpsLoopNumForTesting;
    }

    private ByteBuffer getFirstToComplete(CompletionService<ByteBuffer> hedgedService, ArrayList<Future<ByteBuffer>> futures) throws InterruptedException {
        if (futures.isEmpty()) {
            throw new InterruptedException("let's retry");
        }
        Future<ByteBuffer> future = null;
        try {
            future = hedgedService.take();
            ByteBuffer bb = future.get();
            futures.remove(future);
            return bb;
        }
        catch (ExecutionException e) {
            futures.remove(future);
        }
        catch (CancellationException ce) {
            futures.remove(future);
        }
        throw new InterruptedException("let's retry");
    }

    private void cancelAll(List<Future<ByteBuffer>> futures) {
        for (Future<ByteBuffer> future : futures) {
            future.cancel(false);
        }
    }

    private static boolean tokenRefetchNeeded(IOException ex, InetSocketAddress targetAddr) {
        if (ex instanceof InvalidBlockTokenException || ex instanceof SecretManager.InvalidToken) {
            DFSClient.LOG.info((Object)("Access token was invalid when connecting to " + targetAddr + " : " + ex));
            return true;
        }
        return false;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteArrayPread", this.src);){
            int n = this.pread(position, buffer, offset, length);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pread(long position, byte[] buffer, int offset, int length) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        long filelen = this.getFileLength();
        if (position < 0L || position >= filelen) {
            return -1;
        }
        int realLen = length;
        if (position + (long)length > filelen) {
            realLen = (int)(filelen - position);
        }
        List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
        int remaining = realLen;
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        for (LocatedBlock blk : blockRange) {
            long targetStart = position - blk.getStartOffset();
            long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
            try {
                if (this.dfsClient.isHedgedReadsEnabled()) {
                    this.hedgedFetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset, corruptedBlockMap);
                } else {
                    this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset, corruptedBlockMap);
                }
            }
            finally {
                this.reportCheckSumFailure(corruptedBlockMap, blk.getLocations().length);
            }
            remaining = (int)((long)remaining - bytesToRead);
            position += bytesToRead;
            offset = (int)((long)offset + bytesToRead);
        }
        assert (remaining == 0) : "Wrong number of bytes read.";
        if (this.dfsClient.stats != null) {
            this.dfsClient.stats.incrementBytesRead((long)realLen);
        }
        return realLen;
    }

    private void reportCheckSumFailure(Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap, int dataNodeCount) {
        if (corruptedBlockMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ExtendedBlock, Set<DatanodeInfo>>> it = corruptedBlockMap.entrySet().iterator();
        Map.Entry<ExtendedBlock, Set<DatanodeInfo>> entry = it.next();
        ExtendedBlock blk = entry.getKey();
        Set<DatanodeInfo> dnSet = entry.getValue();
        if (dnSet.size() < dataNodeCount && dnSet.size() > 0 || dataNodeCount == 1 && dnSet.size() == dataNodeCount) {
            DatanodeInfo[] locs = new DatanodeInfo[dnSet.size()];
            int i = 0;
            for (DatanodeInfo dn : dnSet) {
                locs[i++] = dn;
            }
            LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, locs)};
            this.dfsClient.reportChecksumFailure(this.src, lblocks);
        }
        corruptedBlockMap.clear();
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            long fileLen;
            long curPos = this.getPos();
            if (n + curPos > (fileLen = this.getFileLength())) {
                n = fileLen - curPos;
            }
            this.seek(curPos + n);
            return n;
        }
        return n < 0L ? -1L : 0L;
    }

    public synchronized void seek(long targetPos) throws IOException {
        boolean done;
        block8: {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            if (targetPos < 0L) {
                throw new IOException("Cannot seek to negative offset");
            }
            if (this.closed.get()) {
                throw new IOException("Stream is closed!");
            }
            done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= this.blockReader.available()) {
                try {
                    this.pos += this.blockReader.skip(diff);
                    if (this.pos != targetPos) {
                        String errMsg = "BlockReader failed to seek to " + targetPos + ". Instead, it seeked to " + this.pos + ".";
                        DFSClient.LOG.warn((Object)errMsg);
                        throw new IOException(errMsg);
                    }
                    done = true;
                }
                catch (IOException e) {
                    if (!DFSClient.LOG.isDebugEnabled()) break block8;
                    DFSClient.LOG.debug((Object)("Exception while seek to " + targetPos + " from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode), (Throwable)e);
                }
            }
        }
        if (!done) {
            this.pos = targetPos;
            this.blockEnd = -1L;
        }
    }

    private boolean seekToBlockSource(long targetPos) throws IOException {
        this.currentNode = this.blockSeekTo(targetPos);
        return true;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        boolean markedDead = this.deadNodes.containsKey(this.currentNode);
        this.addToDeadNodes(this.currentNode);
        DatanodeInfo oldNode = this.currentNode;
        DatanodeInfo newNode = this.blockSeekTo(targetPos);
        if (!markedDead) {
            this.deadNodes.remove(oldNode);
        }
        if (!oldNode.getDatanodeUuid().equals(newNode.getDatanodeUuid())) {
            this.currentNode = newNode;
            return true;
        }
        return false;
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        long remaining = this.getFileLength() - this.pos;
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    static DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i]) || ignoredNodes != null && ignoredNodes.contains(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStatistics getReadStatistics() {
        Object object = this.infoLock;
        synchronized (object) {
            return new ReadStatistics(this.readStatistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadStatistics() {
        Object object = this.infoLock;
        synchronized (object) {
            this.readStatistics.clear();
        }
    }

    private void closeCurrentBlockReader() {
        if (this.blockReader == null) {
            return;
        }
        try {
            this.blockReader.close();
        }
        catch (IOException e) {
            DFSClient.LOG.error((Object)"error closing blockReader", (Throwable)e);
        }
        this.blockReader = null;
        this.blockEnd = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReadahead(Long readahead) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setReadahead(readahead).build();
        }
        this.closeCurrentBlockReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDropBehind(Boolean dropBehind) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setDropBehind(dropBehind).build();
        }
        this.closeCurrentBlockReader();
    }

    public synchronized ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        if (maxLength == 0) {
            return EMPTY_BUFFER;
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("can't read a negative number of bytes.");
        }
        if (this.blockReader == null || this.blockEnd == -1L) {
            if (this.pos >= this.getFileLength()) {
                return null;
            }
            if (!this.seekToBlockSource(this.pos) || this.blockReader == null) {
                throw new IOException("failed to allocate new BlockReader at position " + this.pos);
            }
        }
        ByteBuffer buffer = null;
        if (this.dfsClient.getConf().shortCircuitMmapEnabled) {
            buffer = this.tryReadZeroCopy(maxLength, opts);
        }
        if (buffer != null) {
            return buffer;
        }
        buffer = ByteBufferUtil.fallbackRead((InputStream)((Object)this), (ByteBufferPool)bufferPool, (int)maxLength);
        if (buffer != null) {
            this.getExtendedReadBuffers().put((Object)buffer, (Object)bufferPool);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer tryReadZeroCopy(int maxLength, EnumSet<ReadOption> opts) throws IOException {
        ByteBuffer buffer;
        int length;
        long length63;
        long curPos = this.pos;
        long curEnd = this.blockEnd;
        long blockStartInFile = this.currentLocatedBlock.getStartOffset();
        long blockPos = curPos - blockStartInFile;
        if (curPos + (long)maxLength <= curEnd + 1L) {
            length63 = maxLength;
        } else {
            length63 = 1L + curEnd - curPos;
            if (length63 <= 0L) {
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug((Object)("Unable to perform a zero-copy read from offset " + curPos + " of " + this.src + "; " + length63 + " bytes left in block.  blockPos=" + blockPos + "; curPos=" + curPos + "; curEnd=" + curEnd));
                }
                return null;
            }
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("Reducing read length from " + maxLength + " to " + length63 + " to avoid going more than one byte past the end of the block.  blockPos=" + blockPos + "; curPos=" + curPos + "; curEnd=" + curEnd));
            }
        }
        if (blockPos + length63 <= Integer.MAX_VALUE) {
            length = (int)length63;
        } else {
            long length31 = Integer.MAX_VALUE - blockPos;
            if (length31 <= 0L) {
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug((Object)("Unable to perform a zero-copy read from offset " + curPos + " of " + this.src + "; 31-bit MappedByteBuffer limit exceeded.  blockPos=" + blockPos + ", curEnd=" + curEnd));
                }
                return null;
            }
            length = (int)length31;
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("Reducing read length from " + maxLength + " to " + length + " to avoid 31-bit limit.  blockPos=" + blockPos + "; curPos=" + curPos + "; curEnd=" + curEnd));
            }
        }
        ClientMmap clientMmap = this.blockReader.getClientMmap(opts);
        if (clientMmap == null) {
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("unable to perform a zero-copy read from offset " + curPos + " of " + this.src + "; BlockReader#getClientMmap returned null."));
            }
            return null;
        }
        boolean success = false;
        try {
            this.seek(curPos + (long)length);
            buffer = clientMmap.getMappedByteBuffer().asReadOnlyBuffer();
            buffer.position((int)blockPos);
            buffer.limit((int)(blockPos + (long)length));
            this.getExtendedReadBuffers().put((Object)buffer, (Object)clientMmap);
            Object object = this.infoLock;
            synchronized (object) {
                this.readStatistics.addZeroCopyBytes(length);
            }
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("readZeroCopy read " + length + " bytes from offset " + curPos + " via the zero-copy read path.  blockEnd = " + this.blockEnd));
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Closeable)clientMmap);
            }
        }
        return buffer;
    }

    public synchronized void releaseBuffer(ByteBuffer buffer) {
        if (buffer == EMPTY_BUFFER) {
            return;
        }
        Object val = this.getExtendedReadBuffers().remove((Object)buffer);
        if (val == null) {
            throw new IllegalArgumentException("tried to release a buffer that was not created by this stream, " + buffer);
        }
        if (val instanceof ClientMmap) {
            IOUtils.closeQuietly((Closeable)((ClientMmap)val));
        } else if (val instanceof ByteBufferPool) {
            ((ByteBufferPool)val).putBuffer(buffer);
        }
    }

    public synchronized void unbuffer() {
        this.closeCurrentBlockReader();
    }

    static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }

    private class ByteBufferStrategy
    implements ReaderStrategy {
        final ByteBuffer buf;

        ByteBufferStrategy(ByteBuffer buf) {
            this.buf = buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(BlockReader blockReader, int off, int len) throws ChecksumException, IOException {
            int oldpos = this.buf.position();
            int oldlimit = this.buf.limit();
            boolean success = false;
            try {
                int ret = blockReader.read(this.buf);
                success = true;
                DFSInputStream.this.updateReadStatistics(DFSInputStream.this.readStatistics, ret, blockReader);
                int n = ret;
                return n;
            }
            finally {
                if (!success) {
                    this.buf.position(oldpos);
                    this.buf.limit(oldlimit);
                }
            }
        }
    }

    private class ByteArrayStrategy
    implements ReaderStrategy {
        final byte[] buf;

        public ByteArrayStrategy(byte[] buf) {
            this.buf = buf;
        }

        @Override
        public int doRead(BlockReader blockReader, int off, int len) throws ChecksumException, IOException {
            int nRead = blockReader.read(this.buf, off, len);
            DFSInputStream.this.updateReadStatistics(DFSInputStream.this.readStatistics, nRead, blockReader);
            return nRead;
        }
    }

    private static interface ReaderStrategy {
        public int doRead(BlockReader var1, int var2, int var3) throws ChecksumException, IOException;
    }

    public static class ReadStatistics {
        private long totalBytesRead;
        private long totalLocalBytesRead;
        private long totalShortCircuitBytesRead;
        private long totalZeroCopyBytesRead;

        public ReadStatistics() {
            this.clear();
        }

        public ReadStatistics(ReadStatistics rhs) {
            this.totalBytesRead = rhs.getTotalBytesRead();
            this.totalLocalBytesRead = rhs.getTotalLocalBytesRead();
            this.totalShortCircuitBytesRead = rhs.getTotalShortCircuitBytesRead();
            this.totalZeroCopyBytesRead = rhs.getTotalZeroCopyBytesRead();
        }

        public long getTotalBytesRead() {
            return this.totalBytesRead;
        }

        public long getTotalLocalBytesRead() {
            return this.totalLocalBytesRead;
        }

        public long getTotalShortCircuitBytesRead() {
            return this.totalShortCircuitBytesRead;
        }

        public long getTotalZeroCopyBytesRead() {
            return this.totalZeroCopyBytesRead;
        }

        public long getRemoteBytesRead() {
            return this.totalBytesRead - this.totalLocalBytesRead;
        }

        void addRemoteBytes(long amt) {
            this.totalBytesRead += amt;
        }

        void addLocalBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
        }

        void addShortCircuitBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
            this.totalShortCircuitBytesRead += amt;
        }

        void addZeroCopyBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
            this.totalShortCircuitBytesRead += amt;
            this.totalZeroCopyBytesRead += amt;
        }

        void clear() {
            this.totalBytesRead = 0L;
            this.totalLocalBytesRead = 0L;
            this.totalShortCircuitBytesRead = 0L;
            this.totalZeroCopyBytesRead = 0L;
        }
    }
}

