/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.hdfs.dal.ActiveBlockReportsDataAccess;
import io.hops.metadata.hdfs.entity.ActiveBlockReport;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.blockmanagement.BRLoadBalancingOverloadException;

public class BRTrackingService {
    public static final Log LOG = LogFactory.getLog(BRTrackingService.class);
    private final long DB_VAR_UPDATE_THRESHOLD;
    private final long BR_MAX_PROCESSING_TIME;
    private int rrIndex = 0;
    private long lastChecked = 0L;
    private long cachedMaxConcurrentBRs = 0L;

    public BRTrackingService(long DB_VAR_UPDATE_THRESHOLD, long MAX_CONCURRENT_BRS, long BR_MAX_PROCESSING_TIME) {
        this.DB_VAR_UPDATE_THRESHOLD = DB_VAR_UPDATE_THRESHOLD;
        this.BR_MAX_PROCESSING_TIME = BR_MAX_PROCESSING_TIME;
        this.cachedMaxConcurrentBRs = MAX_CONCURRENT_BRS;
    }

    private int getRRIndex(SortedActiveNodeList nnList) {
        if (this.rrIndex < 0 || this.rrIndex >= nnList.size()) {
            this.rrIndex = 0;
        }
        return this.rrIndex++ % nnList.size();
    }

    private boolean canProcessMoreBR() throws IOException {
        List<ActiveBlockReport> allActiveBRs = this.getAllActiveBlockReports();
        if ((long)allActiveBRs.size() < this.getBrLbMaxConcurrentBRs()) {
            return true;
        }
        Iterator<ActiveBlockReport> itr = allActiveBRs.iterator();
        while (itr.hasNext()) {
            ActiveBlockReport abr = itr.next();
            if (System.currentTimeMillis() - abr.getStartTime() <= this.BR_MAX_PROCESSING_TIME) continue;
            LOG.warn((Object)("block report timed out dn: " + abr.getDnAddress() + " on NN: " + abr.getNnId()));
            this.removeActiveBlockReport(abr);
            itr.remove();
        }
        return (long)allActiveBRs.size() < this.getBrLbMaxConcurrentBRs();
    }

    private long getBrLbMaxConcurrentBRs() throws IOException {
        if (System.currentTimeMillis() - this.lastChecked > this.DB_VAR_UPDATE_THRESHOLD) {
            long value = HdfsVariables.getMaxConcurrentBrs();
            if (value != this.cachedMaxConcurrentBRs) {
                this.cachedMaxConcurrentBRs = value;
                LOG.info((Object)("BRTrackingService param update. Processing " + this.cachedMaxConcurrentBRs + " concurrent block reports"));
            }
            this.lastChecked = System.currentTimeMillis();
        }
        return this.cachedMaxConcurrentBRs;
    }

    public synchronized ActiveNode assignWork(final SortedActiveNodeList nnList, final String dnAddress, final long noOfBlks) throws IOException {
        return (ActiveNode)new LightWeightRequestHandler(HDFSOperationType.BR_LB_GET_ALL){

            public Object performTask() throws IOException {
                boolean isActive = connector.isTransactionActive();
                if (!isActive) {
                    connector.beginTransaction();
                    connector.writeLock();
                }
                try {
                    int index;
                    if (BRTrackingService.this.canProcessMoreBR() && (index = BRTrackingService.this.getRRIndex(nnList)) >= 0 && index < nnList.size()) {
                        ActiveNode an = (ActiveNode)nnList.getSortedActiveNodes().get(index);
                        ActiveBlockReport abr = new ActiveBlockReport(dnAddress, an.getId(), System.currentTimeMillis(), noOfBlks);
                        BRTrackingService.this.addActiveBlockReport(abr);
                        LOG.info((Object)("Block report from " + dnAddress + " containing " + noOfBlks + " blocks is assigned to NN [ID: " + an.getId() + ", IP: " + an.getRpcServerIpAddress() + "]"));
                        ActiveNode activeNode = an;
                        return activeNode;
                    }
                    String msg = "Work (" + noOfBlks + " blks) could not be assigned. System is fully loaded now. At most " + BRTrackingService.this.getBrLbMaxConcurrentBRs() + " concurrent block reports can be processed.";
                    LOG.info((Object)msg);
                    throw new BRLoadBalancingOverloadException(msg);
                }
                finally {
                    if (!isActive) {
                        connector.commit();
                    }
                }
            }
        }.handle();
    }

    public synchronized void blockReportCompleted(String dnAddress) throws IOException {
        ActiveBlockReport abr = new ActiveBlockReport(dnAddress, 0L, 0L, 0L);
        LOG.info((Object)("Block report from " + dnAddress + " has completed"));
        this.removeActiveBlockReport(abr);
    }

    private List<ActiveBlockReport> getAllActiveBlockReports() throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_GET_ALL){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                return da.getAll();
            }
        };
        return (List)handler.handle();
    }

    private void addActiveBlockReport(final ActiveBlockReport abr) throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_ADD){

            public Object performTask() throws IOException {
                boolean isActive = connector.isTransactionActive();
                if (!isActive) {
                    connector.beginTransaction();
                    connector.writeLock();
                }
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                da.addActiveReport(abr);
                if (!isActive) {
                    connector.commit();
                }
                return null;
            }
        };
        handler.handle();
    }

    private void removeActiveBlockReport(final ActiveBlockReport abr) throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_REMOVE){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da;
                ActiveBlockReport inDB;
                boolean isActive = connector.isTransactionActive();
                if (!isActive) {
                    connector.beginTransaction();
                    connector.writeLock();
                }
                if ((inDB = (da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class)).getActiveBlockReport(abr)) != null) {
                    da.removeActiveReport(inDB);
                }
                if (!isActive) {
                    connector.commit();
                }
                return null;
            }
        };
        handler.handle();
    }
}

