/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class BlockPlacementPolicyDefault
extends BlockPlacementPolicy {
    private static final String enableDebugLogging = "For more information, please enable DEBUG log level on " + BlockPlacementPolicy.class.getName();
    private static final ThreadLocal<StringBuilder> debugLoggingBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    protected boolean considerLoad;
    private boolean preferLocalNode = true;
    protected NetworkTopology clusterMap;
    protected Host2NodesMap host2datanodeMap;
    private FSClusterStats stats;
    protected long heartbeatInterval;
    private long staleInterval;
    protected int tolerateHeartbeatMultiplier;

    protected BlockPlacementPolicyDefault() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        this.considerLoad = conf.getBoolean("dfs.namenode.replication.considerLoad", true);
        this.stats = stats;
        this.clusterMap = clusterMap;
        this.host2datanodeMap = host2datanodeMap;
        this.heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.tolerateHeartbeatMultiplier = conf.getInt("dfs.namenode.tolerate.heartbeat.multiplier", 4);
        this.staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
    }

    @Override
    public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storagePolicy);
    }

    @Override
    DatanodeStorageInfo[] chooseTarget(String src, int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes, BlockStoragePolicy storagePolicy) {
        try {
            if (favoredNodes == null || favoredNodes.size() == 0) {
                return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy);
            }
            HashSet<Node> favoriteAndExcludedNodes = excludedNodes == null ? new HashSet<Node>() : new HashSet<Node>(excludedNodes);
            List<StorageType> requiredStorageTypes = storagePolicy.chooseStorageTypes((short)numOfReplicas);
            EnumMap<StorageType, Integer> storageTypes = this.getRequiredStorageTypes(requiredStorageTypes);
            ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>();
            boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
            int[] maxNodesAndReplicas = this.getMaxNodesPerRack(0, numOfReplicas);
            numOfReplicas = maxNodesAndReplicas[0];
            int maxNodesPerRack = maxNodesAndReplicas[1];
            for (int i = 0; i < favoredNodes.size() && results.size() < numOfReplicas; ++i) {
                DatanodeDescriptor favoredNode = favoredNodes.get(i);
                DatanodeStorageInfo target = this.chooseLocalStorage(favoredNode, favoriteAndExcludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, false);
                if (target == null) {
                    LOG.warn((Object)("Could not find a target for file " + src + " with favored node " + favoredNode));
                    continue;
                }
                favoriteAndExcludedNodes.add(target.getDatanodeDescriptor());
            }
            if (results.size() < numOfReplicas) {
                DatanodeStorageInfo[] remainingTargets = this.chooseTarget(src, numOfReplicas -= results.size(), writer, results, false, favoriteAndExcludedNodes, blocksize, storagePolicy);
                for (int i = 0; i < remainingTargets.length; ++i) {
                    results.add(remainingTargets[i]);
                }
            }
            return this.getPipeline(writer, results.toArray(new DatanodeStorageInfo[results.size()]));
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException nr) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to choose with favored nodes (=" + favoredNodes + "), disregard favored nodes hint and retry."), (Throwable)nr);
            }
            return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy);
        }
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenStorage, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy) {
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return DatanodeStorageInfo.EMPTY_ARRAY;
        }
        if (excludedNodes == null) {
            excludedNodes = new HashSet<Node>();
        }
        int[] result = this.getMaxNodesPerRack(chosenStorage.size(), numOfReplicas);
        numOfReplicas = result[0];
        int maxNodesPerRack = result[1];
        ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>(chosenStorage);
        for (DatanodeStorageInfo storage : chosenStorage) {
            if (storage == null) continue;
            this.addToExcludedNodes(storage.getDatanodeDescriptor(), excludedNodes);
        }
        boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
        Node localNode = this.chooseTarget(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storagePolicy, EnumSet.noneOf(StorageType.class), results.isEmpty());
        if (!returnChosenNodes) {
            results.removeAll(chosenStorage);
        }
        return this.getPipeline(writer != null && writer instanceof DatanodeDescriptor ? writer : localNode, results.toArray(new DatanodeStorageInfo[results.size()]));
    }

    private int[] getMaxNodesPerRack(int numOfChosen, int numOfReplicas) {
        int numOfRacks;
        int totalNumOfReplicas = numOfChosen + numOfReplicas;
        int clusterSize = this.clusterMap.getNumOfLeaves();
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        if ((numOfRacks = this.clusterMap.getNumOfRacks()) == 1 || totalNumOfReplicas <= 1) {
            return new int[]{numOfReplicas, totalNumOfReplicas};
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / numOfRacks + 2;
        if (maxNodesPerRack == totalNumOfReplicas) {
            // empty if block
        }
        return new int[]{numOfReplicas, --maxNodesPerRack};
    }

    private EnumMap<StorageType, Integer> getRequiredStorageTypes(List<StorageType> types) {
        EnumMap<StorageType, Integer> map = new EnumMap<StorageType, Integer>(StorageType.class);
        for (StorageType type : types) {
            if (!map.containsKey(type)) {
                map.put(type, 1);
                continue;
            }
            int num = map.get(type);
            map.put(type, num + 1);
        }
        return map;
    }

    private Node chooseTarget(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, BlockStoragePolicy storagePolicy, EnumSet<StorageType> unavailableStorages, boolean newBlock) {
        block22: {
            if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
                return writer instanceof DatanodeDescriptor ? writer : null;
            }
            int numOfResults = results.size();
            int totalReplicasExpected = numOfReplicas + numOfResults;
            if (!(writer != null && writer instanceof DatanodeDescriptor || newBlock)) {
                writer = results.get(0).getDatanodeDescriptor();
            }
            HashSet<Node> oldExcludedNodes = new HashSet<Node>(excludedNodes);
            List<StorageType> requiredStorageTypes = storagePolicy.chooseStorageTypes((short)totalReplicasExpected, DatanodeStorageInfo.toStorageTypes(results), unavailableStorages, newBlock);
            EnumMap<StorageType, Integer> storageTypes = this.getRequiredStorageTypes(requiredStorageTypes);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("storageTypes=" + storageTypes));
            }
            try {
                numOfReplicas = requiredStorageTypes.size();
                if (numOfReplicas == 0) {
                    throw new BlockPlacementPolicy.NotEnoughReplicasException("All required storage types are unavailable:  unavailableStorages=" + unavailableStorages + ", storagePolicy=" + storagePolicy);
                }
                if (numOfResults == 0) {
                    writer = this.chooseLocalStorage(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, true).getDatanodeDescriptor();
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                DatanodeDescriptor dn0 = results.get(0).getDatanodeDescriptor();
                if (numOfResults <= 1) {
                    this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                if (numOfResults <= 2) {
                    DatanodeDescriptor dn1 = results.get(1).getDatanodeDescriptor();
                    if (this.clusterMap.isOnSameRack((Node)dn0, (Node)dn1)) {
                        this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                    } else if (newBlock) {
                        this.chooseLocalRack(dn1, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                    } else {
                        this.chooseLocalRack(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                    }
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            }
            catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
                String message = "Failed to place enough replicas, still in need of " + (totalReplicasExpected - results.size()) + " to reach " + totalReplicasExpected + " (unavailableStorages=" + unavailableStorages + ", storagePolicy=" + storagePolicy + ", newBlock=" + newBlock + ")";
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)message, (Throwable)e);
                } else {
                    LOG.warn((Object)(message + " " + e.getMessage()));
                }
                if (avoidStaleNodes) {
                    for (DatanodeStorageInfo resultStorage : results) {
                        this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), oldExcludedNodes);
                    }
                    numOfReplicas = totalReplicasExpected - results.size();
                    return this.chooseTarget(numOfReplicas, writer, oldExcludedNodes, blocksize, maxNodesPerRack, results, false, storagePolicy, unavailableStorages, newBlock);
                }
                boolean retry = false;
                for (StorageType type : storageTypes.keySet()) {
                    if (unavailableStorages.contains(type)) continue;
                    unavailableStorages.add(type);
                    retry = true;
                }
                if (!retry) break block22;
                for (DatanodeStorageInfo resultStorage : results) {
                    this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), oldExcludedNodes);
                }
                numOfReplicas = totalReplicasExpected - results.size();
                return this.chooseTarget(numOfReplicas, writer, oldExcludedNodes, blocksize, maxNodesPerRack, results, false, storagePolicy, unavailableStorages, newBlock);
            }
        }
        return writer;
    }

    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes, boolean fallbackToLocalRack) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        if (this.preferLocalNode && localMachine instanceof DatanodeDescriptor) {
            DatanodeDescriptor localDatanode = (DatanodeDescriptor)localMachine;
            if (excludedNodes.add(localMachine)) {
                Iterator<Map.Entry<StorageType, Integer>> iter = storageTypes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<StorageType, Integer> entry = iter.next();
                    for (DatanodeStorageInfo localStorage : DFSUtil.shuffle(localDatanode.getStorageInfos())) {
                        StorageType type = entry.getKey();
                        if (this.addIfIsGoodTarget(localStorage, excludedNodes, blocksize, maxNodesPerRack, false, results, avoidStaleNodes, type) < 0) continue;
                        int num = entry.getValue();
                        if (num == 1) {
                            iter.remove();
                        } else {
                            entry.setValue(num - 1);
                        }
                        return localStorage;
                    }
                }
            }
        }
        if (!fallbackToLocalRack) {
            return null;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    protected int addToExcludedNodes(DatanodeDescriptor localMachine, Set<Node> excludedNodes) {
        return excludedNodes.add(localMachine) ? 1 : 0;
    }

    protected DatanodeStorageInfo chooseLocalRack(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        String localRack = localMachine.getNetworkLocation();
        try {
            return this.chooseRandom(localRack, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            for (DatanodeStorageInfo resultStorage : results) {
                DatanodeDescriptor nextNode = resultStorage.getDatanodeDescriptor();
                if (nextNode == localMachine) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Failed to choose from local rack (location = " + localRack + "), retry with the rack of the next replica (location = " + nextNode.getNetworkLocation() + ")"), (Throwable)e);
                }
                return this.chooseFromNextRack(nextNode, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to choose from local rack (location = " + localRack + "); the second replica is not found, retry choosing ramdomly"), (Throwable)e);
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    private DatanodeStorageInfo chooseFromNextRack(Node next, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        String nextRack = next.getNetworkLocation();
        try {
            return this.chooseRandom(nextRack, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to choose from the next rack (location = " + nextRack + "), retry choosing ramdomly"), (Throwable)e);
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, Set<Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to choose remote rack (location = ~" + localMachine.getNetworkLocation() + "), fallback to local rack"), (Throwable)e);
            }
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    protected DatanodeStorageInfo chooseRandom(String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        return this.chooseRandom(1, scope, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    protected DatanodeStorageInfo chooseRandom(int numOfReplicas, String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(scope, excludedNodes);
        StringBuilder builder = null;
        if (LOG.isDebugEnabled()) {
            builder = debugLoggingBuilder.get();
            builder.setLength(0);
            builder.append("[");
        }
        boolean badTarget = false;
        DatanodeStorageInfo firstChosen = null;
        LOG.debug((Object)("@@@ -- START -- " + numOfAvailableNodes + " " + scope + " " + Arrays.toString(excludedNodes.toArray())));
        while (numOfReplicas > 0 && numOfAvailableNodes > 0) {
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope);
            if (excludedNodes.add(chosenNode)) {
                if (LOG.isDebugEnabled()) {
                    builder.append("\nNode ").append(NodeBase.getPath((Node)chosenNode)).append(" [");
                }
                --numOfAvailableNodes;
                DatanodeStorageInfo[] storages = DFSUtil.shuffle(chosenNode.getStorageInfos());
                int i = 0;
                boolean search = true;
                Iterator<Map.Entry<StorageType, Integer>> iter = storageTypes.entrySet().iterator();
                block1: while (search && iter.hasNext()) {
                    Map.Entry<StorageType, Integer> entry = iter.next();
                    StorageType type = entry.getKey();
                    for (i = 0; i < storages.length; ++i) {
                        int newExcludedNodes = this.addIfIsGoodTarget(storages[i], excludedNodes, blocksize, maxNodesPerRack, this.considerLoad, results, avoidStaleNodes, type);
                        if (newExcludedNodes >= 0) {
                            --numOfReplicas;
                            if (firstChosen == null) {
                                firstChosen = storages[i];
                            }
                            numOfAvailableNodes -= newExcludedNodes;
                            int num = entry.getValue();
                            if (num == 1) {
                                iter.remove();
                            } else {
                                entry.setValue(num - 1);
                            }
                            search = false;
                            continue block1;
                        }
                        LOG.debug((Object)("@@@ not a good storage on node " + chosenNode));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    builder.append("\n]");
                }
                badTarget = i == storages.length;
                continue;
            }
            LOG.debug((Object)("@@@ not chosen because already excluded: " + chosenNode));
        }
        if (numOfReplicas > 0) {
            String detail = enableDebugLogging;
            if (LOG.isDebugEnabled()) {
                if (badTarget && builder != null) {
                    detail = builder.toString();
                    builder.setLength(0);
                } else {
                    detail = "";
                }
            }
            throw new BlockPlacementPolicy.NotEnoughReplicasException(detail);
        }
        LOG.debug((Object)("@@@ CHOSE " + firstChosen));
        LOG.debug((Object)"@@@ -- END --");
        return firstChosen;
    }

    int addIfIsGoodTarget(DatanodeStorageInfo storage, Set<Node> excludedNodes, long blockSize, int maxNodesPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) {
        if (this.isGoodTarget(storage, blockSize, maxNodesPerRack, considerLoad, results, avoidStaleNodes, storageType)) {
            results.add(storage);
            return this.addToExcludedNodes(storage.getDatanodeDescriptor(), excludedNodes);
        }
        return -1;
    }

    private static void logNodeIsNotChosen(DatanodeStorageInfo storage, String reason) {
        LOG.debug((Object)("@@@ " + reason));
        if (LOG.isDebugEnabled()) {
            debugLoggingBuilder.get().append("\n  Storage ").append(storage).append(" is not chosen since ").append(reason).append(".");
        }
    }

    private boolean isGoodTarget(DatanodeStorageInfo storage, long blockSize, int maxTargetPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType requiredStorageType) {
        if (storage.getStorageType() != requiredStorageType) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "storage types do not match, where the required storage type is " + requiredStorageType);
            return false;
        }
        if (storage.getState() == DatanodeStorage.State.READ_ONLY_SHARED) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "storage is read-only");
            return false;
        }
        if (storage.getState() == DatanodeStorage.State.FAILED) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "storage has failed");
            return false;
        }
        DatanodeDescriptor node = storage.getDatanodeDescriptor();
        if (node.isDecommissionInProgress() || node.isDecommissioned()) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is (being) decommissioned ");
            return false;
        }
        if (avoidStaleNodes && node.isStale(this.staleInterval)) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is stale ");
            return false;
        }
        long requiredSize = blockSize * 1L;
        long scheduledSize = blockSize * (long)node.getBlocksScheduled(storage.getStorageType());
        long remaining = node.getRemaining(storage.getStorageType(), requiredSize);
        if (requiredSize > remaining - scheduledSize) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node does not have enough " + storage.getStorageType() + " space (required=" + requiredSize + ", scheduled=" + scheduledSize + ", remaining=" + remaining + ")");
            return false;
        }
        if (considerLoad) {
            double maxLoad = 2.0 * this.stats.getInServiceXceiverAverage();
            int nodeLoad = node.getXceiverCount();
            if ((double)nodeLoad > maxLoad) {
                BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is too busy (load: " + nodeLoad + " > " + maxLoad + ") ");
                return false;
            }
        }
        String rackname = node.getNetworkLocation();
        int counter = 1;
        for (DatanodeStorageInfo resultStorage : results) {
            if (!rackname.equals(resultStorage.getDatanodeDescriptor().getNetworkLocation())) continue;
            ++counter;
        }
        if (counter > maxTargetPerRack) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the rack (" + rackname + ") has too many chosen nodes (" + counter + ">" + maxTargetPerRack + ")");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatanodeStorageInfo[] getPipeline(Node writer, DatanodeStorageInfo[] storages) {
        if (storages.length == 0) {
            return storages;
        }
        NetworkTopology networkTopology = this.clusterMap;
        synchronized (networkTopology) {
            int index = 0;
            if (writer == null || !this.clusterMap.contains(writer)) {
                writer = storages[0].getDatanodeDescriptor();
            }
            while (index < storages.length) {
                DatanodeStorageInfo shortestStorage = storages[index];
                int shortestDistance = this.clusterMap.getDistance(writer, (Node)shortestStorage.getDatanodeDescriptor());
                int shortestIndex = index;
                for (int i = index + 1; i < storages.length; ++i) {
                    int currentDistance = this.clusterMap.getDistance(writer, (Node)storages[i].getDatanodeDescriptor());
                    if (shortestDistance <= currentDistance) continue;
                    shortestDistance = currentDistance;
                    shortestStorage = storages[i];
                    shortestIndex = i;
                }
                if (index != shortestIndex) {
                    storages[shortestIndex] = storages[index];
                    storages[index] = shortestStorage;
                }
                writer = shortestStorage.getDatanodeDescriptor();
                ++index;
            }
        }
        return storages;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(String srcPath, LocatedBlock lBlk, int numberOfReplicas) {
        int numRacks;
        DatanodeInfo[] locs = lBlk.getLocations();
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        if ((numRacks = this.clusterMap.getNumOfRacks()) <= 1) {
            return new BlockPlacementStatusDefault(Math.min(numRacks, numberOfReplicas), numRacks);
        }
        int minRacks = Math.min(2, numberOfReplicas);
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return new BlockPlacementStatusDefault(racks.size(), minRacks);
    }

    @Override
    public DatanodeStorageInfo chooseReplicaToDelete(BlockCollection bc, Block block, short replicationFactor, Collection<DatanodeStorageInfo> first, Collection<DatanodeStorageInfo> second, List<StorageType> excessTypes) {
        DatanodeStorageInfo storage;
        long oldestHeartbeat = Time.now() - this.heartbeatInterval * (long)this.tolerateHeartbeatMultiplier;
        DatanodeStorageInfo oldestHeartbeatStorage = null;
        long minSpace = Long.MAX_VALUE;
        DatanodeStorageInfo minSpaceStorage = null;
        for (DatanodeStorageInfo storage2 : this.pickupReplicaSet(first, second)) {
            if (!excessTypes.contains(storage2.getStorageType())) continue;
            DatanodeDescriptor node = storage2.getDatanodeDescriptor();
            long free = node.getRemaining();
            long lastHeartbeat = node.getLastUpdate();
            if (lastHeartbeat < oldestHeartbeat) {
                oldestHeartbeat = lastHeartbeat;
                oldestHeartbeatStorage = storage2;
            }
            if (minSpace <= free) continue;
            minSpace = free;
            minSpaceStorage = storage2;
        }
        if (oldestHeartbeatStorage != null) {
            storage = oldestHeartbeatStorage;
        } else if (minSpaceStorage != null) {
            storage = minSpaceStorage;
        } else {
            return null;
        }
        excessTypes.remove(storage.getStorageType());
        return storage;
    }

    protected Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> first, Collection<DatanodeStorageInfo> second) {
        return first.isEmpty() ? second : first;
    }

    @VisibleForTesting
    void setPreferLocalNode(boolean prefer) {
        this.preferLocalNode = prefer;
    }
}

