/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.NamenodeAddressParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;

class ParameterParser {
    private final Configuration conf;
    private final String path;
    private final Map<String, List<String>> params;

    ParameterParser(QueryStringDecoder decoder, Configuration conf) {
        this.path = QueryStringDecoder.decodeComponent((String)decoder.path().substring(WebHdfsHandler.WEBHDFS_PREFIX_LENGTH));
        this.params = decoder.parameters();
        this.conf = conf;
    }

    String path() {
        return this.path;
    }

    String op() {
        return this.param("op");
    }

    long offset() {
        return (Long)new OffsetParam(this.param("offset")).getValue();
    }

    String namenodeId() {
        return (String)new NamenodeAddressParam(this.param("namenoderpcaddress")).getValue();
    }

    String doAsUser() {
        return (String)new DoAsParam(this.param("doas")).getValue();
    }

    String userName() {
        return (String)new UserParam(this.param("user.name")).getValue();
    }

    int bufferSize() {
        return new BufferSizeParam(this.param("buffersize")).getValue(this.conf);
    }

    long blockSize() {
        return new BlockSizeParam(this.param("blocksize")).getValue(this.conf);
    }

    short replication() {
        return new ReplicationParam(this.param("replication")).getValue(this.conf);
    }

    FsPermission permission() {
        return new PermissionParam(this.param("permission")).getFsPermission();
    }

    boolean overwrite() {
        return (Boolean)new OverwriteParam(this.param("overwrite")).getValue();
    }

    Token<DelegationTokenIdentifier> delegationToken() throws IOException {
        String delegation = this.param("delegation");
        Token token = new Token();
        token.decodeFromUrlString(delegation);
        URI nnUri = URI.create("hdfs://" + this.namenodeId());
        boolean isLogical = HAUtil.isLogicalUri(this.conf, nnUri);
        if (isLogical) {
            token.setService(HAUtil.buildTokenServiceForLogicalUri(nnUri));
        } else {
            token.setService(SecurityUtil.buildTokenService((URI)nnUri));
        }
        return token;
    }

    Configuration conf() {
        return this.conf;
    }

    private String param(String key) {
        List<String> p = this.params.get(key);
        return p == null ? null : p.get(0);
    }
}

