/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import io.hops.security.HopsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMClientImpl
extends NMClient {
    private static final Log LOG = LogFactory.getLog(NMClientImpl.class);
    protected ConcurrentMap<ContainerId, StartedContainer> startedContainers = new ConcurrentHashMap<ContainerId, StartedContainer>();
    private final AtomicBoolean cleanupRunningContainers = new AtomicBoolean(true);
    private ContainerManagementProtocolProxy cmProxy;
    private String certificatePassword = null;

    public NMClientImpl() {
        super(NMClientImpl.class.getName());
    }

    public NMClientImpl(String name) {
        super(name);
    }

    protected void serviceStop() throws Exception {
        if (this.getCleanupRunningContainers().get()) {
            this.cleanupRunningContainers();
        }
        this.cmProxy.stopAllProxies();
        super.serviceStop();
    }

    protected synchronized void cleanupRunningContainers() {
        for (StartedContainer startedContainer : this.startedContainers.values()) {
            try {
                this.stopContainer(startedContainer.getContainerId(), startedContainer.getNodeId());
            }
            catch (YarnException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        if (this.getNMTokenCache() == null) {
            throw new IllegalStateException("NMTokenCache has not been set");
        }
        this.cmProxy = new ContainerManagementProtocolProxy(conf, this.getNMTokenCache());
    }

    @Override
    public void cleanupRunningContainersOnStop(boolean enabled) {
        this.getCleanupRunningContainers().set(enabled);
    }

    private void addStartingContainer(StartedContainer startedContainer) throws YarnException {
        if (this.startedContainers.putIfAbsent(startedContainer.containerId, startedContainer) != null) {
            throw RPCUtil.getRemoteException((String)("Container " + startedContainer.containerId.toString() + " is already started"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        StartedContainer startingContainer;
        StartedContainer startedContainer = startingContainer = new StartedContainer(container.getId(), container.getNodeId());
        synchronized (startedContainer) {
            Map allServiceResponse;
            this.addStartingContainer(startingContainer);
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
                StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)containerLaunchContext, (Token)container.getContainerToken());
                ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
                list.add(scRequest);
                StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
                this.setupCryptoMaterial(allRequests);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(allRequests);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                    Throwable t = ((SerializedException)response.getFailedRequests().get(container.getId())).deSerialize();
                    this.parseAndThrowException(t);
                }
                allServiceResponse = response.getAllServicesMetaData();
                startingContainer.state = ContainerState.RUNNING;
                if (proxy != null) {
                    this.cmProxy.mayBeCloseProxy(proxy);
                }
            }
            catch (IOException | YarnException e) {
                try {
                    startingContainer.state = ContainerState.COMPLETE;
                    this.startedContainers.remove(startingContainer.containerId);
                    throw e;
                    catch (Throwable t) {
                        startingContainer.state = ContainerState.COMPLETE;
                        this.startedContainers.remove(startingContainer.containerId);
                        throw RPCUtil.getRemoteException((Throwable)t);
                    }
                }
                catch (Throwable throwable) {
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                    throw throwable;
                }
            }
            return allServiceResponse;
        }
    }

    private void setupCryptoMaterial(StartContainersRequest request) throws IOException {
        if (this.getConfig().getBoolean("ipc.server.ssl.enabled", false)) {
            Path kStorePath = Paths.get("k_certificate", new String[0]);
            Path tStorePath = Paths.get("t_certificate", new String[0]);
            Path passwdPath = Paths.get("material_passwd", new String[0]);
            ByteBuffer kStore = ByteBuffer.wrap(Files.readAllBytes(kStorePath));
            ByteBuffer tStore = ByteBuffer.wrap(Files.readAllBytes(tStorePath));
            String password = this.readCryptoMaterialPassword(passwdPath.toFile());
            request.setKeyStore(kStore);
            request.setKeyStorePassword(password);
            request.setTrustStore(tStore);
            request.setTrustStorePassword(password);
        }
        if (this.getConfig().getBoolean(YarnConfiguration.RM_JWT_ENABLED, YarnConfiguration.DEFAULT_RM_JWT_ENABLED)) {
            Path path2jwt = Paths.get("token.jwt", new String[0]);
            String jwt = FileUtils.readFileToString((File)path2jwt.toFile()).trim();
            request.setJWT(jwt);
        }
    }

    private String readCryptoMaterialPassword(File passwdFile) throws IOException {
        if (null != this.certificatePassword) {
            return this.certificatePassword;
        }
        this.certificatePassword = HopsUtil.readCryptoMaterialPassword((File)passwdFile);
        return this.certificatePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseContainerResource(Container container) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        try {
            proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
            ArrayList<Token> increaseTokens = new ArrayList<Token>();
            increaseTokens.add(container.getContainerToken());
            IncreaseContainersResourceRequest increaseRequest = IncreaseContainersResourceRequest.newInstance(increaseTokens);
            IncreaseContainersResourceResponse response = proxy.getContainerManagementProtocol().increaseContainersResource(increaseRequest);
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(container.getId())).deSerialize();
                this.parseAndThrowException(t);
            }
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
        catch (Throwable throwable) {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        StartedContainer startedContainer = (StartedContainer)this.startedContainers.get(containerId);
        if (startedContainer != null) {
            StartedContainer startedContainer2 = startedContainer;
            synchronized (startedContainer2) {
                if (startedContainer.state != ContainerState.RUNNING) {
                    return;
                }
                this.stopContainerInternal(containerId, nodeId);
                startedContainer.state = ContainerState.COMPLETE;
                this.startedContainers.remove(startedContainer.containerId);
            }
        } else {
            this.stopContainerInternal(containerId, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus getContainerStatus(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            ContainerStatus containerStatus;
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            GetContainerStatusesResponse response = proxy.getContainerManagementProtocol().getContainerStatuses(GetContainerStatusesRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(containerId)).deSerialize();
                this.parseAndThrowException(t);
            }
            ContainerStatus containerStatus2 = containerStatus = (ContainerStatus)response.getContainerStatuses().get(0);
            return containerStatus2;
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopContainerInternal(ContainerId containerId, NodeId nodeId) throws IOException, YarnException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            StopContainersResponse response = proxy.getContainerManagementProtocol().stopContainers(StopContainersRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(containerId)).deSerialize();
                this.parseAndThrowException(t);
            }
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    public AtomicBoolean getCleanupRunningContainers() {
        return this.cleanupRunningContainers;
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    protected static class StartedContainer {
        private ContainerId containerId;
        private NodeId nodeId;
        private ContainerState state;

        public StartedContainer(ContainerId containerId, NodeId nodeId) {
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.state = ContainerState.NEW;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }
    }
}

