/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.common.params.ActionTokensArgs;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.NotFoundException;
import org.apache.slider.core.launch.CredentialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokensOperation {
    private static final Logger log = LoggerFactory.getLogger(TokensOperation.class);
    public static final String E_INSECURE = "Cluster is not secure -tokens cannot be acquired";
    public static final String E_MISSING_SOURCE_FILE = "Missing source file: ";
    public static final String E_NO_KEYTAB = "No keytab: ";

    public int actionTokens(ActionTokensArgs args, FileSystem fs, Configuration conf, YarnClientImpl yarnClient) throws IOException, YarnException {
        Credentials credentials;
        String footnote = "";
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        boolean isSecure = UserGroupInformation.isSecurityEnabled();
        if (args.keytab != null) {
            File keytab = args.keytab;
            if (!keytab.isFile()) {
                throw new NotFoundException(E_NO_KEYTAB + keytab.getAbsolutePath(), new Object[0]);
            }
            String principal = args.principal;
            log.info("Logging in as {} from keytab {}", (Object)principal, (Object)keytab);
            user = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab.getCanonicalPath());
        }
        Credentials userCredentials = user.getCredentials();
        File output = args.output;
        if (output != null) {
            if (!isSecure) {
                throw new BadClusterStateException(E_INSECURE, new Object[0]);
            }
            credentials = new Credentials(userCredentials);
            CredentialUtils.addRMRenewableFSDelegationTokens(conf, fs, credentials);
            CredentialUtils.addRMDelegationToken((YarnClient)yarnClient, credentials);
            if (CredentialUtils.maybeAddTimelineToken(conf, credentials) != null) {
                log.debug("Added timeline token");
            }
            CredentialUtils.saveTokens(output, credentials);
            String filename = output.getCanonicalPath();
            footnote = String.format("%d tokens saved to %s\nTo use these in the environment:\nexport %s=%s", credentials.numberOfTokens(), filename, "HADOOP_TOKEN_FILE_LOCATION", filename);
        } else if (args.source != null) {
            File source = args.source;
            log.info("Reading credentials from file {}", (Object)source);
            if (!source.isFile()) {
                throw new NotFoundException(E_MISSING_SOURCE_FILE + source.getAbsolutePath(), new Object[0]);
            }
            credentials = Credentials.readTokenStorageFile((File)args.source, (Configuration)conf);
        } else {
            StringBuffer origin = new StringBuffer();
            File file = CredentialUtils.locateEnvCredentials(System.getenv(), conf, origin);
            if (file != null) {
                log.info("Credential Source {}", (Object)origin);
            } else {
                log.info("Credential source: logged in user");
            }
            credentials = userCredentials;
        }
        log.info("\n{}", (Object)CredentialUtils.dumpTokens(credentials, "\n"));
        if (!footnote.isEmpty()) {
            log.info(footnote);
        }
        return 0;
    }
}

