/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client.rest;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.slider.core.exceptions.ExceptionConverter;
import org.apache.slider.core.restclient.HttpVerb;
import org.apache.slider.core.restclient.UgiJerseyBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRestClient {
    private static final Logger log = LoggerFactory.getLogger(BaseRestClient.class);
    private final Client client;

    public BaseRestClient(Client client) {
        Preconditions.checkNotNull((Object)client, (Object)"null jersey client");
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public <T> T exec(HttpVerb method, WebResource resource, Class<T> c) throws IOException {
        try {
            Preconditions.checkArgument((c != null ? 1 : 0) != 0);
            log.debug("{}} {}", (Object)method, (Object)resource.getURI());
            return (T)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).method(method.getVerb(), c);
        }
        catch (ClientHandlerException ex) {
            throw ExceptionConverter.convertJerseyException(method.getVerb(), resource.getURI().toString(), ex);
        }
        catch (UniformInterfaceException ex) {
            throw UgiJerseyBinding.uprateFaults(method, resource.getURI().toString(), ex);
        }
    }

    public <T> T exec(HttpVerb method, WebResource resource, GenericType<T> t) throws IOException {
        try {
            Preconditions.checkArgument((t != null ? 1 : 0) != 0);
            log.debug("{}} {}", (Object)method, (Object)resource.getURI());
            resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            return (T)resource.method(method.getVerb(), t);
        }
        catch (ClientHandlerException ex) {
            throw ExceptionConverter.convertJerseyException(method.getVerb(), resource.getURI().toString(), ex);
        }
        catch (UniformInterfaceException ex) {
            throw UgiJerseyBinding.uprateFaults(method, resource.getURI().toString(), ex);
        }
    }

    public <T> T get(WebResource resource, Class<T> c) throws IOException {
        return this.exec(HttpVerb.GET, resource, c);
    }

    public WebResource resource(URI u) {
        return this.client.resource(u);
    }

    public WebResource resource(String url) {
        return this.client.resource(url);
    }
}

