/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.UsageException;

@Parameters(commandNames={"tokens"}, commandDescription="save tokens to a file or list tokens in a file")
public class ActionTokensArgs
extends AbstractActionArgs {
    public static final String DUPLICATE_ARGS = "Only one of --source and --out allowed";
    public static final String MISSING_KT_PROVIDER = "Both --keytab and --principal must be provided";
    @Parameter(names={"--out"}, description="File to write")
    public File output;
    @Parameter(names={"--source"}, description="source file")
    public File source;
    @Parameter(names={"--keytab"}, description="keytab to use")
    public File keytab;
    @Parameter(names={"--principal"}, description="principal to log in from a keytab")
    public String principal = "";

    @Override
    public String getActionName() {
        return "tokens";
    }

    @Override
    public int getMinParams() {
        return 0;
    }

    @Override
    public void validate() throws BadCommandArgumentsException, UsageException {
        super.validate();
        if (this.output != null && this.source != null) {
            throw new BadCommandArgumentsException(DUPLICATE_ARGS, new Object[0]);
        }
        if (this.keytab != null ^ !this.principal.isEmpty()) {
            throw new BadCommandArgumentsException(MISSING_KT_PROVIDER, new Object[0]);
        }
    }
}

