/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.build;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.build.BuildHelper;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.persist.ConfPersister;
import org.apache.slider.core.persist.InstancePaths;
import org.apache.slider.core.persist.LockAcquireFailedException;
import org.apache.slider.core.persist.LockHeldAction;
import org.apache.slider.core.zk.ZKPathBuilder;
import org.apache.slider.core.zk.ZookeeperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceBuilder {
    private final String clustername;
    private final Configuration conf;
    private final CoreFileSystem coreFS;
    private final InstancePaths instancePaths;
    private AggregateConf instanceDescription;
    private Map<String, Path> externalAppDefs = new HashMap<String, Path>();
    private TreeSet<Integer> priorities = new TreeSet();
    private static final Logger log = LoggerFactory.getLogger(InstanceBuilder.class);

    public InstanceBuilder(CoreFileSystem coreFileSystem, Configuration conf, String clustername) {
        this.clustername = clustername;
        this.conf = conf;
        this.coreFS = coreFileSystem;
        Path instanceDir = coreFileSystem.buildClusterDirPath(clustername);
        this.instancePaths = new InstancePaths(instanceDir);
    }

    public AggregateConf getInstanceDescription() {
        return this.instanceDescription;
    }

    public InstancePaths getInstancePaths() {
        return this.instancePaths;
    }

    public String toString() {
        return "Builder working with " + this.clustername + " at " + this.getInstanceDir();
    }

    private Path getInstanceDir() {
        return this.instancePaths.instanceDir;
    }

    public void init(String provider, AggregateConf instanceConf) {
        this.instanceDescription = instanceConf;
        ConfTreeOperations internalOps = instanceConf.getInternalOperations();
        Map<String, Object> md = internalOps.getConfTree().metadata;
        long time = System.currentTimeMillis();
        md.put("create.time", SliderUtils.toGMTString(time));
        md.put("create.time.millis", Long.toString(time));
        internalOps.getGlobalOptions();
        BuildHelper.addBuildMetadata(md, "create");
        SliderUtils.setInfoTime(md, "create.time", "create.time.millis", System.currentTimeMillis());
        internalOps.set("internal.am.tmp.dir", this.instancePaths.tmpPathAM.toUri());
        internalOps.set("internal.tmp.dir", this.instancePaths.tmpPath.toUri());
        internalOps.set("internal.snapshot.conf.path", this.instancePaths.snapshotConfPath.toUri());
        internalOps.set("internal.generated.conf.path", this.instancePaths.generatedConfPath.toUri());
        internalOps.set("internal.data.dir.path", this.instancePaths.dataPath.toUri());
        internalOps.set("internal.appdef.dir.path", this.instancePaths.appDefPath.toUri());
        internalOps.set("internal.addons.dir.path", this.instancePaths.addonsPath.toUri());
        internalOps.set("internal.provider.name", provider);
        internalOps.set("application.name", this.clustername);
    }

    public void setQueue(String queue) throws BadConfigException {
        if (queue != null) {
            if (SliderUtils.isUnset(queue)) {
                throw new BadConfigException("Queue value cannot be empty.");
            }
            this.instanceDescription.getInternalOperations().set("internal.queue", queue);
        }
    }

    public void setImageDetailsIfAvailable(Path appImage, String appHomeDir) throws BadConfigException {
        boolean appHomeUnset = SliderUtils.isUnset(appHomeDir);
        if (appImage != null) {
            if (!appHomeUnset) {
                throw new BadConfigException("Both application image path and home dir have been provided");
            }
            this.instanceDescription.getInternalOperations().set("internal.application.image.path", appImage.toUri());
        } else if (!appHomeUnset) {
            this.instanceDescription.getInternalOperations().set("internal.application.home", appHomeDir);
        }
    }

    public void propagatePrincipals() {
        String dfsPrincipal = this.conf.get("dfs.namenode.kerberos.principal");
        if (dfsPrincipal != null) {
            String siteDfsPrincipal = "site.dfs.namenode.kerberos.principal";
            this.instanceDescription.getAppConfOperations().set(siteDfsPrincipal, dfsPrincipal);
        }
    }

    public void propagateFilename() {
        String fsDefaultName = this.conf.get("fs.defaultFS");
        this.instanceDescription.getAppConfOperations().set("site.fs.defaultFS", fsDefaultName);
        this.instanceDescription.getAppConfOperations().set("site.fs.default.name", fsDefaultName);
    }

    public void takeSnapshotOfConfDir(Path appconfdir) throws IOException, BadConfigException, BadClusterStateException {
        FileSystem srcFS = FileSystem.get((URI)appconfdir.toUri(), (Configuration)this.conf);
        if (!srcFS.isDirectory(appconfdir)) {
            throw new BadConfigException("Source Configuration directory is not valid: %s", appconfdir.toString());
        }
        FsPermission clusterPerms = this.coreFS.getInstanceDirectoryPermissions();
        SliderUtils.copyDirectory(this.conf, appconfdir, this.instancePaths.snapshotConfPath, clusterPerms);
    }

    private Set<String> getExternalComponents(ConfTreeOperations ops) throws BadConfigException {
        HashSet<String> externalComponents = new HashSet<String>();
        if (ops.getGlobalOptions().containsKey("site.global.component_type")) {
            throw new BadConfigException("site.global.component_type must be specified per-component, not in global");
        }
        for (Map.Entry<String, Map<String, String>> entry : ops.getComponents().entrySet()) {
            Map<String, String> options;
            if ("slider-appmaster".equals(entry.getKey()) || !"external_app".equals((options = entry.getValue()).get("site.global.component_type"))) continue;
            externalComponents.add(entry.getKey());
        }
        return externalComponents;
    }

    private void mergeExternalComponent(ConfTreeOperations ops, ConfTreeOperations externalOps, String externalComponent, Integer priority) throws BadConfigException {
        for (String subComponent : externalOps.getComponentNames()) {
            if ("slider-appmaster".equals(subComponent)) continue;
            String prefix = String.valueOf(externalComponent) + "-";
            log.debug("Merging options for {} into {}", (Object)subComponent, (Object)(String.valueOf(prefix) + subComponent));
            MapOperations subComponentOps = ops.getOrAddComponent(String.valueOf(prefix) + subComponent);
            if (priority == null) {
                SliderUtils.mergeMaps(subComponentOps, ops.getComponent((String)externalComponent).options);
                subComponentOps.remove("site.global.component_type");
            }
            SliderUtils.mergeMapsIgnoreDuplicateKeysAndPrefixes(subComponentOps, externalOps.getComponent(subComponent), SliderKeys.COMPONENT_KEYS_TO_SKIP);
            String existingPrefix = subComponentOps.get("role.prefix");
            if (existingPrefix != null) {
                if (!subComponent.startsWith(existingPrefix)) {
                    throw new BadConfigException("Bad prefix " + existingPrefix + " for subcomponent " + subComponent + " of " + externalComponent);
                }
                prefix = String.valueOf(prefix) + existingPrefix;
            }
            subComponentOps.set("role.prefix", prefix);
            if (priority == null) continue;
            subComponentOps.put("yarn.role.priority", Integer.toString(priority));
            this.priorities.add(priority);
            priority = priority + 1;
        }
    }

    private int getNextPriority() {
        if (this.priorities.isEmpty()) {
            return 1;
        }
        return this.priorities.last() + 1;
    }

    public void resolve() throws BadConfigException, IOException, BadClusterStateException {
        ConfTreeOperations appConf = this.instanceDescription.getAppConfOperations();
        ConfTreeOperations resources = this.instanceDescription.getResourceOperations();
        for (Map.Entry<String, Map<String, String>> entry : resources.getComponents().entrySet()) {
            if ("slider-appmaster".equals(entry.getKey()) || !entry.getValue().containsKey("yarn.role.priority")) continue;
            this.priorities.add(Integer.parseInt(entry.getValue().get("yarn.role.priority")));
        }
        Set<String> externalComponents = this.getExternalComponents(appConf);
        if (!externalComponents.isEmpty()) {
            log.info("Found external components {}", externalComponents);
        }
        for (String component : externalComponents) {
            if (!SliderUtils.isClusternameValid(component)) {
                throw new BadConfigException(String.valueOf(component) + " is not a valid external " + "component");
            }
            Path componentClusterDir = this.coreFS.buildClusterDirPath(component);
            try {
                this.coreFS.verifyPathExists(componentClusterDir);
            }
            catch (IOException iOException) {
                throw new BadConfigException("external component " + component + " doesn't exist");
            }
            AggregateConf componentConf = new AggregateConf();
            ConfPersister persister = new ConfPersister(this.coreFS, componentClusterDir);
            try {
                persister.load(componentConf);
            }
            catch (Exception exception) {
                throw new BadConfigException("Couldn't read configuration for external component " + component);
            }
            ConfTreeOperations componentAppConf = componentConf.getAppConfOperations();
            String externalAppDef = componentAppConf.get("application.def");
            if (SliderUtils.isSet(externalAppDef)) {
                Path newAppDef = new Path(this.coreFS.buildAppDefDirPath(this.clustername), String.valueOf(component) + "_" + "appPkg.zip");
                componentAppConf.set("application.def", newAppDef);
                componentAppConf.append("application.def.original", externalAppDef);
                log.info("Copying external appdef {} to {} for {}", new Object[]{externalAppDef, newAppDef, component});
                this.externalAppDefs.put(externalAppDef, newAppDef);
                externalAppDef = newAppDef.toString();
            }
            for (String rcomp : componentConf.getResourceOperations().getComponentNames()) {
                if ("slider-appmaster".equals(rcomp)) continue;
                log.debug("Adding component {} to appConf for {}", (Object)rcomp, (Object)component);
                componentAppConf.getOrAddComponent(rcomp);
            }
            componentConf.resolve();
            for (String rcomp : componentConf.getResourceOperations().getComponentNames()) {
                String componentAppDef;
                if ("slider-appmaster".equals(rcomp) || SliderUtils.isUnset(componentAppDef = componentAppConf.getComponentOpt(rcomp, "application.def", null)) || componentAppDef.equals(externalAppDef)) continue;
                if (this.externalAppDefs.containsKey(componentAppDef)) {
                    log.info("Using external appdef {} for {}", (Object)this.externalAppDefs.get(componentAppDef), (Object)rcomp);
                } else {
                    String existingPrefix = componentAppConf.getComponentOpt(rcomp, "role.prefix", null);
                    existingPrefix = SliderUtils.isUnset(existingPrefix) ? "" : "-" + SliderUtils.trimPrefix(existingPrefix);
                    Path newAppDef = new Path(this.coreFS.buildAppDefDirPath(this.clustername), String.valueOf(component) + existingPrefix + "_" + "appPkg.zip");
                    this.externalAppDefs.put(componentAppDef, newAppDef);
                    log.info("Copying external appdef {} to {} for {}", new Object[]{componentAppDef, newAppDef, String.valueOf(component) + "-" + rcomp});
                }
                componentAppConf.setComponentOpt(rcomp, "application.def", this.externalAppDefs.get(componentAppDef).toString());
                componentAppConf.appendComponentOpt(rcomp, "application.def.original", componentAppDef);
            }
            HashSet<Path> newAppDefs = new HashSet<Path>();
            newAppDefs.addAll(this.externalAppDefs.values());
            if (newAppDefs.size() != this.externalAppDefs.size()) {
                throw new IllegalStateException("Values repeat in external appdefs " + this.externalAppDefs);
            }
            log.info("External appdefs after {}: {}", (Object)component, this.externalAppDefs);
            SliderUtils.mergeMapsIgnoreDuplicateKeys(appConf.getConfTree().credentials, componentAppConf.getConfTree().credentials);
            this.mergeExternalComponent(appConf, componentAppConf, component, null);
            this.mergeExternalComponent(resources, componentConf.getResourceOperations(), component, this.getNextPriority());
        }
    }

    public void persist(Path appconfdir, boolean overwrite) throws IOException, SliderException, LockAcquireFailedException {
        if (!overwrite) {
            this.coreFS.createClusterDirectories(this.instancePaths);
        }
        ConfPersister persister = new ConfPersister(this.coreFS, this.getInstanceDir());
        ConfDirSnapshotAction action = null;
        if (appconfdir != null) {
            action = new ConfDirSnapshotAction(appconfdir);
        }
        persister.save(this.instanceDescription, action);
        for (Map.Entry<String, Path> appDef : this.externalAppDefs.entrySet()) {
            SliderUtils.copy(this.conf, new Path(appDef.getKey()), appDef.getValue());
        }
    }

    public void addZKBinding(ZKPathBuilder zkBinding) throws BadConfigException {
        String quorum = zkBinding.getAppQuorum();
        if (SliderUtils.isSet(quorum)) {
            MapOperations globalAppOptions = this.instanceDescription.getAppConfOperations().getGlobalOptions();
            globalAppOptions.put("zookeeper.path", zkBinding.getAppPath());
            globalAppOptions.put("zookeeper.quorum", quorum);
            globalAppOptions.put("zookeeper.hosts", ZookeeperUtils.convertToHostsOnlyList(quorum));
        }
    }

    private class ConfDirSnapshotAction
    implements LockHeldAction {
        private final Path appconfdir;

        private ConfDirSnapshotAction(Path appconfdir) {
            this.appconfdir = appconfdir;
        }

        @Override
        public void execute() throws IOException, SliderException {
            InstanceBuilder.this.takeSnapshotOfConfDir(this.appconfdir);
        }
    }
}

