/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.persist;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerDeser<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonSerDeser.class);
    private static final String UTF_8 = "UTF-8";
    private final Class<T> classType;
    private final ObjectMapper mapper;

    public JsonSerDeser(Class<T> classType) {
        this.classType = classType;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public T fromJson(String json) throws IOException, JsonParseException, JsonMappingException {
        try {
            return (T)this.mapper.readValue(json, this.classType);
        }
        catch (IOException e) {
            log.error("Exception while parsing json : " + e + "\n" + json, (Throwable)e);
            throw e;
        }
    }

    public T fromFile(File jsonFile) throws IOException, JsonParseException, JsonMappingException {
        File absoluteFile = jsonFile.getAbsoluteFile();
        try {
            return (T)this.mapper.readValue(absoluteFile, this.classType);
        }
        catch (IOException e) {
            log.error("Exception while parsing json file {}", (Object)absoluteFile, (Object)e);
            throw e;
        }
    }

    public T fromResource(String resource) throws IOException, JsonParseException, JsonMappingException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream resStream = this.getClass().getResourceAsStream(resource);){
                if (resStream == null) {
                    throw new FileNotFoundException(resource);
                }
                return (T)this.mapper.readValue(resStream, this.classType);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Exception while parsing json resource {}", (Object)resource, (Object)e);
            throw e;
        }
    }

    public T fromStream(InputStream stream) throws IOException {
        try {
            Object object = this.mapper.readValue(stream, this.classType);
            return (T)object;
        }
        catch (IOException e) {
            log.error("Exception while parsing json input stream", (Throwable)e);
            throw e;
        }
        finally {
            IOUtils.closeStream((Closeable)stream);
        }
    }

    public T fromInstance(T instance) throws IOException {
        return this.fromJson(this.toJson(instance));
    }

    public T fromBytes(byte[] b) throws IOException {
        String json = new String(b, 0, b.length, UTF_8);
        return this.fromJson(json);
    }

    public T load(FileSystem fs, Path path) throws IOException, JsonParseException, JsonMappingException {
        FileStatus status = fs.getFileStatus(path);
        long len = status.getLen();
        byte[] b = new byte[(int)len];
        FSDataInputStream dataInputStream = fs.open(path);
        dataInputStream.readFully(b);
        return this.fromBytes(b);
    }

    public void save(FileSystem fs, Path path, T instance, boolean overwrite) throws IOException {
        FSDataOutputStream dataOutputStream = fs.create(path, overwrite);
        this.writeJsonAsBytes(instance, (OutputStream)dataOutputStream);
    }

    public void save(T instance, File file) throws IOException {
        this.writeJsonAsBytes(instance, new FileOutputStream(file.getAbsoluteFile()));
    }

    private void writeJsonAsBytes(T instance, OutputStream dataOutputStream) throws IOException {
        try {
            String json = this.toJson(instance);
            byte[] b = json.getBytes(UTF_8);
            dataOutputStream.write(b);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        finally {
            IOUtils.closeStream((Closeable)dataOutputStream);
        }
    }

    public String toJson(T instance) throws IOException, JsonGenerationException, JsonMappingException {
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        return this.mapper.writeValueAsString(instance);
    }
}

