/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.AppState;

public class ActionUpgradeContainers
extends AsyncAction {
    private int exitCode;
    private FinalApplicationStatus finalApplicationStatus;
    private String message;
    private Set<String> containers = new HashSet<String>();
    private Set<String> components = new HashSet<String>();

    public ActionUpgradeContainers(String name, long delay, TimeUnit timeUnit, int exitCode, FinalApplicationStatus finalApplicationStatus, List<String> containers, List<String> components, String message) {
        super(name, delay, timeUnit);
        this.exitCode = exitCode;
        this.finalApplicationStatus = finalApplicationStatus;
        this.containers.addAll(containers);
        this.components.addAll(components);
        this.message = message;
    }

    @Override
    public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
        if (CollectionUtils.isNotEmpty(this.containers) || CollectionUtils.isNotEmpty(this.components)) {
            SliderAppMaster.getLog().info("SliderAppMaster.upgradeContainers: {}", (Object)this.message);
            appMaster.onUpgradeContainers(this);
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        return this.finalApplicationStatus;
    }

    public void setFinalApplicationStatus(FinalApplicationStatus finalApplicationStatus) {
        this.finalApplicationStatus = finalApplicationStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Set<String> getContainers() {
        return this.containers;
    }

    public void setContainers(Set<String> containers) {
        this.containers = containers;
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public void setComponents(Set<String> components) {
        this.components = components;
    }
}

