/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.ActionStopSlider;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.state.AppState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorHealthThreshold
extends AsyncAction {
    protected static final Logger log = LoggerFactory.getLogger(MonitorHealthThreshold.class);
    private final String roleGroup;
    private final int healthThresholdPercent;
    private final long healthThresholdWindowSecs;
    private final long healthThresholdWindowNanos;
    private long firstOccurrenceTimestamp = 0L;
    private float prevRunningContainerFraction = 0.0f;

    public MonitorHealthThreshold(String roleGroup, int healthThresholdPercent, long healthThresholdWindowSecs) {
        super("MonitorHealthThreshold");
        this.roleGroup = roleGroup;
        this.healthThresholdPercent = healthThresholdPercent;
        this.healthThresholdWindowSecs = healthThresholdWindowSecs;
        this.healthThresholdWindowNanos = TimeUnit.NANOSECONDS.convert(healthThresholdWindowSecs, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
        log.debug("MonitorHealthThreshold execute method");
        SliderAppMaster sliderAppMaster = appMaster;
        synchronized (sliderAppMaster) {
            long desiredContainerCount = appState.getDesiredContainerCount(this.roleGroup);
            if (desiredContainerCount == 0L) {
                return;
            }
            long runningContainerCount = appState.getLiveContainerCount(this.roleGroup);
            float thresholdFraction = (float)this.healthThresholdPercent / 100.0f;
            float runningContainerFraction = (float)runningContainerCount / (float)desiredContainerCount;
            boolean healthChanged = false;
            if (runningContainerFraction != this.prevRunningContainerFraction) {
                this.prevRunningContainerFraction = runningContainerFraction;
                healthChanged = true;
            }
            String runningContainerPercentStr = String.format("%.2f", Float.valueOf(runningContainerFraction * 100.0f));
            if (runningContainerFraction < thresholdFraction) {
                long currentTimestamp = this.now();
                if (this.firstOccurrenceTimestamp == 0L) {
                    this.firstOccurrenceTimestamp = currentTimestamp;
                    log.info("Role {} is going below health threshold for the first time at ts = {}", (Object)this.roleGroup, (Object)this.firstOccurrenceTimestamp);
                }
                long elapsedTime = currentTimestamp - this.firstOccurrenceTimestamp;
                long elapsedTimeSecs = TimeUnit.SECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
                log.warn("Role = {}, Current health = {}%, is below Health threshold of {}% for {} secs (window = {} secs)", new Object[]{this.roleGroup, runningContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs});
                if (elapsedTime > this.healthThresholdWindowNanos) {
                    log.error("Role = {}, Current health = {}%, has been below health threshold of {}% for {} secs (threshold window = {} secs)", new Object[]{this.roleGroup, runningContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs});
                    ActionStopSlider stopSlider = new ActionStopSlider("stop", 56, FinalApplicationStatus.FAILED, String.format("Application was killed because container health for role %s was %s%% (threshold = %d%%) for %d secs (threshold window = %d secs)", this.roleGroup, runningContainerPercentStr, this.healthThresholdPercent, elapsedTimeSecs, this.healthThresholdWindowSecs));
                    stopSlider.setExitReason(SliderExitReason.APP_ERROR);
                    appMaster.queue(stopSlider);
                }
            } else {
                String logMsg = "Role = {}, Health threshold = {}%, Current health = {}% (Current Running count = {}, Desired count = {})";
                if (healthChanged) {
                    log.info(logMsg, new Object[]{this.roleGroup, this.healthThresholdPercent, runningContainerPercentStr, runningContainerCount, desiredContainerCount});
                } else {
                    log.debug(logMsg, new Object[]{this.roleGroup, this.healthThresholdPercent, runningContainerPercentStr, runningContainerCount, desiredContainerCount});
                }
                if (this.firstOccurrenceTimestamp != 0L) {
                    log.info("Role = {}, resetting first occurence to 0, since it recovered above health threshold of {}%", (Object)this.roleGroup, (Object)this.healthThresholdPercent);
                    this.firstOccurrenceTimestamp = 0L;
                }
            }
        }
    }
}

