/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.agent;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.util.Set;
import javax.servlet.Servlet;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.services.security.SecurityUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWebApp
implements Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(AgentWebApp.class);
    private int port;
    private int securedPort;
    private static Server agentServer;
    public static final String BASE_PATH = "slideragent";

    public static Builder $for(String name, WebAppApi app, String wsPrefix) {
        return new Builder(name, wsPrefix, app);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecuredPort(int securedPort) {
        this.securedPort = securedPort;
    }

    public int getSecuredPort() {
        return this.securedPort;
    }

    @Override
    public void close() throws IOException {
        try {
            agentServer.stop();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
    }

    public static class Builder {
        final String name;
        final String wsName;
        final WebAppApi application;
        int port;
        int securedPort;
        MapOperations configsMap;

        public Builder(String name, String wsName, WebAppApi application) {
            this.name = name;
            this.wsName = wsName;
            this.application = application;
        }

        public Builder withComponentConfig(MapOperations appMasterConfig) {
            this.configsMap = appMasterConfig;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withSecuredPort(int securedPort) {
            this.securedPort = securedPort;
            return this;
        }

        public AgentWebApp start() throws IOException {
            if (this.configsMap == null) {
                throw new IllegalStateException("No SSL Configuration Available");
            }
            agentServer = new Server();
            agentServer.setThreadPool((ThreadPool)new QueuedThreadPool(this.configsMap.getOptionInt("agent.threadpool.size.max", 25)));
            agentServer.setStopAtShutdown(true);
            agentServer.setGracefulShutdown(1000);
            SslSelectChannelConnector ssl1WayConnector = this.createSSLConnector(false, this.port);
            SslSelectChannelConnector ssl2WayConnector = this.createSSLConnector(Boolean.valueOf(this.configsMap.getOption("ssl.server.client.auth", "false")), this.securedPort);
            agentServer.setConnectors(new Connector[]{ssl1WayConnector, ssl2WayConnector});
            ServletHolder agent = new ServletHolder((Servlet)new AgentServletContainer());
            org.mortbay.jetty.servlet.Context agentRoot = new org.mortbay.jetty.servlet.Context((HandlerContainer)agentServer, "/", 1);
            agent.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
            agent.setInitParameter("com.sun.jersey.config.property.packages", "org.apache.slider.server.appmaster.web.rest.agent");
            agent.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
            agentRoot.addServlet(agent, "/*");
            try {
                this.openListeners();
                agentServer.start();
            }
            catch (IOException e) {
                LOG.error("Unable to start agent server", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("Unable to start agent server", (Throwable)e);
                throw new IOException("Unable to start agent server: " + e, e);
            }
            AgentWebApp webApp = new AgentWebApp();
            webApp.setPort(this.getConnectorPort(agentServer, 0));
            webApp.setSecuredPort(this.getConnectorPort(agentServer, 1));
            return webApp;
        }

        private void openListeners() throws Exception {
            Connector[] connectorArray = agentServer.getConnectors();
            int n = connectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Connector listener = connectorArray[n2];
                if (listener.getLocalPort() == -1) {
                    int port = listener.getPort();
                    while (true) {
                        try {
                            listener.close();
                            listener.open();
                            LOG.info("Jetty bound to port " + listener.getLocalPort());
                        }
                        catch (BindException ex) {
                            if (port == 0) {
                                BindException be = new BindException("Port in use: " + listener.getHost() + ":" + listener.getPort());
                                be.initCause(ex);
                                throw be;
                            }
                            listener.setPort(++port);
                            Thread.sleep(100L);
                            continue;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }

        private SslSelectChannelConnector createSSLConnector(boolean needClientAuth, int port) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            String keystore = String.valueOf(SecurityUtils.getSecurityDir()) + File.separator + "keystore.p12";
            String srvrCrtPass = SecurityUtils.getKeystorePass();
            sslConnector.setKeystore(keystore);
            sslConnector.setTruststore(keystore);
            sslConnector.setPassword(srvrCrtPass);
            sslConnector.setKeyPassword(srvrCrtPass);
            sslConnector.setTrustPassword(srvrCrtPass);
            sslConnector.setKeystoreType("PKCS12");
            sslConnector.setTruststoreType("PKCS12");
            sslConnector.setNeedClientAuth(needClientAuth);
            sslConnector.setPort(port);
            sslConnector.setAcceptors(2);
            return sslConnector;
        }

        private int getConnectorPort(Server webServer, int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
            if (index > webServer.getConnectors().length) {
                throw new IllegalStateException("Illegal connect index requested");
            }
            Connector c = webServer.getConnectors()[index];
            if (c.getLocalPort() == -1) {
                throw new IllegalStateException("The connector is not bound to a port");
            }
            return c.getLocalPort();
        }

        public class AgentServletContainer
        extends ServletContainer {
            protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
                super.configure(wc, rc, wa);
                Set singletons = rc.getSingletons();
                singletons.add(new WebAppApiProvider());
            }
        }

        @Provider
        public class WebAppApiProvider
        extends SingletonTypeInjectableProvider<Context, WebAppApi> {
            public WebAppApiProvider() {
                super(WebAppApi.class, (Object)Builder.this.application);
            }
        }
    }
}

