/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.AHSProxy;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class AppReportFetcher {
    private static final Log LOG = LogFactory.getLog(AppReportFetcher.class);
    private final Configuration conf;
    private final ApplicationClientProtocol applicationsManager;
    private final ApplicationHistoryProtocol historyManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean isAHSEnabled;

    public AppReportFetcher(Configuration conf) {
        if (conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.isAHSEnabled = true;
        }
        this.conf = conf;
        try {
            this.applicationsManager = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class, (boolean)true);
            this.historyManager = this.isAHSEnabled ? this.getAHSProxy(conf) : null;
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public AppReportFetcher(Configuration conf, ApplicationClientProtocol applicationsManager) {
        if (conf.getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
            this.isAHSEnabled = true;
        }
        this.conf = conf;
        this.applicationsManager = applicationsManager;
        if (this.isAHSEnabled) {
            try {
                this.historyManager = this.getAHSProxy(conf);
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
        } else {
            this.historyManager = null;
        }
    }

    protected ApplicationHistoryProtocol getAHSProxy(Configuration configuration) throws IOException {
        return (ApplicationHistoryProtocol)AHSProxy.createAHSProxy((Configuration)configuration, ApplicationHistoryProtocol.class, (InetSocketAddress)configuration.getSocketAddr("yarn.timeline-service.address", "0.0.0.0:10200", 10200));
    }

    public FetchedAppReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        FetchedAppReport fetchedAppReport;
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        try {
            ApplicationReport appReport = this.applicationsManager.getApplicationReport(request).getApplicationReport();
            fetchedAppReport = new FetchedAppReport(appReport, AppReportSource.RM);
        }
        catch (ApplicationNotFoundException e) {
            if (!this.isAHSEnabled) {
                throw e;
            }
            ApplicationReport appReport = this.historyManager.getApplicationReport(request).getApplicationReport();
            fetchedAppReport = new FetchedAppReport(appReport, AppReportSource.AHS);
        }
        return fetchedAppReport;
    }

    public void stop() {
        if (this.applicationsManager != null) {
            RPC.stopProxy((Object)this.applicationsManager);
        }
        if (this.historyManager != null) {
            RPC.stopProxy((Object)this.historyManager);
        }
    }

    static class FetchedAppReport {
        private ApplicationReport appReport;
        private AppReportSource appReportSource;

        public FetchedAppReport(ApplicationReport appReport, AppReportSource appReportSource) {
            this.appReport = appReport;
            this.appReportSource = appReportSource;
        }

        public AppReportSource getAppReportSource() {
            return this.appReportSource;
        }

        public ApplicationReport getApplicationReport() {
            return this.appReport;
        }
    }

    static enum AppReportSource {
        RM,
        AHS;

    }
}

