/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.BaseIndividualBlockLock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;

class IndividualBlockLock
extends BaseIndividualBlockLock {
    private static final long NON_EXISTING_BLOCK = Long.MIN_VALUE;
    protected final long blockId;
    protected final long inodeId;

    public IndividualBlockLock() {
        this.blockId = Long.MIN_VALUE;
        this.inodeId = BlockInfoContiguous.NON_EXISTING_ID;
    }

    IndividualBlockLock(long blockId, INodeIdentifier inode) {
        this.blockId = blockId;
        this.inodeId = inode == null ? (long)BlockInfoContiguous.NON_EXISTING_ID : inode.getInodeId();
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        this.readBlock(this.blockId, this.inodeId);
    }

    private void announceBlockDoesNotExist() throws TransactionContextException {
        EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.BlockDoesNotExist, (Object[])new Object[]{this.blockId, this.inodeId});
    }

    protected void announceEmptyFile(long inodeFileId) throws TransactionContextException {
        EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.EmptyFile, (Object[])new Object[]{inodeFileId});
    }

    protected void readBlock(long blkId, long inodeId) throws IOException {
        if (blkId != Long.MIN_VALUE || blkId > 0L) {
            BlockInfoContiguous result = (BlockInfoContiguous)this.acquireLock(DEFAULT_LOCK_TYPE, BlockInfoContiguous.Finder.ByBlockIdAndINodeId, new Object[]{blkId, inodeId});
            if (result != null) {
                this.blocks.add(result);
            } else {
                this.announceBlockDoesNotExist();
            }
        }
    }
}

