/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

public class XAttrLock
extends Lock {
    private final List<XAttr> attrs;

    public XAttrLock(List<XAttr> attrs) {
        this.attrs = attrs;
    }

    public XAttrLock(XAttr attr) {
        if (attr != null) {
            this.attrs = new ArrayList<XAttr>();
            this.attrs.add(attr);
        } else {
            this.attrs = null;
        }
    }

    public XAttrLock() {
        this.attrs = null;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
        for (INode inode : inodeLock.getTargetINodes()) {
            if (this.attrs == null || this.attrs.isEmpty()) {
                if (inode.getNumXAttrs() == 0) {
                    EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.NoXAttrsAttached, (Object[])new Object[]{inode.getId()});
                    continue;
                }
                this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)StoredXAttr.Finder.ByInodeId, new Object[]{inode.getId()});
                continue;
            }
            this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)StoredXAttr.Finder.ByPrimaryKeyBatch, new Object[]{XAttrFeature.getPrimaryKeys(inode.getId(), this.attrs)});
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.XAttr;
    }
}

