/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsFileStatus {
    private byte[] path;
    private byte[] symlink;
    private long length;
    private boolean isdir;
    private short block_replication;
    private long blocksize;
    private long modification_time;
    private long access_time;
    private FsPermission permission;
    private String owner;
    private String group;
    private long fileId;
    private int childrenNum;
    private boolean isFileStoredInDB;
    private final byte storagePolicy;
    public static final byte[] EMPTY_NAME = new byte[0];

    public HdfsFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] symlink, byte[] path, long fileId, int childrenNum, boolean isFileStoredInDB, byte storagePolicy) {
        this.length = length;
        this.isdir = isdir;
        this.block_replication = (short)block_replication;
        this.blocksize = blocksize;
        this.modification_time = modification_time;
        this.access_time = access_time;
        this.permission = permission == null ? (isdir || symlink != null ? FsPermission.getDefault() : FsPermission.getFileDefault()) : permission;
        this.owner = owner == null ? "" : owner;
        this.group = group == null ? "" : group;
        this.symlink = symlink;
        this.path = path;
        this.fileId = fileId;
        this.isFileStoredInDB = isFileStoredInDB;
        this.storagePolicy = storagePolicy;
        this.childrenNum = childrenNum;
    }

    public final long getLen() {
        return this.length;
    }

    public final boolean isDir() {
        return this.isdir;
    }

    public boolean isSymlink() {
        return this.symlink != null;
    }

    public final long getBlockSize() {
        return this.blocksize;
    }

    public final short getReplication() {
        return this.block_replication;
    }

    public final long getModificationTime() {
        return this.modification_time;
    }

    public final long getAccessTime() {
        return this.access_time;
    }

    public final FsPermission getPermission() {
        return this.permission;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getGroup() {
        return this.group;
    }

    public final boolean isEmptyLocalName() {
        return this.path.length == 0;
    }

    public final String getLocalName() {
        return DFSUtil.bytes2String(this.path);
    }

    public final byte[] getLocalNameInBytes() {
        return this.path;
    }

    public final String getFullName(String parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        StringBuilder fullName = new StringBuilder(parent);
        if (!parent.endsWith("/")) {
            fullName.append("/");
        }
        fullName.append(this.getLocalName());
        return fullName.toString();
    }

    public final Path getFullPath(Path parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        return new Path(parent, this.getLocalName());
    }

    public final String getSymlink() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public final byte[] getSymlinkInBytes() {
        return this.symlink;
    }

    public final long getFileId() {
        return this.fileId;
    }

    public final int getChildrenNum() {
        return this.childrenNum;
    }

    public final boolean isFileStoredInDB() {
        return this.isFileStoredInDB;
    }

    public void setFileStoredInDB(boolean isFileStoredInDB) {
        this.isFileStoredInDB = isFileStoredInDB;
    }

    public final FileStatus makeQualified(URI defaultUri, Path path) {
        return new FileStatus(this.getLen(), this.isDir(), (int)this.getReplication(), this.getBlockSize(), this.getModificationTime(), this.getAccessTime(), this.getPermission(), this.getOwner(), this.getGroup(), this.isSymlink() ? new Path(this.getSymlink()) : null, this.getFullPath(path).makeQualified(defaultUri, null));
    }

    public final byte getStoragePolicy() {
        return this.storagePolicy;
    }
}

