/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;

class FSDirStatAndListingOp {
    FSDirStatAndListingOp() {
    }

    static DirectoryListing getListingInt(final FSDirectory fsd, String srcArg, byte[] startAfterArg, final boolean needLocation) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        String startAfterString = new String(startAfterArg, Charsets.UTF_8);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        if (FSDirectory.isReservedName(startAfterString)) {
            byte[][] startAfterComponents = FSDirectory.getPathComponentsForReservedPath(startAfterString);
            try {
                String tmp = FSDirectory.resolvePath(src, startAfterComponents, fsd);
                byte[][] regularPath = INode.getPathComponents(tmp);
                startAfterArg = regularPath[regularPath.length - 1];
            }
            catch (IOException e) {
                throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
            }
        }
        final byte[] startAfter = startAfterArg;
        HopsTransactionalRequestHandler getListingHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_LISTING, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                if (needLocation) {
                    locks.add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
                }
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath(src, true);
                boolean isSuperUser = pc.isSuperUser();
                if (fsd.isPermissionEnabled()) {
                    if (iip.getLastINode() != null && iip.getLastINode().isDirectory()) {
                        fsd.checkPathAccess(pc, iip, FsAction.READ_EXECUTE);
                    } else {
                        fsd.checkTraverse(pc, iip);
                    }
                }
                return FSDirStatAndListingOp.getListing(fsd, iip, src, startAfter, needLocation, isSuperUser);
            }
        };
        return (DirectoryListing)getListingHandler.handle();
    }

    static HdfsFileStatus getFileInfo(final FSDirectory fsd, String srcArg, final boolean resolveLink) throws IOException {
        if (!DFSUtil.isValidName(srcArg)) {
            throw new InvalidPathException("Invalid file name: " + srcArg);
        }
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = FSDirectory.resolvePath(srcArg, pathComponents, fsd);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.GET_FILE_INFO, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).resolveSymLink(resolveLink).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath(src, resolveLink);
                boolean isSuperUser = true;
                if (fsd.isPermissionEnabled()) {
                    fsd.checkPermission(pc, iip, false, null, null, null, null, false);
                    isSuperUser = pc.isSuperUser();
                }
                return FSDirStatAndListingOp.getFileInfo(fsd, src, resolveLink, isSuperUser);
            }
        }.handle();
    }

    static boolean isFileClosed(final FSDirectory fsd, String srcArg) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = FSDirectory.resolvePath(srcArg, pathComponents, fsd);
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.GET_FILE_INFO, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath(src, true);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkTraverse(pc, iip);
                }
                return !INodeFile.valueOf(iip.getLastINode(), src).isUnderConstruction();
            }
        }.handle();
    }

    static ContentSummary getContentSummary(FSDirectory fsd, String src) throws IOException {
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, src);
    }

    private static byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    private static DirectoryListing getListing(FSDirectory fsd, INodesInPath iip, String src, byte[] startAfter, boolean needLocation, boolean isSuperUser) throws IOException {
        byte parentStoragePolicy;
        String srcs = FSDirectory.normalizePath(src);
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return null;
        }
        byte by = parentStoragePolicy = isSuperUser ? targetNode.getStoragePolicyID() : (byte)0;
        if (!targetNode.isDirectory()) {
            return new DirectoryListing(new HdfsFileStatus[]{FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, targetNode, needLocation, parentStoragePolicy, iip)}, 0);
        }
        INodeDirectory dirInode = targetNode.asDirectory();
        List<INode> contents = dirInode.getChildrenList();
        int startChild = dirInode.nextChild(contents, startAfter);
        int totalNumChildren = contents.size();
        int numOfListing = Math.min(totalNumChildren - startChild, fsd.getLsLimit());
        int locationBudget = fsd.getLsLimit();
        int listingCnt = 0;
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
            INode cur = contents.get(startChild + i);
            byte curPolicy = isSuperUser && !cur.isSymlink() ? cur.getLocalStoragePolicyID() : (byte)0;
            listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, cur.getLocalNameBytes(), cur, needLocation, FSDirStatAndListingOp.getStoragePolicyID(curPolicy, parentStoragePolicy), iip);
            ++listingCnt;
            if (!needLocation) continue;
            LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
            locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
        }
        if (listingCnt < numOfListing) {
            listing = Arrays.copyOf(listing, listingCnt);
        }
        return new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
    }

    static HdfsFileStatus getFileInfo(FSDirectory fsd, INodesInPath src, boolean includeStoragePolicy) throws IOException {
        INode i = src.getLastINode();
        byte policyId = includeStoragePolicy && i != null && !i.isSymlink() ? i.getStoragePolicyID() : (byte)0;
        return i == null ? null : FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, i, policyId, src);
    }

    static HdfsFileStatus getFileInfo(FSDirectory fsd, String src, boolean resolveLink, boolean includeStoragePolicy) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = fsd.getINodesInPath(srcs, resolveLink);
        return FSDirStatAndListingOp.getFileInfo(fsd, iip, includeStoragePolicy);
    }

    static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INode node, boolean needLocation, byte storagePolicy, INodesInPath iip) throws IOException {
        if (needLocation) {
            return FSDirStatAndListingOp.createLocatedFileStatus(fsd, path, node, storagePolicy, iip);
        }
        return FSDirStatAndListingOp.createFileStatus(fsd, path, node, storagePolicy, iip);
    }

    static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INode node, byte storagePolicy, INodesInPath iip) throws IOException {
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        boolean isStoredInDB = false;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            isStoredInDB = fileNode.isFileStoredInDB();
            size = fileNode.getSize();
            replication = fileNode.getBlockReplication();
            blocksize = fileNode.getPreferredBlockSize();
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum() : 0;
        return new HdfsFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(), node.getAccessTime(), FSDirStatAndListingOp.getPermissionForFileStatus(node), node.getUserName(), node.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), childrenNum, isStoredInDB, storagePolicy);
    }

    private static HdfsLocatedFileStatus createLocatedFileStatus(FSDirectory fsd, byte[] path, INode node, byte storagePolicy, INodesInPath iip) throws IOException {
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        boolean isStoredInDB = false;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            isStoredInDB = fileNode.isFileStoredInDB();
            size = isStoredInDB ? fileNode.getSize() : fileNode.computeFileSize();
            replication = fileNode.getBlockReplication();
            blocksize = fileNode.getPreferredBlockSize();
            boolean isUc = fileNode.isUnderConstruction();
            long fileSize = isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = isStoredInDB ? fsd.getFSNamesystem().getBlockManager().createPhantomLocatedBlocks(fileNode, null, isUc, false) : fsd.getFSNamesystem().getBlockManager().createLocatedBlocks(fileNode.getBlocks(), fileSize, isUc, 0L, size, false);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum() : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(), node.getAccessTime(), FSDirStatAndListingOp.getPermissionForFileStatus(node), node.getUserName(), node.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum, isStoredInDB, storagePolicy);
        if (loc != null) {
            CacheManager cacheManager = fsd.getFSNamesystem().getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb, node.getId());
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INode node) throws IOException {
        boolean hasAcl;
        FsPermission perm = node.getFsPermission();
        boolean bl = hasAcl = node.getAclFeature() != null;
        if (hasAcl) {
            perm = new FsAclPermission(perm);
        }
        return perm;
    }

    private static ContentSummary getContentSummaryInt(FSDirectory fsd, String src) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = FSDirectory.resolvePath(src, pathComponents, fsd);
        PathInformation pathInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(src, false, null, null, null, null);
        if (pathInfo.getINodesInPath().getLastINode() == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        INode subtreeRoot = pathInfo.getINodesInPath().getLastINode();
        QuotaCounts subtreeQuota = pathInfo.getQuota();
        INodeIdentifier subtreeRootIdentifier = new INodeIdentifier(Long.valueOf(subtreeRoot.getId()), Long.valueOf(subtreeRoot.getParentId()), subtreeRoot.getLocalName(), subtreeRoot.getPartitionId());
        subtreeRootIdentifier.setDepth(Short.valueOf((short)(0 + pathInfo.getPathComponents().length - 1)));
        List<AclEntry> nearestDefaultsForSubtree = fsd.getFSNamesystem().calculateNearestDefaultAclForSubtree(pathInfo);
        byte inheritedStoragePolicy = fsd.getFSNamesystem().calculateNearestinheritedStoragePolicy(pathInfo);
        AbstractFileTree.CountingFileTree fileTree = new AbstractFileTree.CountingFileTree(fsd.getFSNamesystem(), subtreeRootIdentifier, FsAction.READ_EXECUTE, true, nearestDefaultsForSubtree, inheritedStoragePolicy);
        fileTree.buildUp(fsd.getBlockStoragePolicySuite());
        ContentCounts counts = fileTree.getCounts();
        QuotaCounts q = subtreeQuota;
        if (q == null) {
            q = subtreeRoot.getQuotaCounts();
        }
        ContentSummary cs = new ContentSummary.Builder().length(counts.getLength()).fileCount(counts.getFileCount() + counts.getSymlinkCount()).directoryCount(counts.getDirectoryCount()).quota(q.getNameSpace()).spaceConsumed(counts.getStoragespace()).spaceQuota(q.getStorageSpace()).typeConsumed(counts.getTypeSpaces()).typeQuota(q.getTypeSpaces().asArray()).build();
        fsd.addYieldCount(0L);
        return cs;
    }
}

