/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.CancelDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryServlet;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.FileDataServlet;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.GetDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.ListPathsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.RenewDelegationTokenServlet;
import org.apache.hadoop.hdfs.server.namenode.StartupProgressServlet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer3;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.mortbay.jetty.servlet.Context;

@InterfaceAudience.Private
public class NameNodeHttpServer {
    private HttpServer3 httpServer;
    private final Configuration conf;
    private final NameNode nn;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private InetSocketAddress bindAddress;
    public static final String NAMENODE_ADDRESS_ATTRIBUTE_KEY = "name.node.address";
    public static final String FSIMAGE_ATTRIBUTE_KEY = "name.system.image";
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";
    public static final String STARTUP_PROGRESS_ATTRIBUTE_KEY = "startup.progress";

    NameNodeHttpServer(Configuration conf, NameNode nn, InetSocketAddress bindAddress) {
        this.conf = conf;
        this.nn = nn;
        this.bindAddress = bindAddress;
    }

    private void initWebHdfs(Configuration conf) throws IOException {
        if (WebHdfsFileSystem.isEnabled(conf, HttpServer3.LOG)) {
            String className;
            UserParam.setUserPattern((String)conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
            String name = className = conf.get("dfs.web.authentication.filter", DFSConfigKeys.DFS_WEBHDFS_AUTHENTICATION_FILTER_DEFAULT);
            String pathSpec = "/webhdfs/v1/*";
            Map<String, String> params = this.getAuthFilterParams(conf);
            HttpServer3.defineFilter((Context)this.httpServer.getWebAppContext(), (String)name, (String)className, params, (String[])new String[]{"/webhdfs/v1/*"});
            HttpServer3.LOG.info((Object)("Added filter '" + name + "' (class=" + className + ")"));
            this.httpServer.addJerseyResourcePackage(NamenodeWebHdfsMethods.class.getPackage().getName() + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*");
        }
    }

    void start() throws IOException {
        String bindHost;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(this.conf);
        String infoHost = this.bindAddress.getHostName();
        InetSocketAddress httpAddr = this.bindAddress;
        String httpsAddrString = this.conf.getTrimmed("dfs.namenode.https-address", "0.0.0.0:50470");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr((String)httpsAddrString);
        if (httpsAddr != null && (bindHost = this.conf.getTrimmed("dfs.namenode.https-bind-host")) != null && !bindHost.isEmpty()) {
            httpsAddr = new InetSocketAddress(bindHost, httpsAddr.getPort());
        }
        HttpServer3.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, httpAddr, httpsAddr, "hdfs", "dfs.namenode.kerberos.internal.spnego.principal", "dfs.namenode.keytab.file");
        this.httpServer = builder.build();
        if (policy.isHttpsEnabled()) {
            InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr((String)this.conf.getTrimmed("dfs.datanode.https.address", infoHost + ":" + 50475));
            this.httpServer.setAttribute("datanode.https.port", (Object)datanodeSslPort.getPort());
        }
        this.initWebHdfs(this.conf);
        this.httpServer.setAttribute(NAMENODE_ATTRIBUTE_KEY, (Object)this.nn);
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        NameNodeHttpServer.setupServlets(this.httpServer, this.conf);
        this.httpServer.start();
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            this.conf.set("dfs.namenode.http-address", NetUtils.getHostPortString((InetSocketAddress)this.httpAddress));
        }
        if (policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            this.conf.set("dfs.namenode.https-address", NetUtils.getHostPortString((InetSocketAddress)this.httpsAddress));
        }
    }

    private Map<String, String> getAuthFilterParams(Configuration conf) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = conf.get("dfs.web.authentication.kerberos.principal");
        if (principalInConf != null && !principalInConf.isEmpty()) {
            params.put("dfs.web.authentication.kerberos.principal", SecurityUtil.getServerPrincipal((String)principalInConf, (String)this.bindAddress.getHostName()));
        } else if (UserGroupInformation.isSecurityEnabled()) {
            HttpServer3.LOG.error((Object)"WebHDFS and security are enabled, but configuration property 'dfs.web.authentication.kerberos.principal' is not set.");
        }
        String httpKeytab = conf.get(DFSUtil.getSpnegoKeytabKey(conf, "dfs.namenode.keytab.file"));
        if (httpKeytab != null && !httpKeytab.isEmpty()) {
            params.put("dfs.web.authentication.kerberos.keytab", httpKeytab);
        } else if (UserGroupInformation.isSecurityEnabled()) {
            HttpServer3.LOG.error((Object)"WebHDFS and security are enabled, but configuration property 'dfs.web.authentication.kerberos.keytab' is not set.");
        }
        String anonymousAllowed = conf.get("dfs.web.authentication.simple.anonymous.allowed");
        if (anonymousAllowed != null && !anonymousAllowed.isEmpty()) {
            params.put("dfs.web.authentication.simple.anonymous.allowed", anonymousAllowed);
        }
        return params;
    }

    void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    void setNameNodeAddress(InetSocketAddress nameNodeAddress) {
        this.httpServer.setAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY, (Object)NetUtils.getConnectAddress((InetSocketAddress)nameNodeAddress));
    }

    void setStartupProgress(StartupProgress prog) {
        this.httpServer.setAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY, (Object)prog);
    }

    private static void setupServlets(HttpServer3 httpServer, Configuration conf) {
        httpServer.addInternalServlet("startupProgress", "/startupProgress", StartupProgressServlet.class);
        httpServer.addInternalServlet("getDelegationToken", "/getDelegationToken", GetDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("renewDelegationToken", "/renewDelegationToken", RenewDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("cancelDelegationToken", "/cancelDelegationToken", CancelDelegationTokenServlet.class, true);
        httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class, true);
        httpServer.addInternalServlet("listPaths", "/listPaths/*", ListPathsServlet.class, false);
        httpServer.addInternalServlet("data", "/data/*", FileDataServlet.class, false);
        httpServer.addInternalServlet("checksum", "/fileChecksum/*", FileChecksumServlets.RedirectServlet.class, false);
        httpServer.addInternalServlet("contentSummary", "/contentSummary/*", ContentSummaryServlet.class, false);
    }

    public static NameNode getNameNodeFromContext(ServletContext context) {
        return (NameNode)context.getAttribute(NAMENODE_ATTRIBUTE_KEY);
    }

    static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }

    public static InetSocketAddress getNameNodeAddressFromContext(ServletContext context) {
        return (InetSocketAddress)context.getAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY);
    }

    static StartupProgress getStartupProgressFromContext(ServletContext context) {
        return (StartupProgress)context.getAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY);
    }
}

