/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class NativeCodeLoader {
    private static final Log LOG;
    private static boolean nativeCodeLoaded;

    private NativeCodeLoader() {
    }

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public static native boolean buildSupportsSnappy();

    public static native boolean buildSupportsOpenssl();

    public static native boolean buildSupportsIsal();

    public static native String getLibraryName();

    static {
        block4: {
            LOG = LogFactory.getLog(NativeCodeLoader.class);
            nativeCodeLoaded = false;
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Trying to load the custom-built native-hadoop library...");
            }
            try {
                System.loadLibrary("hadoop");
                LOG.warn((Object)"Loaded the native-hadoop library");
                nativeCodeLoaded = true;
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                System.out.println(t);
                LOG.warn((Object)("Failed to load native-hadoop with error: " + t));
                LOG.warn((Object)("java.library.path=" + System.getProperty("java.library.path")));
            }
        }
        if (!nativeCodeLoaded) {
            LOG.warn((Object)"Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

