#!/usr/bin/env python
"""
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Slider Agent

"""

import time
import os
from resource_management import *

class PropertiesFileProvider(Provider):
  def action_create(self):
    filename = self.resource.filename
    dir = self.resource.dir
    if dir == None:
      filepath = filename
    else:
      filepath = os.path.join(dir, filename)

    config_content = InlineTemplate('''# Generated by Apache Slider. {{time.asctime(time.localtime())}}
    {% for key, value in properties_dict|dictsort %}
{{key}}={{value}}{% endfor %}
    ''', extra_imports=[time], properties_dict=self.resource.properties)

    Logger.info(format("Generating properties file: {filepath}"))

    with Environment.get_instance_copy() as env:
      File (format("{filepath}"),
            content = config_content,
            owner = self.resource.owner,
            group = self.resource.group,
            mode = self.resource.mode
      )
