/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTezIds {
    private static final Logger LOG = LoggerFactory.getLogger(TestTezIds.class);

    private void verifyDagInfo(String[] splits, TezDAGID dagId) {
        Assert.assertEquals((long)dagId.getApplicationId().getClusterTimestamp(), (long)Long.valueOf(splits[1]));
        Assert.assertEquals((long)dagId.getApplicationId().getId(), (long)Integer.valueOf(splits[2]).intValue());
        Assert.assertEquals((long)dagId.getId(), (long)Integer.valueOf(splits[3]).intValue());
    }

    private void verifyVertexInfo(String[] splits, TezVertexID vId) {
        this.verifyDagInfo(splits, vId.getDAGId());
        Assert.assertEquals((long)vId.getId(), (long)Integer.valueOf(splits[4]).intValue());
    }

    private void verifyTaskInfo(String[] splits, TezTaskID tId) {
        this.verifyVertexInfo(splits, tId.getVertexID());
        Assert.assertEquals((long)tId.getId(), (long)Integer.valueOf(splits[5]).intValue());
    }

    private void verifyAttemptInfo(String[] splits, TezTaskAttemptID taId) {
        this.verifyTaskInfo(splits, taId.getTaskID());
        Assert.assertEquals((long)taId.getId(), (long)Integer.valueOf(splits[6]).intValue());
    }

    private void verifyDagId(String dagIdStr, TezDAGID dagId) {
        String[] splits = dagIdStr.split("_");
        Assert.assertEquals((long)4L, (long)splits.length);
        this.verifyDagInfo(splits, dagId);
    }

    private void verifyVertexId(String vIdStr, TezVertexID vId) {
        String[] splits = vIdStr.split("_");
        Assert.assertEquals((long)5L, (long)splits.length);
        this.verifyVertexInfo(splits, vId);
    }

    private void verifyTaskId(String tIdStr, TezTaskID tId) {
        String[] splits = tIdStr.split("_");
        Assert.assertEquals((long)6L, (long)splits.length);
        this.verifyTaskInfo(splits, tId);
    }

    private void verifyAttemptId(String taIdStr, TezTaskAttemptID taId) {
        String[] splits = taIdStr.split("_");
        Assert.assertEquals((long)7L, (long)splits.length);
        this.verifyAttemptInfo(splits, taId);
    }

    @Test(timeout=5000L)
    public void testIdStringify() {
        ApplicationId appId = ApplicationId.newInstance((long)9999L, (int)72);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)dagId, (int)35);
        TezTaskID tId = TezTaskID.getInstance((TezVertexID)vId, (int)389);
        TezTaskAttemptID taId = TezTaskAttemptID.getInstance((TezTaskID)tId, (int)2);
        String dagIdStr = dagId.toString();
        String vIdStr = vId.toString();
        String tIdStr = tId.toString();
        String taIdStr = taId.toString();
        LOG.info("DAG ID:" + dagIdStr);
        LOG.info("Vertex ID:" + vIdStr);
        LOG.info("Task ID:" + tIdStr);
        LOG.info("Attempt ID:" + taIdStr);
        Assert.assertTrue((boolean)dagIdStr.startsWith("dag"));
        Assert.assertTrue((boolean)vIdStr.startsWith("vertex"));
        Assert.assertTrue((boolean)tIdStr.startsWith("task"));
        Assert.assertTrue((boolean)taIdStr.startsWith("attempt"));
        this.verifyDagId(dagIdStr, dagId);
        this.verifyVertexId(vIdStr, vId);
        this.verifyTaskId(tIdStr, tId);
        this.verifyAttemptId(taIdStr, taId);
    }

    @Test(timeout=5000L)
    public void testInvalidDagIds() {
        TezDAGID dagId;
        String dagIdStr = "aaa_111_1_1";
        try {
            dagId = TezDAGID.fromString((String)dagIdStr);
            Assert.fail((String)("Expected failure for invalid dagId=" + dagIdStr));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid DAG Id format"));
        }
        dagIdStr = "dag_111_11";
        try {
            dagId = TezDAGID.fromString((String)dagIdStr);
            Assert.fail((String)("Expected failure for invalid dagId=" + dagIdStr));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid DAG Id format"));
        }
        dagIdStr = "dag_111_11_aa";
        try {
            dagId = TezDAGID.fromString((String)dagIdStr);
            Assert.fail((String)("Expected failure for invalid dagId=" + dagIdStr));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error while parsing"));
        }
        dagIdStr = "dag_111_aa_1";
        try {
            dagId = TezDAGID.fromString((String)dagIdStr);
            Assert.fail((String)("Expected failure for invalid dagId=" + dagIdStr));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error while parsing"));
        }
    }

    public void testGetGroupIds() {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        int numDagsPerGroup = 5;
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        String groupId1 = dagId.getGroupId(numDagsPerGroup);
        for (i = 0; i < numDagsPerGroup; ++i) {
            Assert.assertEquals((Object)TezDAGID.getInstance((ApplicationId)appId, (int)(i + 1)).getGroupId(numDagsPerGroup), (Object)groupId1);
        }
        Assert.assertNotEquals((Object)TezDAGID.getInstance((ApplicationId)appId, (int)(numDagsPerGroup + 1)).getGroupId(numDagsPerGroup), (Object)groupId1);
        for (i = -1; i < 2; ++i) {
            try {
                dagId.getGroupId(i);
                Assert.fail((String)("Expected IllegalArgumentException for numDagsPerGroup: " + i));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

