/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskReport;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.TaskStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptKilled;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventKillRequest;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventScheduleTask;
import org.apache.tez.dag.app.dag.event.TaskEventTAFailed;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.event.TaskEventTermination;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEventTaskAttemptCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskReschedule;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskReportImpl;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptEnded;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.state.OnStateChangedCallback;
import org.apache.tez.state.StateMachineTez;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskImpl.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Configuration conf;
    protected final TaskCommunicatorManagerInterface taskCommunicatorManagerInterface;
    protected final TaskHeartbeatHandler taskHeartbeatHandler;
    protected final EventHandler eventHandler;
    private final TezTaskID taskId;
    private Map<TezTaskAttemptID, TaskAttempt> attempts;
    protected final int maxFailedAttempts;
    protected final Clock clock;
    private final Vertex vertex;
    private final Lock readLock;
    private final Lock writeLock;
    private final List<String> diagnostics = new ArrayList<String>();
    private TezCounters counters = new TezCounters();
    protected final AppContext appContext;
    private final Resource taskResource;
    private TaskSpec baseTaskSpec;
    private TaskLocationHint locationHint;
    private final ContainerContext containerContext;
    @VisibleForTesting
    long scheduledTime;
    final StateChangeNotifier stateChangeNotifier;
    private final RecoveryParser.TaskRecoveryData recoveryData;
    private final List<TezEvent> tezEventsForTaskAttempts = new ArrayList<TezEvent>();
    static final ArrayList<TezEvent> EMPTY_TASK_ATTEMPT_TEZ_EVENTS = new ArrayList(0);
    private final Map<Integer, Boolean> taskAttemptStatus = new HashMap<Integer, Boolean>();
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> REDUNDANT_COMPLETED_TRANSITION = new AttemptRedundantCompletedTransition();
    private static final TaskStateChangedCallback STATE_CHANGED_CALLBACK = new TaskStateChangedCallback();
    private static final StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskStateInternal.NEW).addTransition((Enum)TaskStateInternal.NEW, EnumSet.of(TaskStateInternal.NEW, TaskStateInternal.SCHEDULED), (Enum)TaskEventType.T_SCHEDULE, (MultipleArcTransition)new InitialScheduleTransition()).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.KILLED, (Enum)TaskEventType.T_TERMINATE, (SingleArcTransition)new KillNewTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_TERMINATE, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.SUCCEEDED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new AttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition()).addTransition((Enum)TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.SUCCEEDED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new AttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_TERMINATE, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_SCHEDULE).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskEventType.T_TERMINATE, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new TaskRetroactiveFailureTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new TaskRetroactiveKilledTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, REDUNDANT_COMPLETED_TRANSITION).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_TERMINATE, TaskEventType.T_ATTEMPT_LAUNCHED)).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_SCHEDULE).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ATTEMPT_SUCCEEDED), REDUNDANT_COMPLETED_TRANSITION).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_TERMINATE, TaskEventType.T_SCHEDULE, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_LAUNCHED)).addTransition((Enum)TaskStateInternal.KILLED, (Enum)TaskStateInternal.KILLED, EnumSet.of(TaskEventType.T_TERMINATE, new TaskEventType[]{TaskEventType.T_SCHEDULE, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_SUCCEEDED, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_KILLED})).installTopology();
    private final StateMachineTez<TaskStateInternal, TaskEventType, TaskEvent, TaskImpl> stateMachine;
    private TezTaskAttemptID commitAttempt;
    @VisibleForTesting
    TezTaskAttemptID successfulAttempt;
    @VisibleForTesting
    int failedAttempts;
    private final boolean leafVertex;
    @VisibleForTesting
    long finishTime = -1L;

    private void augmentStateMachine() {
        this.stateMachine.registerStateEnteredCallback(TaskStateInternal.SUCCEEDED, STATE_CHANGED_CALLBACK);
    }

    @Override
    public TaskState getState() {
        this.readLock.lock();
        try {
            TaskState taskState = TaskImpl.getExternalState(this.getInternalState());
            return taskState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskImpl(TezVertexID vertexId, int taskIndex, EventHandler eventHandler, Configuration conf, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, boolean leafVertex, Resource resource, ContainerContext containerContext, StateChangeNotifier stateChangeNotifier, Vertex vertex) {
        this.conf = conf;
        this.clock = clock;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.maxFailedAttempts = vertex.getVertexConfig().getMaxFailedTaskAttempts();
        this.taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)taskIndex);
        this.taskCommunicatorManagerInterface = taskCommunicatorManagerInterface;
        this.taskHeartbeatHandler = thh;
        this.eventHandler = eventHandler;
        this.appContext = appContext;
        this.stateChangeNotifier = stateChangeNotifier;
        this.vertex = vertex;
        this.leafVertex = leafVertex;
        this.taskResource = resource;
        this.containerContext = containerContext;
        this.recoveryData = appContext.getDAGRecoveryData() == null ? null : appContext.getDAGRecoveryData().getTaskRecoveryData(this.taskId);
        this.stateMachine = new StateMachineTez(stateMachineFactory.make((Object)this), this);
        this.augmentStateMachine();
    }

    @Override
    public Map<TezTaskAttemptID, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map<TezTaskAttemptID, TaskAttempt> map = this.attempts;
                return map;
            }
            LinkedHashMap<TezTaskAttemptID, TaskAttempt> result = new LinkedHashMap<TezTaskAttemptID, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TezTaskAttemptID, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttempt getAttempt(TezTaskAttemptID attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public TezTaskID getTaskId() {
        return this.taskId;
    }

    @Override
    public boolean isFinished() {
        TaskStateInternal internalState = this.getInternalState();
        return internalState == TaskStateInternal.SUCCEEDED || internalState == TaskStateInternal.FAILED || internalState == TaskStateInternal.KILLED || internalState == TaskStateInternal.KILL_WAIT;
    }

    @Override
    public TaskReport getReport() {
        TaskReportImpl report = new TaskReportImpl();
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getLastTaskAttemptFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            TaskReportImpl taskReportImpl = report;
            return taskReportImpl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezCounters getCounters() {
        TezCounters counters = new TezCounters();
        counters.incrAllCounters((AbstractCounters)this.counters);
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt != null) {
                counters.incrAllCounters((AbstractCounters)bestAttempt.getCounters());
            }
            TezCounters tezCounters = counters;
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    TaskStatistics getStatistics() {
        this.readLock.lock();
        try {
            TaskAttemptImpl bestAttempt = (TaskAttemptImpl)this.selectBestAttempt();
            if (bestAttempt == null) {
                TaskStatistics taskStatistics = null;
                return taskStatistics;
            }
            TaskStatistics taskStatistics = bestAttempt.getStatistics();
            return taskStatistics;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskStateInternal state = this.getInternalState();
            if (state == TaskStateInternal.RUNNING) {
                TaskAttempt bestAttempt = this.selectBestAttempt();
                if (bestAttempt == null) {
                    float f = 0.0f;
                    return f;
                }
                float f = bestAttempt.getProgress();
                return f;
            }
            if (state == TaskStateInternal.SUCCEEDED) {
                float f = 1.0f;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<TezEvent> getTaskAttemptTezEvents(TezTaskAttemptID attemptID, int fromEventId, int maxEvents) {
        ArrayList<TezEvent> events = EMPTY_TASK_ATTEMPT_TEZ_EVENTS;
        this.readLock.lock();
        try {
            if (!this.attempts.containsKey(attemptID)) {
                throw new TezUncheckedException("Unknown TA: " + attemptID + " asking for events from task:" + this.getTaskId());
            }
            if (this.tezEventsForTaskAttempts.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.tezEventsForTaskAttempts.size() - fromEventId);
                int toEventId = actualMax + fromEventId;
                events = new ArrayList<TezEvent>(this.tezEventsForTaskAttempts.subList(fromEventId, toEventId));
                LOG.info("TaskAttempt:" + attemptID + " sent events: (" + fromEventId + "-" + toEventId + ").");
            }
            ArrayList<TezEvent> arrayList = events;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskSpec getBaseTaskSpec() {
        this.readLock.lock();
        try {
            TaskSpec taskSpec = this.baseTaskSpec;
            return taskSpec;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskLocationHint getTaskLocationHint() {
        this.readLock.lock();
        try {
            TaskLocationHint taskLocationHint = this.locationHint;
            return taskLocationHint;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public TaskStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskStateInternal taskStateInternal = this.stateMachine.getCurrentState();
            return taskStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskState getExternalState(TaskStateInternal smState) {
        if (smState == TaskStateInternal.KILL_WAIT) {
            return TaskState.KILLED;
        }
        return TaskState.valueOf(smState.name());
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getLastTaskAttemptFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private TaskStateInternal finished(TaskStateInternal finalState) {
        if (this.getInternalState() == TaskStateInternal.RUNNING) {
            // empty if block
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (at.getState()) {
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCommit(TezTaskAttemptID taskAttemptID) {
        this.writeLock.lock();
        try {
            TaskState state;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Commit go/no-go request from " + taskAttemptID);
            }
            if ((state = this.getState()) == TaskState.SCHEDULED) {
                LOG.info("Event processing delay. Attempt committing before state machine transitioned to running : Task {}", (Object)this.taskId);
                boolean bl = false;
                return bl;
            }
            if (state != TaskState.RUNNING) {
                LOG.info("Task not running. Issuing kill to bad commit attempt " + taskAttemptID);
                this.eventHandler.handle((Event)new TaskAttemptEventKillRequest(taskAttemptID, "Task not running. Bad attempt.", TaskAttemptTerminationCause.TERMINATED_ORPHANED));
                boolean bl = false;
                return bl;
            }
            if (this.commitAttempt == null) {
                TaskAttempt ta = this.getAttempt(taskAttemptID);
                if (ta == null) {
                    throw new TezUncheckedException("Unknown task for commit: " + taskAttemptID);
                }
                TaskAttemptState taState = ta.getStateNoLock();
                if (taState == TaskAttemptState.RUNNING) {
                    this.commitAttempt = taskAttemptID;
                    LOG.info(taskAttemptID + " given a go for committing the task output.");
                    boolean bl = true;
                    return bl;
                }
                LOG.info(taskAttemptID + " with state: " + (Object)((Object)taState) + " given a no-go for commit because its not running.");
                boolean bl = false;
                return bl;
            }
            if (this.commitAttempt.equals((Object)taskAttemptID)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(taskAttemptID + " already given a go for committing the task output.");
                }
                boolean bl = true;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.commitAttempt + " is current committer. Commit waiting for:  " + taskAttemptID);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    TaskAttemptImpl createAttempt(int attemptNumber, TezTaskAttemptID schedulingCausalTA) {
        TezTaskAttemptID attemptId = TezBuilderUtils.newTaskAttemptId(this.taskId, attemptNumber);
        TaskSpec taskSpec = new TaskSpec(attemptId, this.baseTaskSpec.getDAGName(), this.baseTaskSpec.getVertexName(), this.baseTaskSpec.getVertexParallelism(), this.baseTaskSpec.getProcessorDescriptor(), this.baseTaskSpec.getInputs(), this.baseTaskSpec.getOutputs(), this.baseTaskSpec.getGroupInputs(), this.baseTaskSpec.getTaskConf());
        return new TaskAttemptImpl(attemptId, this.eventHandler, this.taskCommunicatorManagerInterface, this.conf, this.clock, this.taskHeartbeatHandler, this.appContext, this.failedAttempts > 0, this.taskResource, this.containerContext, this.leafVertex, this.getVertex(), this.locationHint, taskSpec, schedulingCausalTA);
    }

    @Override
    public TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt(TezTaskAttemptID schedulingCausalTA) {
        TaskAttemptImpl attempt = this.createAttempt(this.attempts.size(), schedulingCausalTA);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created attempt " + attempt.getID());
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap<TezTaskAttemptID, TaskAttempt> newAttempts = new LinkedHashMap<TezTaskAttemptID, TaskAttempt>(this.maxFailedAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                Preconditions.checkArgument((this.attempts.put(attempt.getID(), attempt) == null ? 1 : 0) != 0, (Object)(attempt.getID() + " already existed"));
                break;
            }
            default: {
                Preconditions.checkArgument((this.attempts.put(attempt.getID(), attempt) == null ? 1 : 0) != 0, (Object)(attempt.getID() + " already existed"));
            }
        }
        this.taskAttemptStatus.put(attempt.getID().getId(), false);
        this.eventHandler.handle((Event)new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, attempt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing TaskEvent " + event.getTaskID() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event));
        }
        try {
            this.writeLock.lock();
            TaskStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition((TaskEventType)event.getType(), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error("Can't handle this event" + event.getType() + " at current state " + (Object)((Object)oldState) + " for task " + this.taskId, (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            catch (RuntimeException e) {
                LOG.error("Uncaught exception when trying handle event " + event.getType() + " at current state " + (Object)((Object)oldState) + " for task " + this.taskId, (Throwable)e);
                this.internalErrorUncaughtException((TaskEventType)event.getType(), e);
            }
            if (oldState != this.getInternalState() && LOG.isDebugEnabled()) {
                LOG.debug(this.taskId + " Task Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState()) + " due to event " + event.getType());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error("Invalid event " + (Object)((Object)type) + " on Task " + this.taskId + " in state:" + (Object)((Object)this.getInternalState()));
        this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.taskId.getVertexID().getDAGId(), "Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new DAGEvent(this.taskId.getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
    }

    protected void internalErrorUncaughtException(TaskEventType type, Exception e) {
        this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.taskId.getVertexID().getDAGId(), "Uncaught exception when handling  event " + (Object)((Object)type) + " on Task " + this.taskId + ", error=" + e.getMessage()));
        this.eventHandler.handle((Event)new DAGEvent(this.taskId.getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
    }

    private void sendTaskAttemptCompletionEvent(TezTaskAttemptID attemptId, TaskAttemptStateInternal attemptState) {
        this.eventHandler.handle((Event)new VertexEventTaskAttemptCompleted(attemptId, attemptState));
    }

    private void handleTaskAttemptCompletion(TezTaskAttemptID attemptId, TaskAttemptStateInternal attemptState) {
        this.sendTaskAttemptCompletionEvent(attemptId, attemptState);
        this.sendDAGSchedulerFinishedEvent(attemptId);
    }

    private void sendDAGSchedulerFinishedEvent(TezTaskAttemptID taId) {
        this.eventHandler.handle((Event)new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_COMPLETED, this.attempts.get(taId)));
    }

    private static void unSucceed(TaskImpl task) {
        task.commitAttempt = null;
        task.successfulAttempt = null;
    }

    protected String getSplitsAsString() {
        return "";
    }

    protected void logJobHistoryTaskStartedEvent() {
        TaskStartedEvent startEvt = new TaskStartedEvent(this.taskId, this.getVertex().getName(), this.scheduledTime, this.getLaunchTime());
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), startEvt));
    }

    protected void logJobHistoryTaskFinishedEvent() {
        this.finishTime = this.clock.getTime();
        TaskFinishedEvent finishEvt = new TaskFinishedEvent(this.taskId, this.getVertex().getName(), this.getLaunchTime(), this.finishTime, this.successfulAttempt, TaskState.SUCCEEDED, "", this.getCounters(), this.failedAttempts);
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), finishEvt));
    }

    protected void logJobHistoryTaskFailedEvent(TaskState finalState) {
        this.finishTime = this.clock.getTime();
        TaskFinishedEvent finishEvt = new TaskFinishedEvent(this.taskId, this.getVertex().getName(), this.getLaunchTime(), this.finishTime, null, finalState, StringUtils.join(this.getDiagnostics(), (String)LINE_SEPARATOR), this.getCounters(), this.failedAttempts);
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), finishEvt));
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    @VisibleForTesting
    int getUncompletedAttemptsCount() {
        try {
            this.readLock.lock();
            int n = Maps.filterValues(this.taskAttemptStatus, (Predicate)new Predicate<Boolean>(){

                public boolean apply(Boolean state) {
                    return state == false;
                }
            }).size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    int getFinishedAttemptsCount() {
        try {
            this.readLock.lock();
            int n = Maps.filterValues(this.taskAttemptStatus, (Predicate)new Predicate<Boolean>(){

                public boolean apply(Boolean state) {
                    return state;
                }
            }).size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean shouldScheduleNewAttempt() {
        return this.getUncompletedAttemptsCount() == 0 && this.successfulAttempt == null;
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg, TaskAttemptTerminationCause errorCause) {
        if (this.commitAttempt != null && this.commitAttempt.equals((Object)attempt.getID())) {
            LOG.info("Unsetting commit attempt: " + this.commitAttempt + " since attempt is being killed");
            this.commitAttempt = null;
        }
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEventKillRequest(attempt.getID(), logMsg, errorCause));
        }
    }

    @Override
    public void registerTezEvent(TezEvent tezEvent) {
        this.writeLock.lock();
        try {
            this.tezEventsForTaskAttempts.add(tezEvent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getFirstAttemptStartTime() {
        this.readLock.lock();
        try {
            long l = this.getAttempt(TezTaskAttemptID.getInstance((TezTaskID)this.getTaskId(), (int)0)).getScheduleTime();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void setCounters(TezCounters counters) {
        try {
            this.writeLock.lock();
            this.counters = counters;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static class LaunchTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        LaunchTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
        }
    }

    private static class KillTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTermination terminateEvent = (TaskEventTermination)event;
            task.addDiagnosticInfo(terminateEvent.getDiagnosticInfo());
            for (TaskAttempt attempt : task.attempts.values()) {
                task.killUnfinishedAttempt(attempt, "Task KILL is received. Killing attempt. Diagnostics: " + terminateEvent.getDiagnosticInfo(), terminateEvent.getTerminationCause());
            }
        }
    }

    private static class TaskStateChangedCallback
    implements OnStateChangedCallback<TaskStateInternal, TaskImpl> {
        private TaskStateChangedCallback() {
        }

        @Override
        public void onStateChanged(TaskImpl task, TaskStateInternal taskStateInternal) {
            Preconditions.checkState((taskStateInternal == TaskStateInternal.SUCCEEDED ? 1 : 0) != 0);
            TaskAttempt successfulAttempt = task.getSuccessfulAttempt();
            int succesfulAttemptInt = -1;
            if (successfulAttempt != null) {
                succesfulAttemptInt = successfulAttempt.getID().getId();
            }
            task.stateChangeNotifier.taskSucceeded(task.getVertex().getName(), task.getTaskId(), succesfulAttemptInt);
        }
    }

    private static class AttemptRedundantCompletedTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptRedundantCompletedTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TezTaskAttemptID successTaId = ((TaskEventTAUpdate)event).getTaskAttemptID();
            task.taskAttemptStatus.put(successTaId.getId(), true);
        }
    }

    private static class KillNewTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillNewTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTermination terminateEvent = (TaskEventTermination)event;
            task.addDiagnosticInfo(terminateEvent.getDiagnosticInfo());
            if (terminateEvent.isFromRecovery()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recovered to KILLED, taskId=" + task.getTaskId());
                }
            } else {
                task.logJobHistoryTaskFailedEvent(TaskState.KILLED);
            }
            task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.KILLED));
        }
    }

    private static class TaskRetroactiveKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private TaskRetroactiveKilledTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate attemptEvent = (TaskEventTAUpdate)event;
            TezTaskAttemptID attemptId = attemptEvent.getTaskAttemptID();
            TaskStateInternal resultState = TaskStateInternal.SUCCEEDED;
            if (task.successfulAttempt.equals((Object)attemptId)) {
                TaskImpl.unSucceed(task);
                task.eventHandler.handle((Event)new VertexEventTaskReschedule(task.taskId));
                resultState = TaskStateInternal.SCHEDULED;
            }
            ATTEMPT_KILLED_TRANSITION.transition((Object)task, (Object)event);
            return resultState;
        }
    }

    private static class TaskRetroactiveFailureTransition
    extends AttemptFailedTransition {
        private TezTaskAttemptID schedulingCausalTA;

        private TaskRetroactiveFailureTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            AMContainer amContainer;
            TaskEventTAFailed castEvent = (TaskEventTAFailed)event;
            TezTaskAttemptID failedAttemptId = castEvent.getTaskAttemptID();
            TaskAttempt failedAttempt = task.getAttempt(failedAttemptId);
            ContainerId containerId = failedAttempt.getAssignedContainerID();
            if (containerId != null && (amContainer = task.appContext.getAllContainers().get(containerId)) != null) {
                task.eventHandler.handle((Event)new AMNodeEventTaskAttemptEnded(amContainer.getContainer().getNodeId(), task.getVertex().getTaskSchedulerIdentifier(), containerId, failedAttemptId, true));
            }
            if (task.getInternalState() == TaskStateInternal.SUCCEEDED && !failedAttemptId.equals((Object)task.successfulAttempt)) {
                task.taskAttemptStatus.put(failedAttemptId.getId(), true);
                return TaskStateInternal.SUCCEEDED;
            }
            if (task.leafVertex) {
                LOG.error("Unexpected event for task of leaf vertex " + event.getType() + ", taskId: " + task.getTaskId());
                task.internalError((TaskEventType)event.getType());
            }
            Preconditions.checkState((castEvent.getCausalEvent() != null ? 1 : 0) != 0);
            TaskAttemptEventOutputFailed destinationEvent = (TaskAttemptEventOutputFailed)castEvent.getCausalEvent();
            this.schedulingCausalTA = destinationEvent.getInputFailedEvent().getSourceInfo().getTaskAttemptID();
            TaskImpl.unSucceed(task);
            TaskStateInternal returnState = super.transition(task, event);
            if (returnState == TaskStateInternal.SCHEDULED) {
                task.eventHandler.handle((Event)new VertexEventTaskReschedule(task.taskId));
            }
            return returnState;
        }

        @Override
        protected TezTaskAttemptID getSchedulingCausalTA() {
            return this.schedulingCausalTA;
        }

        @Override
        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return TaskStateInternal.SCHEDULED;
        }
    }

    private static class AttemptFailedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private TezTaskAttemptID schedulingCausalTA;

        private AttemptFailedTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            ++task.failedAttempts;
            task.getVertex().incrementFailedTaskAttemptCount();
            TaskEventTAFailed castEvent = (TaskEventTAFailed)event;
            this.schedulingCausalTA = castEvent.getTaskAttemptID();
            task.addDiagnosticInfo("TaskAttempt " + castEvent.getTaskAttemptID().getId() + " failed, info=" + task.getAttempt(castEvent.getTaskAttemptID()).getDiagnostics());
            if (task.commitAttempt != null && castEvent.getTaskAttemptID().equals((Object)task.commitAttempt)) {
                task.commitAttempt = null;
            }
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            if (task.failedAttempts < task.maxFailedAttempts && castEvent.getTaskFailureType() == TaskFailureType.NON_FATAL) {
                task.handleTaskAttemptCompletion(((TaskEventTAUpdate)event).getTaskAttemptID(), TaskAttemptStateInternal.FAILED);
                if (task.shouldScheduleNewAttempt()) {
                    LOG.info("Scheduling new attempt for task: " + task.getTaskId() + ", currentFailedAttempts: " + task.failedAttempts + ", maxFailedAttempts: " + task.maxFailedAttempts);
                    task.addAndScheduleAttempt(this.getSchedulingCausalTA());
                }
            } else {
                if (castEvent.getTaskFailureType() == TaskFailureType.NON_FATAL) {
                    LOG.info("Failing task: {} due to too many failed attempts. currentFailedAttempts={}, maxFailedAttempts={}", new Object[]{task.getTaskId(), task.failedAttempts, task.maxFailedAttempts});
                } else {
                    LOG.info("Failing task: {} due to {} error reported by TaskAttempt. CurrentFailedAttempts={}", new Object[]{task.getTaskId(), TaskFailureType.FATAL, task.failedAttempts});
                }
                task.handleTaskAttemptCompletion(((TaskEventTAUpdate)event).getTaskAttemptID(), TaskAttemptStateInternal.FAILED);
                task.logJobHistoryTaskFailedEvent(TaskState.FAILED);
                task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.FAILED));
                return task.finished(TaskStateInternal.FAILED);
            }
            return this.getDefaultState(task);
        }

        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return task.getInternalState();
        }

        protected TezTaskAttemptID getSchedulingCausalTA() {
            return this.schedulingCausalTA;
        }
    }

    private static class KillWaitAttemptCompletedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private KillWaitAttemptCompletedTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate castEvent = (TaskEventTAUpdate)event;
            task.handleTaskAttemptCompletion(castEvent.getTaskAttemptID(), TaskAttemptStateInternal.KILLED);
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            if (task.getFinishedAttemptsCount() == task.attempts.size()) {
                task.logJobHistoryTaskFailedEvent(TaskImpl.getExternalState(TaskStateInternal.KILLED));
                task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskImpl.getExternalState(TaskStateInternal.KILLED)));
                return TaskStateInternal.KILLED;
            }
            return task.getInternalState();
        }
    }

    private static class AttemptKilledTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptKilledTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate castEvent = (TaskEventTAUpdate)event;
            task.addDiagnosticInfo("TaskAttempt " + castEvent.getTaskAttemptID().getId() + " killed");
            if (task.commitAttempt != null && castEvent.getTaskAttemptID().equals((Object)task.commitAttempt)) {
                task.commitAttempt = null;
            }
            task.handleTaskAttemptCompletion(castEvent.getTaskAttemptID(), TaskAttemptStateInternal.KILLED);
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            task.getVertex().incrementKilledTaskAttemptCount();
            if (task.shouldScheduleNewAttempt()) {
                task.addAndScheduleAttempt(castEvent.getTaskAttemptID());
            }
        }
    }

    private static class AttemptSucceededTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private AttemptSucceededTransition() {
        }

        private String recoverSuccessTaskAttempt(TaskImpl task) {
            String errorMsg = null;
            if (task.getVertex().getOutputCommitters() != null && !task.getVertex().getOutputCommitters().isEmpty()) {
                for (Map.Entry<String, OutputCommitter> entry : task.getVertex().getOutputCommitters().entrySet()) {
                    LOG.info("Recovering data for task from previous DAG attempt, taskId=" + task.getTaskId() + ", output=" + entry.getKey());
                    OutputCommitter committer = entry.getValue();
                    if (!committer.isTaskRecoverySupported()) {
                        errorMsg = "Task recovery not supported by committer, failing task attempt";
                        LOG.info(errorMsg + ", taskId=" + task.getTaskId() + ", attemptId=" + task.successfulAttempt + ", output=" + entry.getKey());
                        break;
                    }
                    try {
                        committer.recoverTask(task.getTaskId().getId(), task.appContext.getApplicationAttemptId().getAttemptId() - 1);
                    }
                    catch (Exception e) {
                        errorMsg = "Task recovery failed by committer: " + ExceptionUtils.getStackTrace((Throwable)e);
                        LOG.warn("Task recovery failed by committer, taskId=" + task.getTaskId() + ", attemptId=" + task.successfulAttempt + ", output=" + entry.getKey(), (Throwable)e);
                        break;
                    }
                }
            }
            return errorMsg;
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TezTaskAttemptID successTaId = ((TaskEventTAUpdate)event).getTaskAttemptID();
            if (task.recoveryData != null && task.recoveryData.isTaskAttemptSucceeded(successTaId)) {
                String errorMsg = this.recoverSuccessTaskAttempt(task);
                if (errorMsg != null) {
                    LOG.info("Can not recover the successful task attempt, schedule new task attempt,taskId=" + task.getTaskId());
                    task.successfulAttempt = null;
                    task.addAndScheduleAttempt(successTaId);
                    task.eventHandler.handle((Event)new TaskAttemptEventAttemptKilled(successTaId, errorMsg, TaskAttemptTerminationCause.TERMINATED_AT_RECOVERY, true));
                    return TaskStateInternal.RUNNING;
                }
                task.successfulAttempt = successTaId;
                LOG.info("Recovered a successful attempt, taskAttemptId=" + task.successfulAttempt.toString());
            }
            if (task.commitAttempt != null && !task.commitAttempt.equals((Object)successTaId)) {
                throw new TezUncheckedException("TA: " + successTaId + " succeeded but TA: " + task.commitAttempt + " was expected to commit and succeed");
            }
            task.handleTaskAttemptCompletion(successTaId, TaskAttemptStateInternal.SUCCEEDED);
            task.taskAttemptStatus.put(successTaId.getId(), true);
            task.successfulAttempt = successTaId;
            task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.SUCCEEDED));
            LOG.info("Task succeeded with attempt " + task.successfulAttempt);
            task.logJobHistoryTaskFinishedEvent();
            TaskAttempt successfulAttempt = (TaskAttempt)task.attempts.get(successTaId);
            for (TaskAttempt attempt : task.attempts.values()) {
                if (attempt.getID().equals((Object)task.successfulAttempt) || attempt.isFinished()) continue;
                LOG.info("Issuing kill to other attempt " + attempt.getID() + " as attempt: " + task.successfulAttempt + " has succeeded");
                String diagnostics = null;
                TaskAttemptTerminationCause errCause = null;
                if (attempt.getLaunchTime() < successfulAttempt.getLaunchTime()) {
                    diagnostics = "Killed this attempt as other speculative attempt : " + successTaId + " succeeded";
                    errCause = TaskAttemptTerminationCause.TERMINATED_EFFECTIVE_SPECULATION;
                } else {
                    diagnostics = "Killed this speculative attempt as original attempt: " + successTaId + " succeeded";
                    errCause = TaskAttemptTerminationCause.TERMINATED_INEFFECTIVE_SPECULATION;
                }
                task.eventHandler.handle((Event)new TaskAttemptEventKillRequest(attempt.getID(), diagnostics, errCause));
            }
            return task.finished(TaskStateInternal.SUCCEEDED);
        }
    }

    private static class RedundantScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private RedundantScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            LOG.info("Scheduling a redundant attempt for task " + task.taskId);
            task.counters.findCounter((Enum)TaskCounter.NUM_SPECULATIONS).increment(1L);
            TezTaskAttemptID earliestUnfinishedAttempt = null;
            for (TaskAttempt ta : task.attempts.values()) {
                if (ta.isFinished()) continue;
                earliestUnfinishedAttempt = ta.getID();
            }
            task.addAndScheduleAttempt(earliestUnfinishedAttempt);
        }
    }

    private static class InitialScheduleTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private InitialScheduleTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            if (task.recoveryData != null) {
                TaskStartedEvent tStartedEvent = task.recoveryData.getTaskStartedEvent();
                TaskFinishedEvent tFinishedEvent = task.recoveryData.getTaskFinishedEvent();
                if (tStartedEvent == null && tFinishedEvent != null) {
                    Preconditions.checkArgument((tFinishedEvent.getState() == TaskState.KILLED ? 1 : 0) != 0, (Object)("TaskStartedEvent is not seen, but TaskFinishedEvent is seen and with invalid state=" + (Object)((Object)tFinishedEvent.getState()) + ", taskId=" + task.getTaskId()));
                    task.eventHandler.handle((Event)new TaskEventTermination(task.taskId, TaskAttemptTerminationCause.UNKNOWN_ERROR, tFinishedEvent.getDiagnostics(), true));
                    return TaskStateInternal.NEW;
                }
            } else {
                task.scheduledTime = task.clock.getTime();
                task.logJobHistoryTaskStartedEvent();
                task.vertex.reportTaskStartTime(task.getLaunchTime());
            }
            TaskEventScheduleTask scheduleEvent = (TaskEventScheduleTask)event;
            task.locationHint = scheduleEvent.getTaskLocationHint();
            task.baseTaskSpec = scheduleEvent.getBaseTaskSpec();
            task.addAndScheduleAttempt(null);
            return TaskStateInternal.SCHEDULED;
        }
    }
}

