/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.tez.state.OnStateChangedCallback;

public class StateMachineTez<STATE extends Enum<STATE>, EVENTTYPE extends Enum<EVENTTYPE>, EVENT, OPERAND>
implements StateMachine<STATE, EVENTTYPE, EVENT> {
    private final Map<STATE, OnStateChangedCallback> callbackMap = new HashMap<STATE, OnStateChangedCallback>();
    private final OPERAND operand;
    private final StateMachine<STATE, EVENTTYPE, EVENT> realStatemachine;

    public StateMachineTez(StateMachine sm, OPERAND operand) {
        this.realStatemachine = sm;
        this.operand = operand;
    }

    public StateMachineTez registerStateEnteredCallback(STATE state, OnStateChangedCallback callback) {
        this.callbackMap.put(state, callback);
        return this;
    }

    public STATE getCurrentState() {
        return (STATE)this.realStatemachine.getCurrentState();
    }

    public void setCurrentState(STATE currentState) {
        this.realStatemachine.setCurrentState(currentState);
    }

    public STATE doTransition(EVENTTYPE eventType, EVENT event) throws InvalidStateTransitonException {
        OnStateChangedCallback callback;
        Enum oldState = this.realStatemachine.getCurrentState();
        Enum newState = this.realStatemachine.doTransition(eventType, event);
        if (newState != oldState && (callback = this.callbackMap.get(newState)) != null) {
            callback.onStateChanged(this.operand, newState);
        }
        return (STATE)newState;
    }
}

