/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.InputInitializerContext;

public class TezTestUtils {
    public static TezTaskAttemptID getMockTaskAttemptId(int jobId, int vertexId, int taskId, int taskAttemptId) {
        return TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)jobId), (int)jobId), (int)vertexId), (int)taskId), (int)taskAttemptId);
    }

    public static TezTaskID getMockTaskId(int jobId, int vertexId, int taskId) {
        return TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)jobId), (int)jobId), (int)vertexId), (int)taskId);
    }

    public static class TezRootInputInitializerContextForTest
    implements InputInitializerContext {
        private final ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)200);
        private final UserPayload payload;

        public TezRootInputInitializerContextForTest(UserPayload payload) throws IOException {
            this.payload = payload == null ? UserPayload.create(null) : payload;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }

        public String getDAGName() {
            return "FakeDAG";
        }

        public String getInputName() {
            return "MRInput";
        }

        public UserPayload getInputUserPayload() {
            return this.payload;
        }

        public int getNumTasks() {
            return 100;
        }

        public Resource getVertexTaskResource() {
            return Resource.newInstance((int)1024, (int)1);
        }

        public Resource getTotalAvailableResource() {
            return Resource.newInstance((int)10240, (int)10);
        }

        public int getNumClusterNodes() {
            return 10;
        }

        public int getDAGAttemptNumber() {
            return 1;
        }

        public int getVertexNumTasks(String vertexName) {
            throw new UnsupportedOperationException("getVertexNumTasks not implemented in this mock");
        }

        public void registerForVertexStateUpdates(String vertexName, Set<VertexState> stateSet) {
            throw new UnsupportedOperationException("getVertexNumTasks not implemented in this mock");
        }

        public void addCounters(TezCounters tezCounters) {
            throw new UnsupportedOperationException("addCounters not implemented in this mock");
        }

        public UserPayload getUserPayload() {
            throw new UnsupportedOperationException("getUserPayload not implemented in this mock");
        }
    }
}

