/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.TezTestUtils;
import org.apache.tez.mapreduce.common.MRInputAMSplitGenerator;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.lib.MRInputUtils;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestMRInputAMSplitGenerator {
    private static String SPLITS_LENGTHS = "splits.length";

    @Test(timeout=5000L)
    public void testGroupSplitsDisabledSortSplitsEnabled() throws Exception {
        this.testGroupSplitsAndSortSplits(false, true);
    }

    @Test(timeout=5000L)
    public void testGroupSplitsDisabledSortSplitsDisabled() throws Exception {
        this.testGroupSplitsAndSortSplits(false, false);
    }

    @Test(timeout=5000L)
    public void testGroupSplitsEnabledSortSplitsEnabled() throws Exception {
        this.testGroupSplitsAndSortSplits(true, true);
    }

    @Test(timeout=5000L)
    public void testGroupSplitsEnabledSortSplitsDisabled() throws Exception {
        this.testGroupSplitsAndSortSplits(true, false);
    }

    private void testGroupSplitsAndSortSplits(boolean groupSplitsEnabled, boolean sortSplitsEnabled) throws Exception {
        Configuration conf = new Configuration();
        String[] splitLengths = new String[50];
        for (int i = 0; i < splitLengths.length; ++i) {
            splitLengths[i] = Integer.toString(1000 * (i + 1));
        }
        conf.setStrings(SPLITS_LENGTHS, splitLengths);
        DataSourceDescriptor dataSource = MRInput.createConfigBuilder((Configuration)conf, InputFormatForTest.class).groupSplits(groupSplitsEnabled).sortSplits(sortSplitsEnabled).build();
        UserPayload userPayload = dataSource.getInputDescriptor().getUserPayload();
        TezTestUtils.TezRootInputInitializerContextForTest context = new TezTestUtils.TezRootInputInitializerContextForTest(userPayload);
        MRInputAMSplitGenerator splitGenerator = new MRInputAMSplitGenerator((InputInitializerContext)context);
        List events = splitGenerator.initialize();
        Assert.assertTrue((boolean)(events.get(0) instanceof InputConfigureVertexTasksEvent));
        boolean shuffled = false;
        InputSplit previousIs = null;
        int numRawInputSplits = 0;
        for (int i = 1; i < events.size(); ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof InputDataInformationEvent));
            InputDataInformationEvent diEvent = (InputDataInformationEvent)events.get(i);
            Assert.assertNull((Object)diEvent.getDeserializedUserPayload());
            Assert.assertNotNull((Object)diEvent.getUserPayload());
            MRRuntimeProtos.MRSplitProto eventProto = MRRuntimeProtos.MRSplitProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)diEvent.getUserPayload()));
            InputSplit is = MRInputUtils.getNewSplitDetailsFromEvent((MRRuntimeProtos.MRSplitProto)eventProto, (Configuration)new Configuration());
            if (groupSplitsEnabled) {
                numRawInputSplits += ((TezGroupedSplit)is).getGroupedSplits().size();
                for (InputSplit inputSplit : ((TezGroupedSplit)is).getGroupedSplits()) {
                    Assert.assertTrue((boolean)(inputSplit instanceof InputSplitForTest));
                }
                Assert.assertTrue((boolean)(((TezGroupedSplit)is).getGroupedSplits().get(0) instanceof InputSplitForTest));
            } else {
                ++numRawInputSplits;
                Assert.assertTrue((boolean)(is instanceof InputSplitForTest));
            }
            if (previousIs != null) {
                if (sortSplitsEnabled) {
                    Assert.assertTrue((is.getLength() <= previousIs.getLength() ? 1 : 0) != 0);
                } else {
                    shuffled |= is.getLength() > previousIs.getLength();
                }
            }
            previousIs = is;
        }
        Assert.assertEquals((long)splitLengths.length, (long)numRawInputSplits);
        if (!sortSplitsEnabled) {
            Assert.assertTrue((boolean)shuffled);
        }
    }

    @InterfaceAudience.Private
    public static class InputSplitForTest
    extends InputSplit
    implements Writable {
        private int identifier;
        private int length;

        public InputSplitForTest() {
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public InputSplitForTest(int identifier, int length) {
            this.identifier = identifier;
            this.length = length;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.identifier);
            out.writeInt(this.length);
        }

        public void readFields(DataInput in) throws IOException {
            this.identifier = in.readInt();
            this.length = in.readInt();
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public String[] getLocations() throws IOException {
            return new String[]{"localhost"};
        }
    }

    private static class InputFormatForTest
    extends InputFormat<IntWritable, IntWritable> {
        private InputFormatForTest() {
        }

        public RecordReader<IntWritable, IntWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new RecordReader<IntWritable, IntWritable>(){
                private boolean done = false;

                public void close() throws IOException {
                }

                public IntWritable getCurrentKey() throws IOException, InterruptedException {
                    return new IntWritable(0);
                }

                public IntWritable getCurrentValue() throws IOException, InterruptedException {
                    return new IntWritable(0);
                }

                public float getProgress() throws IOException, InterruptedException {
                    return this.done ? 0.0f : 1.0f;
                }

                public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    if (!this.done) {
                        this.done = true;
                        return true;
                    }
                    return false;
                }
            };
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            ArrayList<InputSplit> list = new ArrayList<InputSplit>();
            int[] lengths = context.getConfiguration().getInts(SPLITS_LENGTHS);
            for (int i = 0; i < lengths.length; ++i) {
                list.add(new InputSplitForTest(i + 1, lengths[i]));
            }
            return list;
        }
    }
}

