/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.TezTestUtils;
import org.apache.tez.mapreduce.common.MRInputSplitDistributor;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.lib.MRInputUtils;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputUpdatePayloadEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestMRInputSplitDistributor {
    @Test(timeout=5000L)
    public void testSerializedPayload() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        ByteString confByteString = TezUtils.createByteStringFromConf((Configuration)conf);
        InputSplitForTest split1 = new InputSplitForTest(1);
        InputSplitForTest split2 = new InputSplitForTest(2);
        MRRuntimeProtos.MRSplitProto proto1 = MRInputHelpers.createSplitProto((InputSplit)split1);
        MRRuntimeProtos.MRSplitProto proto2 = MRInputHelpers.createSplitProto((InputSplit)split2);
        MRRuntimeProtos.MRSplitsProto.Builder splitsProtoBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        splitsProtoBuilder.addSplits(proto1);
        splitsProtoBuilder.addSplits(proto2);
        MRRuntimeProtos.MRInputUserPayloadProto.Builder payloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        payloadProto.setSplits(splitsProtoBuilder.build());
        payloadProto.setConfigurationBytes(confByteString);
        UserPayload userPayload = UserPayload.create((ByteBuffer)payloadProto.build().toByteString().asReadOnlyByteBuffer());
        TezTestUtils.TezRootInputInitializerContextForTest context = new TezTestUtils.TezRootInputInitializerContextForTest(userPayload);
        MRInputSplitDistributor splitDist = new MRInputSplitDistributor((InputInitializerContext)context);
        List events = splitDist.initialize();
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof InputUpdatePayloadEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof InputDataInformationEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof InputDataInformationEvent));
        InputDataInformationEvent diEvent1 = (InputDataInformationEvent)events.get(1);
        InputDataInformationEvent diEvent2 = (InputDataInformationEvent)events.get(2);
        Assert.assertNull((Object)diEvent1.getDeserializedUserPayload());
        Assert.assertNull((Object)diEvent2.getDeserializedUserPayload());
        Assert.assertNotNull((Object)diEvent1.getUserPayload());
        Assert.assertNotNull((Object)diEvent2.getUserPayload());
        MRRuntimeProtos.MRSplitProto event1Proto = MRRuntimeProtos.MRSplitProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)diEvent1.getUserPayload()));
        InputSplit is1 = MRInputUtils.getOldSplitDetailsFromEvent((MRRuntimeProtos.MRSplitProto)event1Proto, (Configuration)new Configuration());
        Assert.assertTrue((boolean)(is1 instanceof InputSplitForTest));
        Assert.assertEquals((long)1L, (long)((InputSplitForTest)is1).identifier);
        MRRuntimeProtos.MRSplitProto event2Proto = MRRuntimeProtos.MRSplitProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)diEvent2.getUserPayload()));
        InputSplit is2 = MRInputUtils.getOldSplitDetailsFromEvent((MRRuntimeProtos.MRSplitProto)event2Proto, (Configuration)new Configuration());
        Assert.assertTrue((boolean)(is2 instanceof InputSplitForTest));
        Assert.assertEquals((long)2L, (long)((InputSplitForTest)is2).identifier);
    }

    @Test(timeout=5000L)
    public void testDeserializedPayload() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", false);
        ByteString confByteString = TezUtils.createByteStringFromConf((Configuration)conf);
        InputSplitForTest split1 = new InputSplitForTest(1);
        InputSplitForTest split2 = new InputSplitForTest(2);
        MRRuntimeProtos.MRSplitProto proto1 = MRInputHelpers.createSplitProto((InputSplit)split1);
        MRRuntimeProtos.MRSplitProto proto2 = MRInputHelpers.createSplitProto((InputSplit)split2);
        MRRuntimeProtos.MRSplitsProto.Builder splitsProtoBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        splitsProtoBuilder.addSplits(proto1);
        splitsProtoBuilder.addSplits(proto2);
        MRRuntimeProtos.MRInputUserPayloadProto.Builder payloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        payloadProto.setSplits(splitsProtoBuilder.build());
        payloadProto.setConfigurationBytes(confByteString);
        UserPayload userPayload = UserPayload.create((ByteBuffer)payloadProto.build().toByteString().asReadOnlyByteBuffer());
        TezTestUtils.TezRootInputInitializerContextForTest context = new TezTestUtils.TezRootInputInitializerContextForTest(userPayload);
        MRInputSplitDistributor splitDist = new MRInputSplitDistributor((InputInitializerContext)context);
        List events = splitDist.initialize();
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof InputUpdatePayloadEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof InputDataInformationEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof InputDataInformationEvent));
        InputDataInformationEvent diEvent1 = (InputDataInformationEvent)events.get(1);
        InputDataInformationEvent diEvent2 = (InputDataInformationEvent)events.get(2);
        Assert.assertNull((Object)diEvent1.getUserPayload());
        Assert.assertNull((Object)diEvent2.getUserPayload());
        Assert.assertNotNull((Object)diEvent1.getDeserializedUserPayload());
        Assert.assertNotNull((Object)diEvent2.getDeserializedUserPayload());
        Assert.assertTrue((boolean)(diEvent1.getDeserializedUserPayload() instanceof InputSplitForTest));
        Assert.assertEquals((long)1L, (long)((InputSplitForTest)diEvent1.getDeserializedUserPayload()).identifier);
        Assert.assertTrue((boolean)(diEvent2.getDeserializedUserPayload() instanceof InputSplitForTest));
        Assert.assertEquals((long)2L, (long)((InputSplitForTest)diEvent2.getDeserializedUserPayload()).identifier);
    }

    @InterfaceAudience.Private
    private static class InputSplitForTest
    implements InputSplit {
        private int identifier;

        public InputSplitForTest() {
        }

        public InputSplitForTest(int identifier) {
            this.identifier = identifier;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.identifier);
        }

        public void readFields(DataInput in) throws IOException {
            this.identifier = in.readInt();
        }

        public long getLength() throws IOException {
            return 1000L;
        }

        public String[] getLocations() throws IOException {
            return null;
        }
    }
}

