/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMultiMRInput {
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiMRInput.class);
    private static final JobConf defaultConf = new JobConf();
    private static final String testTmpDir;
    private static final Path TEST_ROOT_DIR;
    private static FileSystem localFs;

    @Before
    public void setup() throws IOException {
        LOG.info("Setup. Using test dir: " + TEST_ROOT_DIR);
        localFs.delete(TEST_ROOT_DIR, true);
        localFs.mkdirs(TEST_ROOT_DIR);
    }

    @Test(timeout=5000L)
    public void test0PhysicalInputs() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testSingleSplit");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(org.apache.hadoop.mapred.SequenceFileInputFormat.class);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        InputContext inputContext = this.createTezInputContext((Configuration)jobConf);
        MultiMRInput mMrInput = new MultiMRInput(inputContext, 0);
        mMrInput.initialize();
        mMrInput.start();
        Assert.assertEquals((long)0L, (long)mMrInput.getKeyValueReaders().size());
        LinkedList events = new LinkedList();
        try {
            mMrInput.handleEvents(events);
            Assert.fail((String)"HandleEvents should cause an input with 0 physical inputs to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test(timeout=5000L)
    public void testSingleSplit() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testSingleSplit");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(org.apache.hadoop.mapred.SequenceFileInputFormat.class);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        InputContext inputContext = this.createTezInputContext((Configuration)jobConf);
        MultiMRInput input = new MultiMRInput(inputContext, 1);
        input.initialize();
        AtomicLong inputLength = new AtomicLong();
        LinkedHashMap<LongWritable, Text> data = this.createSplits(1, workDir, (Configuration)jobConf, inputLength);
        org.apache.hadoop.mapred.SequenceFileInputFormat format = new org.apache.hadoop.mapred.SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        eventList.add(event);
        input.handleEvents(eventList);
        this.assertReaders(input, data, 1, inputLength.get());
    }

    @Test
    public void testNewFormatSplits() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testNewFormatSplits");
        Job job = Job.getInstance((Configuration)defaultConf);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        Configuration conf = job.getConfiguration();
        conf.setBoolean("mapred.mapper.new-api", true);
        AtomicLong inputLength = new AtomicLong();
        LinkedHashMap<LongWritable, Text> data = this.createSplits(1, workDir, conf, inputLength);
        SequenceFileInputFormat format = new SequenceFileInputFormat();
        List splits = format.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
        MRRuntimeProtos.MRSplitProto splitProto = MRInputHelpers.createSplitProto((org.apache.hadoop.mapreduce.InputSplit)((org.apache.hadoop.mapreduce.InputSplit)splits.get(0)), (SerializationFactory)new SerializationFactory(conf));
        InputDataInformationEvent event = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        InputContext inputContext = this.createTezInputContext(conf);
        MultiMRInput input = new MultiMRInput(inputContext, 1);
        input.initialize();
        input.handleEvents(Collections.singletonList(event));
        this.assertReaders(input, data, 1, inputLength.get());
    }

    @Test(timeout=5000L)
    public void testMultipleSplits() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testMultipleSplits");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(org.apache.hadoop.mapred.SequenceFileInputFormat.class);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        InputContext inputContext = this.createTezInputContext((Configuration)jobConf);
        MultiMRInput input = new MultiMRInput(inputContext, 2);
        input.initialize();
        AtomicLong inputLength = new AtomicLong();
        LinkedHashMap<LongWritable, Text> data = this.createSplits(2, workDir, (Configuration)jobConf, inputLength);
        org.apache.hadoop.mapred.SequenceFileInputFormat format = new org.apache.hadoop.mapred.SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 2);
        Assert.assertEquals((long)2L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto1 = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event1 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto1.toByteString().asReadOnlyByteBuffer());
        MRRuntimeProtos.MRSplitProto splitProto2 = MRInputHelpers.createSplitProto((InputSplit)splits[1]);
        InputDataInformationEvent event2 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto2.toByteString().asReadOnlyByteBuffer());
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        eventList.add(event1);
        eventList.add(event2);
        input.handleEvents(eventList);
        this.assertReaders(input, data, 2, inputLength.get());
    }

    private void assertReaders(MultiMRInput input, LinkedHashMap<LongWritable, Text> data, int expectedReaderCounts, long inputBytes) throws Exception {
        int readerCount = 0;
        int recordCount = 0;
        for (KeyValueReader reader : input.getKeyValueReaders()) {
            ++readerCount;
            while (reader.next()) {
                ((InputContext)Mockito.verify((Object)input.getContext(), (VerificationMode)Mockito.times((int)(++recordCount + readerCount - 1)))).notifyProgress();
                if (data.size() == 0) {
                    Assert.fail((String)"Found more records than expected");
                }
                Object key = reader.getCurrentKey();
                Object val = reader.getCurrentValue();
                Assert.assertEquals((Object)val, data.remove(key));
            }
            try {
                reader.next();
                Assert.fail();
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("For usage, please refer to"));
            }
        }
        long counterValue = input.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_SPLIT_LENGTH_BYTES).getValue();
        Assert.assertEquals((long)inputBytes, (long)counterValue);
        Assert.assertEquals((long)expectedReaderCounts, (long)readerCount);
    }

    @Test(timeout=5000L)
    public void testExtraEvents() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testExtraEvents");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(org.apache.hadoop.mapred.SequenceFileInputFormat.class);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        InputContext inputContext = this.createTezInputContext((Configuration)jobConf);
        MultiMRInput input = new MultiMRInput(inputContext, 1);
        input.initialize();
        this.createSplits(1, workDir, (Configuration)jobConf, new AtomicLong());
        org.apache.hadoop.mapred.SequenceFileInputFormat format = new org.apache.hadoop.mapred.SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event1 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        InputDataInformationEvent event2 = InputDataInformationEvent.createWithSerializedPayload((int)1, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        eventList.add(event1);
        eventList.add(event2);
        try {
            input.handleEvents(eventList);
            Assert.fail((String)"Expecting Exception due to too many events");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected event. All physical sources already initialized"));
        }
    }

    private LinkedHashMap<LongWritable, Text> createSplits(int splitCount, Path workDir, Configuration conf, AtomicLong totalSize) throws Exception {
        LinkedHashMap<LongWritable, Text> data = new LinkedHashMap<LongWritable, Text>();
        for (int i = 0; i < splitCount; ++i) {
            int start = i * 10;
            int end = start + 10;
            data.putAll(TestMultiMRInput.createInputData(localFs, workDir, conf, "file" + i, start, end, totalSize));
        }
        return data;
    }

    private InputContext createTezInputContext(Configuration conf) throws Exception {
        MRRuntimeProtos.MRInputUserPayloadProto.Builder builder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        builder.setGroupingEnabled(false);
        builder.setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)conf));
        byte[] payload = builder.build().toByteArray();
        ApplicationId applicationId = ApplicationId.newInstance((long)10000L, (int)1);
        TezCounters counters = new TezCounters();
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)applicationId).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)counters).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getDAGAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)"dagName").when((Object)inputContext)).getDAGName();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getInputIndex();
        ((InputContext)Mockito.doReturn((Object)"srcVertexName").when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskIndex();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskVertexIndex();
        ((InputContext)Mockito.doReturn((Object)UUID.randomUUID().toString()).when((Object)inputContext)).getUniqueIdentifier();
        ((InputContext)Mockito.doReturn((Object)"taskVertexName").when((Object)inputContext)).getTaskVertexName();
        ((InputContext)Mockito.doReturn((Object)UserPayload.create((ByteBuffer)ByteBuffer.wrap(payload))).when((Object)inputContext)).getUserPayload();
        return inputContext;
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        localFs.delete(TEST_ROOT_DIR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<LongWritable, Text> createInputData(FileSystem fs, Path workDir, Configuration job, String filename, long startKey, long numKeys, AtomicLong fileLength) throws IOException {
        LinkedHashMap<LongWritable, Text> data = new LinkedHashMap<LongWritable, Text>();
        Path file = new Path(workDir, filename);
        LOG.info("Generating data at path: " + file);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)file, LongWritable.class, Text.class);){
            Random r = new Random(System.currentTimeMillis());
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (long i = startKey; i < numKeys; ++i) {
                key.set(i);
                value.set(Integer.toString(r.nextInt(10000)));
                data.put(new LongWritable(key.get()), new Text(value.toString()));
                writer.append((Writable)key, (Writable)value);
                LOG.info("<k, v> : <" + key.get() + ", " + value + ">");
            }
            fileLength.addAndGet(writer.getLength());
        }
        return data;
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            testTmpDir = System.getProperty("test.build.data", "target");
            TEST_ROOT_DIR = new Path(testTmpDir, TestMultiMRInput.class.getSimpleName() + "-tmpDir");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

