/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.db.DBOutputFormat;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.mapreduce.output.MROutput;
import org.junit.Assert;
import org.junit.Test;

public class TestMROutputConfigBuilder {
    @Test(timeout=5000L)
    public void testNewAPI() {
        Configuration conf = new Configuration();
        try {
            MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"OutputPaths must be specified for OutputFormats based on org.apache.hadoop.mapreduce.lib.output.FileOutputFormat or org.apache.hadoop.mapred.FileOutputFormat", (Object)e.getMessage());
        }
        MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, (String)"/tmp/output").build();
        MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.db.DBOutputFormat.class).build();
    }

    @Test(timeout=5000L)
    public void testNewAPI_ThroughConf() {
        Configuration conf = new Configuration();
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"no outputFormat setting on Configuration, useNewAPI:true", (Object)e.getMessage());
        }
        conf.set("mapreduce.job.outputformat.class", TextOutputFormat.class.getName());
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"outputFormat must be assignable from org.apache.hadoop.mapreduce.OutputFormat", (Object)e.getMessage());
        }
        conf.set("mapreduce.job.outputformat.class", org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class.getName());
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"OutputPaths must be specified for OutputFormats based on org.apache.hadoop.mapreduce.lib.output.FileOutputFormat or org.apache.hadoop.mapred.FileOutputFormat", (Object)e.getMessage());
        }
        conf.set("mapreduce.output.fileoutputformat.outputdir", "/tmp/output");
        MROutput.createConfigBuilder((Configuration)conf, null).build();
    }

    @Test(timeout=5000L)
    public void testOldAPI() {
        Configuration conf = new Configuration();
        try {
            MROutput.createConfigBuilder((Configuration)conf, TextOutputFormat.class).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"OutputPaths must be specified for OutputFormats based on org.apache.hadoop.mapreduce.lib.output.FileOutputFormat or org.apache.hadoop.mapred.FileOutputFormat", (Object)e.getMessage());
        }
        MROutput.createConfigBuilder((Configuration)conf, TextOutputFormat.class, (String)"/tmp/output").build();
        MROutput.createConfigBuilder((Configuration)conf, DBOutputFormat.class).build();
    }

    @Test(timeout=5000L)
    public void testOldAPI_ThroughConf() {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.reducer.new-api", false);
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"no outputFormat setting on Configuration, useNewAPI:false", (Object)e.getMessage());
        }
        conf.set("mapred.output.format.class", org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class.getName());
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"outputFormat must be assignable from org.apache.hadoop.mapred.OutputFormat", (Object)e.getMessage());
        }
        conf.set("mapred.output.format.class", TextOutputFormat.class.getName());
        try {
            MROutput.createConfigBuilder((Configuration)conf, null).build();
            Assert.fail();
        }
        catch (TezUncheckedException e) {
            Assert.assertEquals((Object)"OutputPaths must be specified for OutputFormats based on org.apache.hadoop.mapreduce.lib.output.FileOutputFormat or org.apache.hadoop.mapred.FileOutputFormat", (Object)e.getMessage());
        }
        conf.set("mapreduce.output.fileoutputformat.outputdir", "/tmp/output");
        MROutput.createConfigBuilder((Configuration)conf, null).build();
    }
}

