/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.output.MultiMROutput;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.OutputStatisticsReporter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMultiMROutput {
    @Test(timeout=5000L)
    public void testNewAPI_TextOutputFormat() throws Exception {
        this.validate(true, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, true, org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, false);
    }

    @Test(timeout=5000L)
    public void testOldAPI_TextOutputFormat() throws Exception {
        this.validate(false, TextOutputFormat.class, false, FileOutputCommitter.class, false);
    }

    @Test(timeout=5000L)
    public void testNewAPI_SequenceFileOutputFormat() throws Exception {
        this.validate(true, SequenceFileOutputFormat.class, false, org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, false);
    }

    @Test(timeout=5000L)
    public void testOldAPI_SequenceFileOutputFormat() throws Exception {
        this.validate(false, org.apache.hadoop.mapred.SequenceFileOutputFormat.class, false, FileOutputCommitter.class, false);
    }

    @Test(timeout=5000L)
    public void testNewAPI_LazySequenceFileOutputFormat() throws Exception {
        this.validate(true, SequenceFileOutputFormat.class, false, org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, true);
    }

    @Test(timeout=5000L)
    public void testOldAPI_LazySequenceFileOutputFormat() throws Exception {
        this.validate(false, org.apache.hadoop.mapred.SequenceFileOutputFormat.class, false, FileOutputCommitter.class, true);
    }

    @Test(timeout=5000L)
    public void testNewAPI_LazyTextOutputFormat() throws Exception {
        this.validate(true, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, false, org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, true);
    }

    @Test(timeout=5000L)
    public void testOldAPI_LazyTextOutputFormat() throws Exception {
        this.validate(false, TextOutputFormat.class, false, FileOutputCommitter.class, true);
    }

    @Test(timeout=5000L)
    public void testInvalidBasePath() throws Exception {
        MultiMROutput outputs = this.createMROutputs(SequenceFileOutputFormat.class, false, true);
        try {
            outputs.getWriter().write((Object)new Text(Integer.toString(0)), (Object)new Text("foo"), "/tmp");
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private OutputContext createMockOutputContext(UserPayload payload) {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Mockito.when((Object)outputContext.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)outputContext.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)outputContext.getTaskVertexIndex()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getTaskAttemptNumber()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)outputContext.getStatisticsReporter()).thenReturn(Mockito.mock(OutputStatisticsReporter.class));
        return outputContext;
    }

    private void validate(boolean expectedUseNewAPIValue, Class outputFormat, boolean isMapper, Class committerClass, boolean useLazyOutputFormat) throws InterruptedException, IOException {
        MultiMROutput output = this.createMROutputs(outputFormat, isMapper, useLazyOutputFormat);
        Assert.assertEquals((Object)isMapper, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)expectedUseNewAPIValue, (Object)output.useNewApi);
        if (expectedUseNewAPIValue) {
            if (useLazyOutputFormat) {
                Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat.class, output.newOutputFormat.getClass());
            } else {
                Assert.assertEquals((Object)outputFormat, output.newOutputFormat.getClass());
            }
            Assert.assertNotNull((Object)output.newApiTaskAttemptContext);
            Assert.assertNull((Object)output.oldOutputFormat);
            Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputValueClass());
            Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputKeyClass());
            Assert.assertNull((Object)output.oldApiTaskAttemptContext);
            Assert.assertNotNull((Object)output.newRecordWriters);
            Assert.assertNull((Object)output.oldRecordWriters);
        } else {
            if (!useLazyOutputFormat) {
                Assert.assertEquals((Object)outputFormat, output.oldOutputFormat.getClass());
            } else {
                Assert.assertEquals(LazyOutputFormat.class, output.oldOutputFormat.getClass());
            }
            Assert.assertNull((Object)output.newOutputFormat);
            Assert.assertNotNull((Object)output.oldApiTaskAttemptContext);
            Assert.assertNull((Object)output.newApiTaskAttemptContext);
            Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputValueClass());
            Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputKeyClass());
            Assert.assertNotNull((Object)output.oldRecordWriters);
            Assert.assertNull((Object)output.newRecordWriters);
        }
        Assert.assertEquals((Object)committerClass, output.committer.getClass());
        int numOfUniqueKeys = 3;
        for (int i = 0; i < numOfUniqueKeys; ++i) {
            output.getWriter().write((Object)new Text(Integer.toString(i)), (Object)new Text("foo"), Integer.toString(i));
        }
        output.close();
        if (expectedUseNewAPIValue) {
            Assert.assertEquals((long)numOfUniqueKeys, (long)output.newRecordWriters.size());
        } else {
            Assert.assertEquals((long)numOfUniqueKeys, (long)output.oldRecordWriters.size());
        }
    }

    private MultiMROutput createMROutputs(Class outputFormat, boolean isMapper, boolean useLazyOutputFormat) throws InterruptedException, IOException {
        String outputPath = "/tmp/output";
        JobConf conf = new JobConf();
        conf.setBoolean("tez.mapreduce.is_map_processor", isMapper);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        DataSinkDescriptor dataSink = MultiMROutput.createConfigBuilder((Configuration)conf, (Class)outputFormat, (String)outputPath, (boolean)useLazyOutputFormat).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload());
        MultiMROutput output = new MultiMROutput(outputContext, 2);
        output.initialize();
        return output;
    }
}

