/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor.reduce;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.mapreduce.TestUmbilical;
import org.apache.tez.mapreduce.TezTestUtils;
import org.apache.tez.mapreduce.hadoop.IDConverter;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.processor.MapUtils;
import org.apache.tez.mapreduce.processor.reduce.ReduceProcessor;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.apache.tez.runtime.library.input.OrderedGroupedInputLegacy;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReduceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestReduceProcessor.class);
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir = null;

    public void setUpJobConf(JobConf job) {
        job.set("tez.runtime.framework.local.dirs", workDir.toString());
        job.set("mapreduce.cluster.local.dir", workDir.toString());
        job.setClass("tez.runtime.task.local.output.manager", TezTaskOutputFiles.class, TezTaskOutput.class);
        job.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        job.setNumReduceTasks(1);
    }

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test(timeout=5000L)
    public void testReduceProcessor() throws Exception {
        String dagName = "mrdag0";
        String mapVertexName = MultiStageMRConfigUtil.getInitialMapVertexName();
        String reduceVertexName = MultiStageMRConfigUtil.getFinalReduceVertexName();
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        this.setUpJobConf(jobConf);
        MRHelpers.translateMRConfToTez((Configuration)jobConf);
        jobConf.setInt("mapreduce.job.application.attempt.id", 0);
        jobConf.set("tez.mr.framework.task-local-resource.dir", new Path(workDir, "localized-resources").toUri().toString());
        jobConf.setBoolean("mapreduce.tez.splits.via.events", false);
        Path mapInput = new Path(workDir, "map0");
        MapUtils.generateInputSplit(localFs, workDir, jobConf, mapInput, 10);
        InputSpec mapInputSpec = new InputSpec("NullSrcVertex", (InputDescriptor)InputDescriptor.create((String)MRInputLegacy.class.getName()).setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(MRRuntimeProtos.MRInputUserPayloadProto.newBuilder().setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)jobConf)).build().toByteArray()))), 1);
        OutputSpec mapOutputSpec = new OutputSpec("NullDestVertex", (OutputDescriptor)OutputDescriptor.create((String)OrderedPartitionedKVOutput.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)jobConf)), 1);
        TestUmbilical testUmbilical = new TestUmbilical();
        TezSharedExecutor sharedExecutor = new TezSharedExecutor((Configuration)jobConf);
        LogicalIOProcessorRuntimeTask mapTask = MapUtils.createLogicalTask(localFs, workDir, jobConf, 0, mapInput, testUmbilical, "mrdag0", mapVertexName, Collections.singletonList(mapInputSpec), Collections.singletonList(mapOutputSpec), sharedExecutor);
        mapTask.initialize();
        mapTask.run();
        mapTask.close();
        Assert.assertEquals((long)2L, (long)testUmbilical.getEvents().size());
        Assert.assertEquals((Object)EventType.VERTEX_MANAGER_EVENT, (Object)testUmbilical.getEvents().get(0).getEventType());
        Assert.assertEquals((Object)EventType.COMPOSITE_DATA_MOVEMENT_EVENT, (Object)testUmbilical.getEvents().get(1).getEventType());
        CompositeDataMovementEvent cdmEvent = (CompositeDataMovementEvent)testUmbilical.getEvents().get(1).getEvent();
        Assert.assertEquals((long)1L, (long)cdmEvent.getCount());
        DataMovementEvent dme = (DataMovementEvent)cdmEvent.getEvents().iterator().next();
        dme.setTargetIndex(0);
        LOG.info("Starting reduce...");
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text("mrdag0"));
        JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
        Token shuffleToken = new Token((TokenIdentifier)identifier, (SecretManager)jobTokenSecretManager);
        shuffleToken.setService(identifier.getJobId());
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        jobConf.set("tez.mr.framework.task-local-resource.dir", new Path(workDir, "localized-resources").toUri().toString());
        jobConf.setBoolean("tez.runtime.optimize.local.fetch", true);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(workDir, "output"));
        ProcessorDescriptor reduceProcessorDesc = (ProcessorDescriptor)ProcessorDescriptor.create((String)ReduceProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)jobConf));
        InputSpec reduceInputSpec = new InputSpec(mapVertexName, (InputDescriptor)InputDescriptor.create((String)OrderedGroupedInputLegacy.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)jobConf)), 1);
        OutputSpec reduceOutputSpec = new OutputSpec("NullDestinationVertex", (OutputDescriptor)OutputDescriptor.create((String)MROutputLegacy.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)jobConf)), 1);
        TaskSpec taskSpec = new TaskSpec(TezTestUtils.getMockTaskAttemptId(0, 1, 0, 0), "mrdag0", reduceVertexName, -1, reduceProcessorDesc, Collections.singletonList(reduceInputSpec), Collections.singletonList(reduceOutputSpec), null, null);
        HashMap<String, ByteBuffer> serviceConsumerMetadata = new HashMap<String, ByteBuffer>();
        String auxiliaryService = jobConf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        serviceConsumerMetadata.put(auxiliaryService, ShuffleUtils.convertJobTokenToBytes((Token)shuffleToken));
        HashMap serviceProviderEnvMap = new HashMap();
        ByteBuffer shufflePortBb = ByteBuffer.allocate(4).putInt(0, 8000);
        AuxiliaryServiceHelper.setServiceDataIntoEnv((String)auxiliaryService, (ByteBuffer)shufflePortBb, serviceProviderEnvMap);
        LogicalIOProcessorRuntimeTask task = new LogicalIOProcessorRuntimeTask(taskSpec, 0, (Configuration)jobConf, new String[]{workDir.toString()}, (TezUmbilical)new TestUmbilical(), serviceConsumerMetadata, serviceProviderEnvMap, (Multimap)HashMultimap.create(), null, "", (ExecutionContext)new ExecutionContextImpl("localhost"), Runtime.getRuntime().maxMemory(), true, (HadoopShim)new DefaultHadoopShim(), (TezExecutors)sharedExecutor);
        LinkedList<DataMovementEvent> destEvents = new LinkedList<DataMovementEvent>();
        destEvents.add(dme);
        task.initialize();
        OrderedGroupedInputLegacy sortedOut = (OrderedGroupedInputLegacy)task.getInputs().values().iterator().next();
        sortedOut.handleEvents(destEvents);
        task.run();
        task.close();
        sharedExecutor.shutdownNow();
        Path reduceOutputDir = new Path(new Path(workDir, "output"), "_temporary/0/" + IDConverter.toMRTaskIdForOutput((TezTaskID)TezTestUtils.getMockTaskId(0, 1, 0)));
        Path reduceOutputFile = new Path(reduceOutputDir, "part-v001-o000-00000");
        SequenceFile.Reader reader = new SequenceFile.Reader(localFs, reduceOutputFile, (Configuration)jobConf);
        LongWritable key = new LongWritable();
        Text value = new Text();
        long prev = Long.MIN_VALUE;
        while (reader.next((Writable)key, (Writable)value)) {
            if (prev == Long.MIN_VALUE) continue;
            Assert.assertTrue((prev < key.get() ? 1 : 0) != 0);
            prev = key.get();
        }
        reader.close();
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestReduceProcessor").makeQualified(localFs);
            LOG.info("Using workDir: " + workDir);
            MapUtils.configureLocalDirs((Configuration)defaultConf, workDir.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }
}

