/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.examples.RPCLoadGen;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.conf.UnorderedKVEdgeConfig;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastLoadGen
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(RPCLoadGen.class);

    private DAG createDAG(int numGenTasks, int totalSourceDataSize, int numFetcherTasks) {
        int bytesPerSource = totalSourceDataSize / numGenTasks;
        LOG.info("DataPerSourceTask(bytes)=" + bytesPerSource);
        ByteBuffer payload = ByteBuffer.allocate(4);
        payload.putInt(0, bytesPerSource);
        Vertex broadcastVertex = Vertex.create((String)"DataGen", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)InputGenProcessor.class.getName()).setUserPayload(UserPayload.create((ByteBuffer)payload))), (int)numGenTasks);
        Vertex fetchVertex = Vertex.create((String)"FetchVertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)InputFetchProcessor.class.getName()), (int)numFetcherTasks);
        UnorderedKVEdgeConfig edgeConf = UnorderedKVEdgeConfig.newBuilder((String)NullWritable.class.getName(), (String)IntWritable.class.getName()).setCompression(false, null, null).build();
        DAG dag = DAG.create((String)"BroadcastLoadGen");
        dag.addVertex(broadcastVertex).addVertex(fetchVertex).addEdge(Edge.create((Vertex)broadcastVertex, (Vertex)fetchVertex, (EdgeProperty)edgeConf.createDefaultBroadcastEdgeProperty()));
        return dag;
    }

    protected final int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws TezException, InterruptedException, IOException {
        LOG.info("Running: " + ((Object)((Object)this)).getClass().getSimpleName() + StringUtils.join((Object[])args, (String)" "));
        int numSourceTasks = Integer.parseInt(args[0]);
        int totalSourceData = Integer.parseInt(args[1]);
        int numFetcherTasks = Integer.parseInt(args[2]);
        LOG.info("Parameters: numSourceTasks=" + numSourceTasks + ", totalSourceDataSize(bytes)=" + totalSourceData + ", numFetcherTasks=" + numFetcherTasks);
        DAG dag = this.createDAG(numSourceTasks, totalSourceData, numFetcherTasks);
        return this.runDag(dag, false, LOG);
    }

    protected void printUsage() {
        System.err.println("Usage: BroadcastLoadGen <num_source_tasks>  <total_source_data> <num_destination_tasks>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected final int validateArgs(String[] otherArgs) {
        return otherArgs.length != 3 ? 2 : 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new BroadcastLoadGen(), (String[])args);
        System.exit(res);
    }

    public static class InputFetchProcessor
    extends SimpleProcessor {
        public InputFetchProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.inputs.size() == 1 ? 1 : 0) != 0);
            KeyValueReader broadcastKvReader = (KeyValueReader)((LogicalInput)this.getInputs().values().iterator().next()).getReader();
            long sum = 0L;
            int count = 0;
            while (broadcastKvReader.next()) {
                ++count;
                sum += (long)((IntWritable)broadcastKvReader.getCurrentValue()).get();
            }
            System.err.println("Count = " + this.getContext().getTaskIndex() + " * " + count + ", Sum=" + sum);
        }
    }

    public static class InputGenProcessor
    extends SimpleProcessor {
        final int bytesToGenerate;

        public InputGenProcessor(ProcessorContext context) {
            super(context);
            this.bytesToGenerate = context.getUserPayload().getPayload().getInt(0);
        }

        public void run() throws Exception {
            Random random = new Random();
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            LogicalOutput out = (LogicalOutput)this.getOutputs().values().iterator().next();
            if (out instanceof UnorderedKVOutput) {
                UnorderedKVOutput output = (UnorderedKVOutput)out;
                KeyValuesWriter kvWriter = output.getWriter();
                int approxNumInts = this.bytesToGenerate / 6;
                for (int i = 0; i < approxNumInts; ++i) {
                    kvWriter.write((Object)NullWritable.get(), (Object)new IntWritable(random.nextInt()));
                }
            }
        }
    }
}

