/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.common.hadoop;

import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.fs.azure.common.hadoop.LocatedHadoopFileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocatedFileStatus;

public class HadoopFileStatus
implements FileStatus {
    private final org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus fileStatus;

    public HadoopFileStatus(org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    public long getLen() {
        return this.fileStatus.getLen();
    }

    public long getBlockSize() {
        return Math.min(this.fileStatus.getBlockSize(), this.fileStatus.getLen());
    }

    public long getAccessTime() {
        return this.fileStatus.getAccessTime();
    }

    public long getModificationTime() {
        return this.fileStatus.getModificationTime();
    }

    public short getReplication() {
        return this.fileStatus.getReplication();
    }

    public Path getPath() {
        return new Path(this.fileStatus.getPath().toUri());
    }

    public boolean isDir() {
        return this.fileStatus.isDirectory();
    }

    public org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus getInternalFileStatus() {
        return this.fileStatus;
    }

    public static HadoopFileStatus fromHadoopStatus(org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus fileStatus) {
        return fileStatus instanceof LocatedFileStatus ? new LocatedHadoopFileStatus((LocatedFileStatus)fileStatus) : new HadoopFileStatus(fileStatus);
    }
}

