/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.analytics;

import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.LoggingOperations;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobListingDetails;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobRequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlob;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobDirectory;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.ListBlobItem;

class LogBlobIterator
implements Iterator<ListBlobItem> {
    private static final String HOUR_STRING = "yyyy/MM/dd/HH";
    private static final String DAY_STRING = "yyyy/MM/dd";
    private static final String MONTH_STRING = "yyyy/MM";
    private static final String YEAR_STRING = "yyyy";
    private static final DateFormat HOUR_FORMAT = new SimpleDateFormat("yyyy/MM/dd/HH");
    private static final DateFormat DAY_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final DateFormat MONTH_FORMAT = new SimpleDateFormat("yyyy/MM");
    private static final DateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private static final int HOUR_FORMAT_LENGTH = "yyyy/MM/dd/HH".length();
    private static final int DAY_FORMAT_LENGTH = "yyyy/MM/dd".length();
    private static final int MONTH_FORMAT_LENGTH = "yyyy/MM".length();
    private final CloudBlobDirectory logDirectory;
    private Calendar startDate = null;
    private Calendar endDate = null;
    private final EnumSet<LoggingOperations> operations;
    private final EnumSet<BlobListingDetails> details;
    private final BlobRequestOptions options;
    private final OperationContext opContext;
    private Iterator<ListBlobItem> currentIterator;
    private String currentPrefixTime = null;
    private String endPrefix;
    private Boolean isItemPending = false;
    private Boolean isExpired = false;
    private ListBlobItem pendingItem;

    public LogBlobIterator(CloudBlobDirectory logDirectory, Date startDate, Date endDate, EnumSet<LoggingOperations> operations, EnumSet<BlobListingDetails> details, BlobRequestOptions options, OperationContext opContext) {
        TimeZone gmtTime = TimeZone.getTimeZone("GMT");
        HOUR_FORMAT.setTimeZone(gmtTime);
        DAY_FORMAT.setTimeZone(gmtTime);
        MONTH_FORMAT.setTimeZone(gmtTime);
        YEAR_FORMAT.setTimeZone(gmtTime);
        this.logDirectory = logDirectory;
        this.operations = operations;
        this.details = details;
        this.opContext = opContext;
        this.options = options == null ? new BlobRequestOptions() : options;
        if (startDate != null) {
            this.startDate = new GregorianCalendar();
            this.startDate.setTime(startDate);
            this.startDate.add(12, -this.startDate.get(12));
            this.startDate.setTimeZone(gmtTime);
        }
        if (endDate != null) {
            this.endDate = new GregorianCalendar();
            this.endDate.setTime(endDate);
            this.endDate.setTimeZone(gmtTime);
            this.endPrefix = this.logDirectory.getPrefix() + HOUR_FORMAT.format(this.endDate.getTime());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isItemPending.booleanValue()) {
            return true;
        }
        try {
            if (this.currentIterator == null) {
                this.updateIterator();
            }
            while (!this.isExpired.booleanValue()) {
                while (this.currentIterator.hasNext()) {
                    ListBlobItem current = this.currentIterator.next();
                    if (this.endDate == null || current.getParent().getPrefix().compareTo(this.endPrefix) <= 0) {
                        if (!this.isCorrectLogType(current)) continue;
                        this.pendingItem = current;
                        this.isItemPending = true;
                        return true;
                    }
                    this.isExpired = true;
                    return false;
                }
                this.updateIterator();
            }
        }
        catch (StorageException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            NoSuchElementException ex = new NoSuchElementException("An error occurred while enumerating the result, check the original exception for details.");
            ex.initCause(e);
            throw ex;
        }
        return false;
    }

    @Override
    public ListBlobItem next() {
        if (this.isItemPending.booleanValue()) {
            this.isItemPending = false;
            return this.pendingItem;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException("There are no more elements in this enumeration.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean isCorrectLogType(ListBlobItem current) {
        HashMap<String, String> metadata = ((CloudBlob)current).getMetadata();
        String logType = metadata.get("LogType");
        if (logType == null) {
            return true;
        }
        if (this.operations.contains((Object)LoggingOperations.READ) && logType.contains("read")) {
            return true;
        }
        if (this.operations.contains((Object)LoggingOperations.WRITE) && logType.contains("write")) {
            return true;
        }
        return this.operations.contains((Object)LoggingOperations.DELETE) && logType.contains("delete");
    }

    private void updateIterator() throws StorageException, URISyntaxException {
        if (this.currentPrefixTime != null && this.currentPrefixTime.isEmpty()) {
            this.isExpired = true;
            return;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.add(11, 1);
        now.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.updatePrefix();
        if (!(this.startDate != null && this.startDate.compareTo(now) > 0 || this.endDate != null && (this.logDirectory.getPrefix() + this.currentPrefixTime).compareTo(this.endPrefix) > 0)) {
            this.currentIterator = this.logDirectory.listBlobs(this.currentPrefixTime, true, this.details, this.options, this.opContext).iterator();
        } else {
            this.isExpired = true;
        }
    }

    private void updatePrefix() {
        if (this.startDate == null) {
            this.currentPrefixTime = "";
        } else if (this.currentPrefixTime == null) {
            this.currentPrefixTime = HOUR_FORMAT.format(this.startDate.getTime());
        } else if (this.currentPrefixTime.length() == HOUR_FORMAT_LENGTH) {
            this.startDate.add(11, 1);
            this.currentPrefixTime = this.startDate.get(11) != 0 ? HOUR_FORMAT.format(this.startDate.getTime()) : DAY_FORMAT.format(this.startDate.getTime());
        } else if (this.currentPrefixTime.length() == DAY_FORMAT_LENGTH) {
            this.startDate.add(5, 1);
            this.currentPrefixTime = this.startDate.get(5) != 1 ? DAY_FORMAT.format(this.startDate.getTime()) : MONTH_FORMAT.format(this.startDate.getTime());
        } else if (this.currentPrefixTime.length() == MONTH_FORMAT_LENGTH) {
            this.startDate.add(2, 1);
            this.currentPrefixTime = this.startDate.get(2) != 13 ? MONTH_FORMAT.format(this.startDate.getTime()) : YEAR_FORMAT.format(this.startDate.getTime());
        } else {
            this.startDate.add(1, 1);
            this.currentPrefixTime = YEAR_FORMAT.format(this.startDate.getTime());
        }
    }
}

