/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.DoesServiceRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ResultContinuation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ResultSegment;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageUri;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobListingDetails;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobRequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudAppendBlob;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlob;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobClient;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobContainer;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlockBlob;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudPageBlob;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.ListBlobItem;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.PathUtility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

public final class CloudBlobDirectory
implements ListBlobItem {
    private final CloudBlobContainer container;
    private CloudBlobDirectory parent;
    private final CloudBlobClient blobServiceClient;
    private final StorageUri storageUri;
    private final String prefix;

    protected CloudBlobDirectory(StorageUri uri, String prefix, CloudBlobClient client, CloudBlobContainer container) {
        this(uri, prefix, client, container, null);
    }

    protected CloudBlobDirectory(StorageUri uri, String prefix, CloudBlobClient client, CloudBlobContainer container, CloudBlobDirectory parent) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("container", container);
        this.blobServiceClient = client;
        this.parent = parent;
        this.container = container;
        this.prefix = prefix;
        this.storageUri = uri;
    }

    public CloudAppendBlob getAppendBlobReference(String blobName) throws URISyntaxException, StorageException {
        return this.getAppendBlobReference(blobName, null);
    }

    public CloudAppendBlob getAppendBlobReference(String blobName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        return new CloudAppendBlob(this.getPrefix().concat(blobName), snapshotID, this.getContainer());
    }

    public CloudBlockBlob getBlockBlobReference(String blobName) throws URISyntaxException, StorageException {
        return this.getBlockBlobReference(blobName, null);
    }

    public CloudBlockBlob getBlockBlobReference(String blobName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        return new CloudBlockBlob(this.getPrefix().concat(blobName), snapshotID, this.getContainer());
    }

    @Override
    public CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        return this.container;
    }

    public CloudPageBlob getPageBlobReference(String blobName) throws URISyntaxException, StorageException {
        return this.getPageBlobReference(blobName, null);
    }

    public CloudPageBlob getPageBlobReference(String blobName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        return new CloudPageBlob(this.getPrefix().concat(blobName), snapshotID, this.getContainer());
    }

    @Override
    public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudBlob.getParentNameFromURI(this.getStorageUri(), this.blobServiceClient.getDirectoryDelimiter(), this.getContainer())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.container.getStorageUri(), parentName);
            this.parent = new CloudBlobDirectory(parentURI, parentName, this.blobServiceClient, this.getContainer());
        }
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public CloudBlobDirectory getDirectoryReference(String directoryName) throws URISyntaxException {
        Utility.assertNotNullOrEmpty("directoryName", directoryName);
        if (!directoryName.endsWith(this.blobServiceClient.getDirectoryDelimiter())) {
            directoryName = directoryName.concat(this.blobServiceClient.getDirectoryDelimiter());
        }
        String subDirName = this.getPrefix().concat(directoryName);
        StorageUri address = PathUtility.appendPathToUri(this.storageUri, directoryName, this.blobServiceClient.getDirectoryDelimiter());
        return new CloudBlobDirectory(address, subDirName, this.blobServiceClient, this.container, this);
    }

    @Override
    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobs(this.getPrefix());
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobsSegmented(this.getPrefix());
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, Integer maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, maxResults, continuationToken, options, opContext);
    }
}

