/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.diagnostics.ConfigurationValidator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics.ConfigurationBasicValidator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.Base64;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Base64StringConfigurationBasicValidator
extends ConfigurationBasicValidator<String>
implements ConfigurationValidator {
    public Base64StringConfigurationBasicValidator(String configKey, String defaultVal, boolean throwIfInvalid) {
        super(configKey, defaultVal, throwIfInvalid);
    }

    @Override
    public String validate(String configValue) throws InvalidConfigurationValueException {
        String result = (String)super.validate(configValue);
        if (result != null) {
            return result;
        }
        if (!Base64.validateIsBase64String(configValue)) {
            throw new InvalidConfigurationValueException(this.getConfigKey());
        }
        return configValue;
    }
}

