/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.HeapSort;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IndexedSortable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.IndexedSorter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class QuickSort
implements IndexedSorter {
    private static final IndexedSorter alt = new HeapSort();

    private static void fix(IndexedSortable s2, int p, int r) {
        if (s2.compare(p, r) > 0) {
            s2.swap(p, r);
        }
    }

    protected static int getMaxDepth(int x) {
        if (x <= 0) {
            throw new IllegalArgumentException("Undefined for " + x);
        }
        return 32 - Integer.numberOfLeadingZeros(x - 1) << 2;
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r) {
        this.sort(s2, p, r, null);
    }

    @Override
    public void sort(IndexedSortable s2, int p, int r, Progressable rep) {
        QuickSort.sortInternal(s2, p, r, rep, QuickSort.getMaxDepth(r - p));
    }

    private static void sortInternal(IndexedSortable s2, int p, int r, Progressable rep, int depth) {
        if (null != rep) {
            rep.progress();
        }
        while (true) {
            int j;
            int i;
            if (r - p < 13) {
                for (i = p; i < r; ++i) {
                    for (j = i; j > p && s2.compare(j - 1, j) > 0; --j) {
                        s2.swap(j, j - 1);
                    }
                }
                return;
            }
            if (--depth < 0) {
                alt.sort(s2, p, r, rep);
                return;
            }
            QuickSort.fix(s2, p + r >>> 1, p);
            QuickSort.fix(s2, p + r >>> 1, r - 1);
            QuickSort.fix(s2, p, r - 1);
            i = p;
            j = r;
            int ll = p;
            int rr = r;
            while (true) {
                int cr;
                if (++i < j && (cr = s2.compare(i, p)) <= 0) {
                    if (0 != cr || ++ll == i) continue;
                    s2.swap(ll, i);
                    continue;
                }
                while (--j > i && (cr = s2.compare(p, j)) <= 0) {
                    if (0 != cr || --rr == j) continue;
                    s2.swap(rr, j);
                }
                if (i >= j) break;
                s2.swap(i, j);
            }
            j = i;
            while (ll >= p) {
                s2.swap(ll--, --i);
            }
            while (rr < r) {
                s2.swap(rr++, j++);
            }
            assert (i != j);
            if (i - p < r - j) {
                QuickSort.sortInternal(s2, p, i, rep, depth);
                p = j;
                continue;
            }
            QuickSort.sortInternal(s2, j, r, rep, depth);
            r = i;
        }
    }
}

