/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.util.Random;

public class ExponentialRetryPolicy {
    private static final int DEFAULT_CLIENT_BACKOFF = 3000;
    private static final int DEFAULT_MAX_BACKOFF = 30000;
    private static final int DEFAULT_MIN_BACKOFF = 3000;
    private static final double MIN_RANDOM_RATIO = 0.8;
    private static final double MAX_RANDOM_RATIO = 1.2;
    private final Random randRef = new Random();
    private final int deltaBackoff;
    private final int maxBackoff;
    private final int minBackoff;
    private final int retryCount;

    public ExponentialRetryPolicy(int maxIoRetries) {
        this(maxIoRetries, 3000, 30000, 3000);
    }

    public ExponentialRetryPolicy(int retryCount, int minBackoff, int maxBackoff, int deltaBackoff) {
        this.retryCount = retryCount;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.deltaBackoff = deltaBackoff;
    }

    public boolean shouldRetry(int retryCount, int statusCode) {
        return retryCount < this.retryCount && (statusCode == -1 || statusCode == 408 || statusCode >= 500 && statusCode != 501 && statusCode != 505);
    }

    public long getRetryInterval(int retryCount) {
        long boundedRandDelta = (int)((double)this.deltaBackoff * 0.8) + this.randRef.nextInt((int)((double)this.deltaBackoff * 1.2) - (int)((double)this.deltaBackoff * 0.8));
        double incrementDelta = Math.pow(2.0, retryCount - 1) * (double)boundedRandDelta;
        long retryInterval = (int)Math.round(Math.min((double)this.minBackoff + incrementDelta, (double)this.maxBackoff));
        return retryInterval;
    }
}

