/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.util.Collections;
import java.util.List;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.utils.EventBuilder;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.TestTimerService;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class NFAIterativeConditionTimeContextTest
extends TestLogger {
    @Test
    public void testEventTimestamp() throws Exception {
        Event event = EventBuilder.event().withId(1).build();
        long timestamp = 3L;
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                return ctx.timestamp() == 3L;
            }
        });
        NFATestHarness testHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPattern = testHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)event, 3L));
        NFATestUtilities.comparePatterns(resultingPattern, Collections.singletonList(Collections.singletonList(event)));
    }

    @Test
    public void testCurrentProcessingTime() throws Exception {
        Event event1 = EventBuilder.event().withId(1).build();
        Event event2 = EventBuilder.event().withId(2).build();
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                return ctx.currentProcessingTime() == 3L;
            }
        });
        TestTimerService cepTimerService = new TestTimerService();
        NFATestHarness testHarness = NFATestHarness.forPattern(pattern).withTimerService(cepTimerService).build();
        cepTimerService.setCurrentProcessingTime(1L);
        List<List<Event>> resultingPatterns1 = testHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)event1, 7L));
        cepTimerService.setCurrentProcessingTime(3L);
        List<List<Event>> resultingPatterns2 = testHarness.feedRecord((StreamRecord<Event>)new StreamRecord((Object)event2, 8L));
        NFATestUtilities.comparePatterns(resultingPatterns1, Collections.emptyList());
        NFATestUtilities.comparePatterns(resultingPatterns2, Collections.singletonList(Collections.singletonList(event2)));
    }
}

