/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.WithinType;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class NotPatternITCase
extends TestLogger {
    @Test
    public void testNotNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notNext("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1, d}), Lists.newArrayList((Object[])new Event[]{a1, c2, d})}));
    }

    @Test
    public void testNotNextNoMatches() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c1 = new Event(41, "c", 2.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)c1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notNext("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void testNotNextNoMatchesAtTheEnd() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        Event b1 = new Event(42, "b", 3.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)c2, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)b1, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).notNext("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void testNotFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1, d})}));
    }

    @Test
    public void testNotFollowedByBeforeOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1, d})}));
    }

    @Test
    public void testTimesWithNotFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(41, "b", 2.0);
        Event c = new Event(42, "c", 3.0);
        Event b2 = new Event(43, "b", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)c, 3L));
        inputEvents.add(new StreamRecord((Object)b2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).times(2).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList());
    }

    @Test
    public void testIgnoreStateOfTimesWithNotFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event e = new Event(41, "e", 2.0);
        Event c1 = new Event(42, "c", 3.0);
        Event b1 = new Event(43, "b", 4.0);
        Event c2 = new Event(44, "c", 5.0);
        Event d1 = new Event(45, "d", 6.0);
        Event d2 = new Event(46, "d", 7.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)d1, 2L));
        inputEvents.add(new StreamRecord((Object)e, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d2, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).times(2).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, d1})}));
    }

    @Test
    public void testTimesWithNotFollowedByAfter() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event e = new Event(41, "e", 2.0);
        Event c1 = new Event(42, "c", 3.0);
        Event b1 = new Event(43, "b", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d1 = new Event(46, "d", 7.0);
        Event d2 = new Event(47, "d", 8.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)d1, 2L));
        inputEvents.add(new StreamRecord((Object)e, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)b2, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)d2, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).times(2).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList());
    }

    @Test
    public void testNotFollowedByBeforeOptionalAtTheEnd() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c2 = new Event(43, "c", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).optional();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1}), Lists.newArrayList((Object[])new Event[]{a1})}));
    }

    @Test
    public void testNotFollowedByBeforeOptionalTimes() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event c1 = new Event(41, "c", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c2 = new Event(43, "c", 4.0);
        Event d = new Event(43, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)c1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).times(2).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1, c2, d})}));
    }

    @Test
    public void testNotFollowedByWithBranchingAtStart() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c1 = new Event(41, "c", 2.0);
        Event a2 = new Event(41, "a", 4.0);
        Event c2 = new Event(43, "c", 5.0);
        Event d = new Event(43, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)c1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)c2, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a2, c2, d})}));
    }

    @Test
    public void testNotNextAfterOneOrMoreSkipTillNext() throws Exception {
        List<List<Event>> matches = this.testNotNextAfterOneOrMore(false);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void testNotNextAfterOneOrMoreSkipTillAny() throws Exception {
        List<List<Event>> matches = this.testNotNextAfterOneOrMore(true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_2, NotFollowByData.D_1})}));
    }

    private List<List<Event>> testNotNextAfterOneOrMore(boolean allMatches) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        int i = 0;
        inputEvents.add(new StreamRecord((Object)NotFollowByData.A_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.C_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_2, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.D_1, (long)i++));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a")));
        pattern = (allMatches ? pattern.followedByAny("b*") : pattern.followedBy("b*")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).oneOrMore().notNext("not c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testNotFollowedByNextAfterOneOrMoreEager() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByAfterOneOrMore(true, false);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void testNotFollowedByAnyAfterOneOrMoreEager() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByAfterOneOrMore(true, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_6, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByNextAfterOneOrMoreCombinations() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByAfterOneOrMore(false, false);
        Assert.assertEquals((long)0L, (long)matches.size());
    }

    @Test
    public void testNotFollowedByAnyAfterOneOrMoreCombinations() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByAfterOneOrMore(false, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_6, NotFollowByData.D_1})}));
    }

    private List<List<Event>> testNotFollowedByAfterOneOrMore(boolean eager, boolean allMatches) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        int i = 0;
        inputEvents.add(new StreamRecord((Object)NotFollowByData.A_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_2, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_3, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.C_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_4, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_5, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_6, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.D_1, (long)i));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a")));
        pattern = (allMatches ? pattern.followedByAny("b*") : pattern.followedBy("b*")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        pattern = (eager ? pattern.oneOrMore() : pattern.oneOrMore().allowCombinations()).notFollowedBy("not c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testNotFollowedByAnyBeforeOneOrMoreEager() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeOneOrMore(true, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByAnyBeforeOneOrMoreCombinations() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeOneOrMore(false, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByBeforeOneOrMoreEager() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeOneOrMore(true, false);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByBeforeOneOrMoreCombinations() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeOneOrMore(false, false);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    private List<List<Event>> testNotFollowedByBeforeOneOrMore(boolean eager, boolean allMatches) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        int i = 0;
        inputEvents.add(new StreamRecord((Object)NotFollowByData.A_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.C_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_4, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_5, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_6, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.D_1, (long)i));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("not c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")));
        pattern = (allMatches ? pattern.followedByAny("b*") : pattern.followedBy("b*")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).oneOrMore();
        pattern = (eager ? pattern : pattern.allowCombinations()).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testNotFollowedByBeforeZeroOrMoreEagerSkipTillNext() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeZeroOrMore(true, false);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByBeforeZeroOrMoreCombinationsSkipTillNext() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeZeroOrMore(false, false);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_6, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByBeforeZeroOrMoreEagerSkipTillAny() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeZeroOrMore(true, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1})}));
    }

    @Test
    public void testNotFollowedByBeforeZeroOrMoreCombinationsSkipTillAny() throws Exception {
        List<List<Event>> matches = this.testNotFollowedByBeforeZeroOrMore(false, true);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_4, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.B_6, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_5, NotFollowByData.D_1}), Lists.newArrayList((Object[])new Event[]{NotFollowByData.A_1, NotFollowByData.B_1, NotFollowByData.B_6, NotFollowByData.D_1})}));
    }

    private List<List<Event>> testNotFollowedByBeforeZeroOrMore(boolean eager, boolean allMatches) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        int i = 0;
        inputEvents.add(new StreamRecord((Object)NotFollowByData.A_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.C_1, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_4, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_5, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.B_6, (long)i++));
        inputEvents.add(new StreamRecord((Object)NotFollowByData.D_1, (long)i));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("not c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")));
        pattern = (allMatches ? pattern.followedByAny("b*") : pattern.followedBy("b*")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).oneOrMore().optional();
        pattern = (eager ? pattern : pattern.allowCombinations()).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        return NFATestUtilities.feedNFA(inputEvents, nfa);
    }

    @Test
    public void testNotFollowedByWithinFirstAndLastAtEnd() throws Exception {
        this.testNotFollowedByWithinAtEnd(WithinType.FIRST_AND_LAST);
    }

    @Test
    public void testNotFollowedByWithinPreviousAndCurrentAtEnd() throws Exception {
        this.testNotFollowedByWithinAtEnd(WithinType.PREVIOUS_AND_CURRENT);
    }

    public void testNotFollowedByWithinAtEnd(WithinType withinType) throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(41, "b", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event c = new Event(43, "c", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event a3 = new Event(45, "a", 7.0);
        Event b3 = new Event(46, "b", 8.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)c, 5L));
        inputEvents.add(new StreamRecord((Object)b2, 10L));
        inputEvents.add(new StreamRecord((Object)a3, 11L));
        inputEvents.add(new StreamRecord((Object)b3, 13L));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)3L), withinType);
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a2})}));
    }

    @Test
    public void testNotFollowByBeforeTimesWithin() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event b1 = new Event(41, "b", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event c1 = new Event(43, "c", 4.0);
        Event c2 = new Event(44, "c", 5.0);
        Event a3 = new Event(45, "a", 7.0);
        Event c3 = new Event(46, "c", 8.0);
        Event c4 = new Event(47, "c", 8.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 10L));
        inputEvents.add(new StreamRecord((Object)c1, 11L));
        inputEvents.add(new StreamRecord((Object)c2, 12L));
        inputEvents.add(new StreamRecord((Object)a3, 20L));
        inputEvents.add(new StreamRecord((Object)c3, 21L));
        inputEvents.add(new StreamRecord((Object)c4, 24L));
        Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).notFollowedBy("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).times(0, 2).within(Time.milliseconds((long)3L));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> matches = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(matches, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1}), Lists.newArrayList((Object[])new Event[]{a2}), Lists.newArrayList((Object[])new Event[]{a2, c1}), Lists.newArrayList((Object[])new Event[]{a2, c1, c2}), Lists.newArrayList((Object[])new Event[]{a3}), Lists.newArrayList((Object[])new Event[]{a3, c3})}));
    }

    @Test
    public void testNotFollowedByWithinAtEndAfterMatch() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(40, "a", 1.0);
        Event a2 = new Event(41, "a", 2.0);
        Event a3 = new Event(42, "a", 3.0);
        Event c1 = new Event(43, "c", 4.0);
        Event c2 = new Event(44, "c", 5.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)a2, 2L));
        inputEvents.add(new StreamRecord((Object)a3, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 4L));
        inputEvents.add(new StreamRecord((Object)c2, 10L));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().followedBy("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).notFollowedBy("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).within(Time.milliseconds((long)5L));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFATestHarness harness = NFATestHarness.forNFA(nfa).withAfterMatchSkipStrategy((AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).build();
        List<List<Event>> matches = harness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(matches, Collections.singletonList(Lists.newArrayList((Object[])new Event[]{a1, a2, a3, c1})));
    }

    private static class NotFollowByData {
        static final Event A_1 = new Event(40, "a", 1.0);
        static final Event B_1 = new Event(41, "b", 2.0);
        static final Event B_2 = new Event(42, "b", 3.0);
        static final Event B_3 = new Event(42, "b", 4.0);
        static final Event C_1 = new Event(43, "c", 5.0);
        static final Event B_4 = new Event(42, "b", 6.0);
        static final Event B_5 = new Event(42, "b", 7.0);
        static final Event B_6 = new Event(42, "b", 8.0);
        static final Event D_1 = new Event(43, "d", 9.0);

        private NotFollowByData() {
        }
    }
}

