/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.configuration.SharedBufferCacheConfig;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.utils.TestSharedBuffer;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SharedBufferTest
extends TestLogger {
    @Parameterized.Parameter
    public SharedBufferCacheConfig cacheConfig;

    @Parameterized.Parameters
    public static Collection<SharedBufferCacheConfig> prepareSharedBufferCacheConfig() {
        return Arrays.asList(new SharedBufferCacheConfig(1, 1, Duration.ofSeconds(1L)), new SharedBufferCacheConfig(10240, 10240, Duration.ofSeconds(1L)));
    }

    @Test
    public void testSharedBuffer() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 8;
        Event[] events = new Event[numberEvents];
        EventId[] eventIds = new EventId[numberEvents];
        long timestamp = 1L;
        for (int i = 0; i < numberEvents; ++i) {
            events[i] = new Event(i + 1, "e" + (i + 1), i);
            eventIds[i] = sharedBuffer.registerEvent(events[i], 1L);
        }
        HashMap expectedPattern1 = new HashMap();
        expectedPattern1.put("a1", new ArrayList());
        ((List)expectedPattern1.get("a1")).add(events[2]);
        expectedPattern1.put("a[]", new ArrayList());
        ((List)expectedPattern1.get("a[]")).add(events[3]);
        expectedPattern1.put("b", new ArrayList());
        ((List)expectedPattern1.get("b")).add(events[5]);
        HashMap expectedPattern2 = new HashMap();
        expectedPattern2.put("a1", new ArrayList());
        ((List)expectedPattern2.get("a1")).add(events[0]);
        expectedPattern2.put("a[]", new ArrayList());
        ((List)expectedPattern2.get("a[]")).add(events[1]);
        ((List)expectedPattern2.get("a[]")).add(events[2]);
        ((List)expectedPattern2.get("a[]")).add(events[3]);
        ((List)expectedPattern2.get("a[]")).add(events[4]);
        expectedPattern2.put("b", new ArrayList());
        ((List)expectedPattern2.get("b")).add(events[5]);
        HashMap expectedPattern3 = new HashMap();
        expectedPattern3.put("a1", new ArrayList());
        ((List)expectedPattern3.get("a1")).add(events[0]);
        expectedPattern3.put("a[]", new ArrayList());
        ((List)expectedPattern3.get("a[]")).add(events[1]);
        ((List)expectedPattern3.get("a[]")).add(events[2]);
        ((List)expectedPattern3.get("a[]")).add(events[3]);
        ((List)expectedPattern3.get("a[]")).add(events[4]);
        ((List)expectedPattern3.get("a[]")).add(events[5]);
        ((List)expectedPattern3.get("a[]")).add(events[6]);
        expectedPattern3.put("b", new ArrayList());
        ((List)expectedPattern3.get("b")).add(events[7]);
        try (SharedBufferAccessor sharedBufferAccessor = sharedBuffer.getAccessor();){
            NodeId a10 = sharedBufferAccessor.put("a1", eventIds[0], null, DeweyNumber.fromString((String)"1"));
            NodeId aLoop0 = sharedBufferAccessor.put("a[]", eventIds[1], a10, DeweyNumber.fromString((String)"1.0"));
            NodeId a11 = sharedBufferAccessor.put("a1", eventIds[2], null, DeweyNumber.fromString((String)"2"));
            NodeId aLoop1 = sharedBufferAccessor.put("a[]", eventIds[2], aLoop0, DeweyNumber.fromString((String)"1.0"));
            NodeId aLoop2 = sharedBufferAccessor.put("a[]", eventIds[3], aLoop1, DeweyNumber.fromString((String)"1.0"));
            NodeId aSecondLoop0 = sharedBufferAccessor.put("a[]", eventIds[3], a11, DeweyNumber.fromString((String)"2.0"));
            NodeId aLoop3 = sharedBufferAccessor.put("a[]", eventIds[4], aLoop2, DeweyNumber.fromString((String)"1.0"));
            DeweyNumber b0Version = DeweyNumber.fromString((String)"1.0.0");
            NodeId b0 = sharedBufferAccessor.put("b", eventIds[5], aLoop3, b0Version);
            NodeId aLoop4 = sharedBufferAccessor.put("a[]", eventIds[5], aLoop3, DeweyNumber.fromString((String)"1.1"));
            DeweyNumber b1Version = DeweyNumber.fromString((String)"2.0.0");
            NodeId b1 = sharedBufferAccessor.put("b", eventIds[5], aSecondLoop0, b1Version);
            NodeId aLoop5 = sharedBufferAccessor.put("a[]", eventIds[6], aLoop4, DeweyNumber.fromString((String)"1.1"));
            DeweyNumber b3Version = DeweyNumber.fromString((String)"1.1.0");
            NodeId b3 = sharedBufferAccessor.put("b", eventIds[7], aLoop5, b3Version);
            sharedBufferAccessor.lockNode(b0, b0Version);
            sharedBufferAccessor.lockNode(b1, b1Version);
            sharedBufferAccessor.lockNode(b3, b3Version);
            List patterns3 = sharedBufferAccessor.extractPatterns(b3, b3Version);
            Assert.assertEquals((long)1L, (long)patterns3.size());
            Assert.assertEquals(expectedPattern3, (Object)sharedBufferAccessor.materializeMatch((Map)patterns3.get(0)));
            sharedBufferAccessor.releaseNode(b3, b3Version);
            List patterns4 = sharedBufferAccessor.extractPatterns(b3, b3Version);
            Assert.assertEquals((long)0L, (long)patterns4.size());
            Assert.assertTrue((boolean)patterns4.isEmpty());
            List patterns1 = sharedBufferAccessor.extractPatterns(b1, b1Version);
            Assert.assertEquals((long)1L, (long)patterns1.size());
            Assert.assertEquals(expectedPattern1, (Object)sharedBufferAccessor.materializeMatch((Map)patterns1.get(0)));
            sharedBufferAccessor.releaseNode(b1, b1Version);
            List patterns2 = sharedBufferAccessor.extractPatterns(b0, b0Version);
            Assert.assertEquals((long)1L, (long)patterns2.size());
            Assert.assertEquals(expectedPattern2, (Object)sharedBufferAccessor.materializeMatch((Map)patterns2.get(0)));
            sharedBufferAccessor.releaseNode(b0, b0Version);
            for (EventId eventId : eventIds) {
                sharedBufferAccessor.releaseEvent(eventId);
            }
        }
        Assert.assertTrue((boolean)sharedBuffer.isEmpty());
    }

    @Test
    public void testClearingSharedBufferWithMultipleEdgesBetweenEntries() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 8;
        Event[] events = new Event[numberEvents];
        EventId[] eventIds = new EventId[numberEvents];
        long timestamp = 1L;
        for (int i = 0; i < numberEvents; ++i) {
            events[i] = new Event(i + 1, "e" + (i + 1), i);
            eventIds[i] = sharedBuffer.registerEvent(events[i], 1L);
        }
        try (SharedBufferAccessor sharedBufferAccessor = sharedBuffer.getAccessor();){
            NodeId start = sharedBufferAccessor.put("start", eventIds[1], null, DeweyNumber.fromString((String)"1"));
            NodeId b0 = sharedBufferAccessor.put("branching", eventIds[2], start, DeweyNumber.fromString((String)"1.0"));
            NodeId b1 = sharedBufferAccessor.put("branching", eventIds[3], start, DeweyNumber.fromString((String)"1.1"));
            NodeId b00 = sharedBufferAccessor.put("branching", eventIds[3], b0, DeweyNumber.fromString((String)"1.0.0"));
            sharedBufferAccessor.put("branching", eventIds[4], b00, DeweyNumber.fromString((String)"1.0.0.0"));
            NodeId b10 = sharedBufferAccessor.put("branching", eventIds[4], b1, DeweyNumber.fromString((String)"1.1.0"));
            sharedBufferAccessor.lockNode(b0, DeweyNumber.fromString((String)"1.0"));
            sharedBufferAccessor.releaseNode(b10, DeweyNumber.fromString((String)"1.1.0"));
            for (EventId eventId : eventIds) {
                sharedBufferAccessor.releaseEvent(eventId);
            }
        }
        Assert.assertFalse((boolean)sharedBuffer.isEmpty());
    }

    @Test
    public void testSharedBufferExtractOrder() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 5;
        Event[] events = new Event[numberEvents];
        EventId[] eventIds = new EventId[numberEvents];
        long timestamp = 1L;
        for (int i = 0; i < numberEvents; ++i) {
            events[i] = new Event(i + 1, "e" + (i + 1), i);
            eventIds[i] = sharedBuffer.registerEvent(events[i], 1L);
        }
        LinkedHashMap expectedResult = new LinkedHashMap();
        expectedResult.put("a", new ArrayList());
        ((List)expectedResult.get("a")).add(events[0]);
        expectedResult.put("b", new ArrayList());
        ((List)expectedResult.get("b")).add(events[1]);
        expectedResult.put("aa", new ArrayList());
        ((List)expectedResult.get("aa")).add(events[2]);
        expectedResult.put("bb", new ArrayList());
        ((List)expectedResult.get("bb")).add(events[3]);
        expectedResult.put("c", new ArrayList());
        ((List)expectedResult.get("c")).add(events[4]);
        try (SharedBufferAccessor sharedBufferAccessor = sharedBuffer.getAccessor();){
            NodeId a = sharedBufferAccessor.put("a", eventIds[0], null, DeweyNumber.fromString((String)"1"));
            NodeId b = sharedBufferAccessor.put("b", eventIds[1], a, DeweyNumber.fromString((String)"1.0"));
            NodeId aa = sharedBufferAccessor.put("aa", eventIds[2], b, DeweyNumber.fromString((String)"1.0.0"));
            NodeId bb = sharedBufferAccessor.put("bb", eventIds[3], aa, DeweyNumber.fromString((String)"1.0.0.0"));
            NodeId c = sharedBufferAccessor.put("c", eventIds[4], bb, DeweyNumber.fromString((String)"1.0.0.0.0"));
            Map patternsResult = sharedBufferAccessor.materializeMatch((Map)sharedBufferAccessor.extractPatterns(c, DeweyNumber.fromString((String)"1.0.0.0.0")).get(0));
            ArrayList<String> expectedOrder = new ArrayList<String>();
            expectedOrder.add("a");
            expectedOrder.add("b");
            expectedOrder.add("aa");
            expectedOrder.add("bb");
            expectedOrder.add("c");
            for (EventId eventId : eventIds) {
                sharedBufferAccessor.releaseEvent(eventId);
            }
            ArrayList resultOrder = new ArrayList(patternsResult.keySet());
            Assert.assertEquals(expectedOrder, resultOrder);
        }
    }

    @Test
    public void testSharedBufferCountersClearing() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 4;
        Event[] events = new Event[numberEvents];
        for (int i = 0; i < numberEvents; ++i) {
            events[i] = new Event(i + 1, "e" + (i + 1), i);
            sharedBuffer.registerEvent(events[i], i);
        }
        sharedBuffer.advanceTime(3L);
        Iterator counters = sharedBuffer.getEventCounters();
        Map.Entry entry = (Map.Entry)counters.next();
        Assert.assertEquals((long)3L, (long)((Long)entry.getKey()));
        Assert.assertEquals((long)1L, (long)((Integer)entry.getValue()).intValue());
        Assert.assertFalse((boolean)counters.hasNext());
    }

    @Test
    public void testSharedBufferAccessor() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 8;
        Event[] events = new Event[numberEvents];
        EventId[] eventIds = new EventId[numberEvents];
        long timestamp = 1L;
        try (SharedBufferAccessor sharedBufferAccessor = sharedBuffer.getAccessor();){
            for (int i = 0; i < numberEvents; ++i) {
                events[i] = new Event(i + 1, "e" + (i + 1), i);
                eventIds[i] = sharedBufferAccessor.registerEvent((Object)events[i], 1L);
            }
            int expectedEvents = Math.min(this.cacheConfig.getEventsBufferCacheSlots(), numberEvents);
            Assert.assertEquals((long)expectedEvents, (long)sharedBuffer.getEventsBufferCacheSize());
            Assert.assertEquals((long)0L, (long)sharedBuffer.getSharedBufferNodeCacheSize());
            NodeId start = sharedBufferAccessor.put("start", eventIds[1], null, DeweyNumber.fromString((String)"1"));
            NodeId b0 = sharedBufferAccessor.put("branching", eventIds[2], start, DeweyNumber.fromString((String)"1.0"));
            NodeId b1 = sharedBufferAccessor.put("branching", eventIds[3], start, DeweyNumber.fromString((String)"1.1"));
            NodeId b00 = sharedBufferAccessor.put("branching", eventIds[3], b0, DeweyNumber.fromString((String)"1.0.0"));
            sharedBufferAccessor.put("branching", eventIds[4], b00, DeweyNumber.fromString((String)"1.0.0.0"));
            int expectedEntries = Math.min(this.cacheConfig.getEntryCacheSlots(), 4);
            Assert.assertEquals((long)expectedEntries, (long)sharedBuffer.getSharedBufferNodeCacheSize());
            System.out.println(expectedEntries);
            Assert.assertEquals((long)(4 - expectedEntries), (long)sharedBuffer.getSharedBufferNodeSize());
            sharedBufferAccessor.lockNode(b0, DeweyNumber.fromString((String)"1.0.0"));
            for (EventId eventId : eventIds) {
                sharedBufferAccessor.releaseEvent(eventId);
            }
        }
        Assert.assertEquals((long)0L, (long)sharedBuffer.getEventsBufferCacheSize());
        Assert.assertEquals((long)4L, (long)sharedBuffer.getEventsBufferSize());
        Assert.assertEquals((long)0L, (long)sharedBuffer.getSharedBufferNodeCacheSize());
        Assert.assertEquals((long)4L, (long)sharedBuffer.getSharedBufferNodeSize());
    }

    @Test
    public void testReleaseNodesWithLongPath() throws Exception {
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer(), this.cacheConfig);
        int numberEvents = 100000;
        Event[] events = new Event[100000];
        EventId[] eventIds = new EventId[100000];
        NodeId[] nodeIds = new NodeId[100000];
        long timestamp = 1L;
        for (int i = 0; i < 100000; ++i) {
            events[i] = new Event(i + 1, "e" + (i + 1), i);
            eventIds[i] = sharedBuffer.registerEvent(events[i], 1L);
        }
        try (SharedBufferAccessor sharedBufferAccessor = sharedBuffer.getAccessor();){
            for (int i = 0; i < 100000; ++i) {
                NodeId prevId = i == 0 ? null : nodeIds[i - 1];
                nodeIds[i] = sharedBufferAccessor.put("n" + i, eventIds[i], prevId, DeweyNumber.fromString((String)"1.0"));
            }
            NodeId lastNode = nodeIds[99999];
            sharedBufferAccessor.releaseNode(lastNode, DeweyNumber.fromString((String)"1.0"));
            for (int i = 0; i < 100000; ++i) {
                sharedBufferAccessor.releaseEvent(eventIds[i]);
            }
        }
        Assert.assertTrue((boolean)sharedBuffer.isEmpty());
    }
}

