/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBuffer;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.time.TimerService;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.cep.utils.TestSharedBuffer;
import org.apache.flink.cep.utils.TestTimerService;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public final class NFATestHarness {
    private final SharedBuffer<Event> sharedBuffer;
    private final NFA<Event> nfa;
    private final NFAState nfaState;
    private final AfterMatchSkipStrategy afterMatchSkipStrategy;
    private final TimerService timerService;

    private NFATestHarness(SharedBuffer<Event> sharedBuffer, NFA<Event> nfa, NFAState nfaState, AfterMatchSkipStrategy afterMatchSkipStrategy, TimerService timerService) {
        this.sharedBuffer = sharedBuffer;
        this.nfa = nfa;
        this.nfaState = nfaState;
        this.afterMatchSkipStrategy = afterMatchSkipStrategy;
        this.timerService = timerService;
    }

    public static NFATestHarnessBuilderPattern forPattern(Pattern<Event, ?> pattern) {
        return new NFATestHarnessBuilderPattern(pattern);
    }

    public static NFATestHarnessBuilderNFA forNFA(NFA<Event> nfa) {
        return new NFATestHarnessBuilderNFA(nfa);
    }

    public List<List<Event>> feedRecords(List<StreamRecord<Event>> inputEvents) throws Exception {
        ArrayList<List<Event>> resultingPatterns = new ArrayList<List<Event>>();
        for (StreamRecord<Event> inputEvent : inputEvents) {
            resultingPatterns.addAll(this.feedRecord(inputEvent));
        }
        return resultingPatterns;
    }

    public List<List<Event>> feedRecord(StreamRecord<Event> inputEvent) throws Exception {
        ArrayList<List<Event>> resultingPatterns = new ArrayList<List<Event>>();
        Collection<Map<String, List<Event>>> matches = this.consumeRecord(inputEvent);
        for (Map<String, List<Event>> p : matches) {
            ArrayList<Event> res = new ArrayList<Event>();
            for (List<Event> le : p.values()) {
                res.addAll(le);
            }
            resultingPatterns.add(res);
        }
        return resultingPatterns;
    }

    public Collection<Map<String, List<Event>>> consumeRecords(Collection<StreamRecord<Event>> inputEvents) throws Exception {
        ArrayList<Map<String, List<Event>>> resultingPatterns = new ArrayList<Map<String, List<Event>>>();
        for (StreamRecord<Event> inputEvent : inputEvents) {
            resultingPatterns.addAll(this.consumeRecord(inputEvent));
        }
        return resultingPatterns;
    }

    public Collection<Map<String, List<Event>>> consumeRecord(StreamRecord<Event> inputEvent) throws Exception {
        try (SharedBufferAccessor sharedBufferAccessor = this.sharedBuffer.getAccessor();){
            Collection pendingMatches = (Collection)this.nfa.advanceTime((SharedBufferAccessor)sharedBufferAccessor, (NFAState)this.nfaState, (long)inputEvent.getTimestamp(), (AfterMatchSkipStrategy)this.afterMatchSkipStrategy).f0;
            Collection matchedPatterns = this.nfa.process(sharedBufferAccessor, this.nfaState, inputEvent.getValue(), inputEvent.getTimestamp(), this.afterMatchSkipStrategy, this.timerService);
            matchedPatterns.addAll(pendingMatches);
            Collection collection = matchedPatterns;
            return collection;
        }
    }

    public static abstract class NFATestHarnessBuilderBase {
        SharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer());
        AfterMatchSkipStrategy afterMatchSkipStrategy;
        TimerService timerService = new TestTimerService();

        NFATestHarnessBuilderBase(AfterMatchSkipStrategy skipStrategy) {
            this.afterMatchSkipStrategy = skipStrategy;
        }

        public NFATestHarnessBuilderBase withSharedBuffer(SharedBuffer<Event> sharedBuffer) {
            this.sharedBuffer = sharedBuffer;
            return this;
        }

        public NFATestHarnessBuilderBase withAfterMatchSkipStrategy(AfterMatchSkipStrategy afterMatchSkipStrategy) {
            this.afterMatchSkipStrategy = afterMatchSkipStrategy;
            return this;
        }

        public NFATestHarnessBuilderBase withTimerService(TimerService timerService) {
            this.timerService = timerService;
            return this;
        }

        public abstract NFATestHarness build();
    }

    public static class NFATestHarnessBuilderNFA
    extends NFATestHarnessBuilderBase {
        private final NFA<Event> nfa;
        private NFAState nfaState;

        NFATestHarnessBuilderNFA(NFA<Event> nfa) {
            super((AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
            this.nfa = nfa;
            this.nfaState = nfa.createInitialNFAState();
        }

        public NFATestHarnessBuilderBase withNFAState(NFAState nfaState) {
            this.nfaState = nfaState;
            return this;
        }

        @Override
        public NFATestHarness build() {
            return new NFATestHarness(this.sharedBuffer, this.nfa, this.nfaState, this.afterMatchSkipStrategy, this.timerService);
        }
    }

    public static class NFATestHarnessBuilderPattern
    extends NFATestHarnessBuilderBase {
        private final Pattern<Event, ?> pattern;
        private boolean timeoutHandling = false;

        NFATestHarnessBuilderPattern(Pattern<Event, ?> pattern) {
            super(pattern.getAfterMatchSkipStrategy());
            this.pattern = pattern;
        }

        public NFATestHarnessBuilderBase withTimeoutHandling() {
            this.timeoutHandling = true;
            return this;
        }

        @Override
        public NFATestHarness build() {
            NFA<Event> nfa = NFAUtils.compile(this.pattern, this.timeoutHandling);
            return new NFATestHarness(this.sharedBuffer, nfa, nfa.createInitialNFAState(), this.afterMatchSkipStrategy, this.timerService);
        }
    }
}

