/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.util.Queue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

public class OutputAsserter {
    private final Queue<?> output;

    private OutputAsserter(Queue<?> output) {
        this.output = output;
    }

    public static OutputAsserter assertOutput(Queue<?> output) {
        return new OutputAsserter(output);
    }

    private AssertionError fail(Object record) {
        return new AssertionError((Object)("Received unexpected element: " + record));
    }

    public <T> OutputAsserter nextElementEquals(T expected) {
        Object record = this.output.poll();
        Object actual = record instanceof StreamRecord ? ((StreamRecord)record).getValue() : record;
        Assert.assertThat(actual, (Matcher)Is.is(expected));
        return this;
    }

    public void hasNoMoreElements() {
        Assert.assertTrue((boolean)this.output.isEmpty());
    }

    public OutputAsserter watermarkEquals(long timestamp) {
        Object record = this.output.poll();
        if (!(record instanceof Watermark)) {
            throw this.fail(record);
        }
        Watermark watermark = (Watermark)record;
        Assert.assertThat((Object)watermark.getTimestamp(), (Matcher)Is.is((Object)timestamp));
        return this;
    }
}

