/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.client.JobInitializationException;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ClientUtilsTest
extends TestLogger {
    private static final JobID TESTING_JOB_ID = new JobID();

    @Test
    public void testWaitUntilJobInitializationFinished_throwsInitializationException() {
        Iterator<JobStatus> statusSequenceIterator = Arrays.asList(JobStatus.INITIALIZING, JobStatus.INITIALIZING, JobStatus.FAILED).iterator();
        CommonTestUtils.assertThrows((String)"Something is wrong", JobInitializationException.class, () -> {
            ClientUtils.waitUntilJobInitializationFinished(statusSequenceIterator::next, () -> {
                JobInitializationException throwable = new JobInitializationException(TESTING_JOB_ID, "Something is wrong", (Throwable)new RuntimeException("Err"));
                return this.buildJobResult((Throwable)throwable);
            }, (ClassLoader)ClassLoader.getSystemClassLoader());
            return null;
        });
    }

    @Test
    public void testWaitUntilJobInitializationFinished_doesNotThrowRuntimeException() throws Exception {
        Iterator<JobStatus> statusSequenceIterator = Arrays.asList(JobStatus.INITIALIZING, JobStatus.INITIALIZING, JobStatus.FAILED).iterator();
        ClientUtils.waitUntilJobInitializationFinished(statusSequenceIterator::next, () -> this.buildJobResult(new RuntimeException("Err")), (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testWaitUntilJobInitializationFinished_throwsOtherErrors() {
        CommonTestUtils.assertThrows((String)"Error while waiting for job to be initialized", RuntimeException.class, () -> {
            ClientUtils.waitUntilJobInitializationFinished(() -> {
                throw new RuntimeException("other error");
            }, () -> {
                JobInitializationException throwable = new JobInitializationException(TESTING_JOB_ID, "Something is wrong", (Throwable)new RuntimeException("Err"));
                return this.buildJobResult((Throwable)throwable);
            }, (ClassLoader)ClassLoader.getSystemClassLoader());
            return null;
        });
    }

    private JobResult buildJobResult(Throwable throwable) {
        return new JobResult.Builder().jobId(TESTING_JOB_ID).serializedThrowable(new SerializedThrowable(throwable)).netRuntime(1L).build();
    }

    @Test
    public void testWaitUntilJobInitializationFinished_regular() throws Exception {
        Iterator<JobStatus> statusSequenceIterator = Arrays.asList(JobStatus.INITIALIZING, JobStatus.INITIALIZING, JobStatus.RUNNING).iterator();
        ClientUtils.waitUntilJobInitializationFinished(statusSequenceIterator::next, () -> {
            Assert.fail((String)"unexpected call");
            return null;
        }, (ClassLoader)ClassLoader.getSystemClassLoader());
    }
}

