/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionEnvironmentTest
extends TestLogger
implements Serializable {
    @Test
    public void testExecuteAfterGetExecutionPlanContextEnvironment() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource baseSet = env.fromElements((Object[])new Integer[]{1, 2});
        MapOperator result = baseSet.map((MapFunction & Serializable)value -> value * 2);
        result.output((OutputFormat)new DiscardingOutputFormat());
        try {
            env.getExecutionPlan();
            env.getExecutionPlan();
        }
        catch (Exception e) {
            TestCase.fail((String)"Consecutive #getExecutionPlan calls caused an exception.");
        }
    }

    @Test
    public void testDefaultJobName() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.testJobName("Flink Java Job at", env);
    }

    @Test
    public void testUserDefinedJobName() {
        String jobName = "MyTestJob";
        Configuration config = new Configuration();
        config.set(PipelineOptions.NAME, (Object)jobName);
        LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((Configuration)config);
        this.testJobName(jobName, (ExecutionEnvironment)env);
    }

    @Test
    public void testUserDefinedJobNameWithConfigure() {
        String jobName = "MyTestJob";
        Configuration config = new Configuration();
        config.set(PipelineOptions.NAME, (Object)jobName);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.configure((ReadableConfig)config, this.getClass().getClassLoader());
        this.testJobName(jobName, env);
    }

    private void testJobName(String prefixOfExpectedJobName, ExecutionEnvironment env) {
        env.fromElements((Object[])new Integer[]{1, 2, 3}).writeAsText("/dev/null");
        Plan plan = env.createProgramPlan();
        Assert.assertTrue((boolean)plan.getJobName().startsWith(prefixOfExpectedJobName));
    }
}

