/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.util.MockedCliFrontend;
import org.apache.flink.client.program.TestingClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.messages.Acknowledge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CliFrontendCancelTest
extends CliFrontendTestBase {
    @BeforeClass
    public static void init() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Test
    public void testCancel() throws Exception {
        JobID jid = new JobID();
        OneShotLatch cancelLatch = new OneShotLatch();
        String[] parameters = new String[]{jid.toString()};
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setCancelFunction(jobID -> {
            cancelLatch.trigger();
            return CompletableFuture.completedFuture(Acknowledge.get());
        });
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.cancel(parameters);
        cancelLatch.await();
    }

    @Test(expected=CliArgsException.class)
    public void testMissingJobId() throws Exception {
        String[] parameters = new String[]{};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendCancelTest.getCli()));
        testFrontend.cancel(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testUnrecognizedOption() throws Exception {
        String[] parameters = new String[]{"-v", "-l"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendCancelTest.getCli()));
        testFrontend.cancel(parameters);
    }

    @Test
    public void testCancelWithSavepoint() throws Exception {
        JobID jid = new JobID();
        OneShotLatch cancelWithSavepointLatch = new OneShotLatch();
        String[] parameters = new String[]{"-s", jid.toString()};
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setCancelWithSavepointFunction((jobID, savepointDirectory) -> {
            Assert.assertNull((Object)savepointDirectory);
            cancelWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        });
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.cancel(parameters);
        cancelWithSavepointLatch.await();
        jid = new JobID();
        cancelWithSavepointLatch = new OneShotLatch();
        parameters = new String[]{"-s", "targetDirectory", jid.toString()};
        clusterClient = new TestingClusterClient();
        clusterClient.setCancelWithSavepointFunction((jobID, savepointDirectory) -> {
            Assert.assertNotNull((Object)savepointDirectory);
            cancelWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        });
        testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.cancel(parameters);
        cancelWithSavepointLatch.await();
    }

    @Test(expected=CliArgsException.class)
    public void testCancelWithSavepointWithoutJobId() throws Exception {
        String[] parameters = new String[]{"-s", "targetDirectory"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendCancelTest.getCli()));
        testFrontend.cancel(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testCancelWithSavepointWithoutParameters() throws Exception {
        String[] parameters = new String[]{"-s"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendCancelTest.getCli()));
        testFrontend.cancel(parameters);
    }
}

